SetCrateRotationEvent = {};
SetCrateRotationEvent_mt = Class(SetCrateRotationEvent, Event);
 
InitEventClass(SetCrateRotationEvent, "SetCrateRotationEvent");

function SetCrateRotationEvent:emptyNew()
      local self = Event:new(SetCrateRotationEvent_mt);
      self.className="SetCrateRotationEvent";
      return self;
end;
 
function SetCrateRotationEvent:new(object, rotationMax1)
     local self = SetCrateRotationEvent:emptyNew()
     self.object = object;
     self.rotationMax1 = rotationMax1;
      return self;
end;

function SetCrateRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationMax1 = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetCrateRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax1);
end;

function SetCrateRotationEvent:run(connection)
     self.object:setRotationMax1(self.rotationMax1, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetCrateRotationEvent:new(self.object, self.rotationMax1), nil, connection, self.object);
     end;
end;