--
-- PowerShaftAttacher
-- Specialization for PowerShaftAttacher
--
-- @author  Manuel Leithner
-- @date  26/07/09
--modification by xyzspain

PowerAllAttacher = {};

function PowerAllAttacher.prerequisitesPresent(specializations)
    return true;
end;

function PowerAllAttacher:load(xmlFile)

	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local allAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#all"));
		if allAttacher ~= nil then
			joint.powerAllAttacher = allAttacher;
		end;
		
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local allAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#all"));
		if allAttacher ~= nil then
			joint.powerAllAttacher = allAttacher;
		end;
        i = i+1;
    end;	
end;

function PowerAllAttacher:delete()
end;

function PowerAllAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerAllAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerAllAttacher:update(dt)
end;

function PowerAllAttacher:draw()
end;




