--
-- Specialization for a baler.
--
-- author  	Henly20 
-- date  	19-12-2010.
-- www.ls-uk.info
-- ALL RIGHTS RESERVED
  
Ferg_Baler = {};
  
function Ferg_Baler.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Baler, specializations);
end;
  
function Ferg_Baler:load(xmlFile)

	  self.setTransRot = SpecializationUtil.callSpecializationsFunction("setTransRot");
	  self.TransRotAnimation = getXMLString(xmlFile, "vehicle.TransRot#animationName");
	  self.TransRot = false;

	  self.balerParticleSystems = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.balerParticleSystems.balerParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.balerParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
      end;
	  
	self.drumNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index"));
	self.drumNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index1"));
	self.drumNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index2"));
    self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);

	local rotationPartNodePacker = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Packer#index"));
    if rotationPartNodePacker ~= nil then
        self.rotationPartPacker = {};
        self.rotationPartPacker.node = rotationPartNodePacker;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPacker#minRot"));
        self.rotationPartPacker.minRot = {};
        self.rotationPartPacker.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Packer#maxRot"));
        self.rotationPartPacker.maxRot = {};
        self.rotationPartPacker.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPacker.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer#rotTime"), 2)*1000;
        self.rotationPartPacker.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer#touchRotLimit"), 10));
    end
 
	local rotationPartNodePacker2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Packer2#index"));
    if rotationPartNodePacker2 ~= nil then
        self.rotationPartPacker2 = {};
        self.rotationPartPacker2.node = rotationPartNodePacker2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPacker2#minRot"));
        self.rotationPartPacker2.minRot = {};
        self.rotationPartPacker2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Packer2#maxRot"));
        self.rotationPartPacker2.maxRot = {};
        self.rotationPartPacker2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPacker2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer2#rotTime"), 2)*1000;
        self.rotationPartPacker2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer2#touchRotLimit"), 10));
    end
	
	local rotationPartNodePacker3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Packer3#index"));
    if rotationPartNodePacker3 ~= nil then
        self.rotationPartPacker3 = {};
        self.rotationPartPacker3.node = rotationPartNodePacker3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPacker3#minRot"));
        self.rotationPartPacker3.minRot = {};
        self.rotationPartPacker3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Packer3#maxRot"));
        self.rotationPartPacker3.maxRot = {};
        self.rotationPartPacker3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPacker3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPacker3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPacker3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer3#rotTime"), 2)*1000;
        self.rotationPartPacker3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Packer3#touchRotLimit"), 10));
    end

	self.pto = {};
	self.pto[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pto#index1"));
	self.pto[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pto#index2"));
	
	setVisibility(self.pto[1], false);
	setVisibility(self.pto[2], true); 
	
	
	self.Packer = false;
	self.test = 300;
	
	self.isTurnedOn = false;	
    self.bales = {};

end;
  
function Ferg_Baler:delete()
	Utils.deleteParticleSystem(self.balerParticleSystems);
 
end;
  
function Ferg_Baler:readStream(streamId, connection)
	  
      self:setTransRot(streamReadBool(streamId), true);
end;
  
function Ferg_Baler:writeStream(streamId, connection)
	  
      streamWriteBool(streamId, self.TransRot);
end;
  
function Ferg_Baler:readUpdateStream(streamId, timestamp, connection)
end;
  
function Ferg_Baler:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Ferg_Baler:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function Ferg_Baler:keyEvent(unicode, sym, modifier, isDown)

end;
  
function Ferg_Baler:update(dt)
  
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
             self:setTransRot(not self.isTransRotOn);
          end;
      end;
	  
end;
  
function Ferg_Baler:updateTick(dt)
    if self:getIsActive() then
          if not self.isTransRotOn then
				self.isTurnedOn = false;
          end;
        if self.isTurnedOn then
			if self.drumNode1 ~= nil then
				rotate(self.drumNode1, self.drumRotationScale * -2 * 1, 0, 0);
			end;
			if self.drumNode2 ~= nil then
				rotate(self.drumNode2, self.drumRotationScale * 2 * -1, 0, 0);
			end;
			if self.drumNode3 ~= nil then
				rotate(self.drumNode3, self.drumRotationScale * 5 * 0, 0, 5);
			end;
			self.test = self.test - dt;
			if self.test < 0 then
				self.rotationMaxPacker = not self.rotationMaxPacker;
				self.rotationMaxPacker2 = not self.rotationMaxPacker2;
				self.rotationMaxPacker3 = not self.rotationMaxPacker3;
				self.test = 300;
			end;
		end;
		
		if self.rotationPartPacker ~= nil then
			local x, y, z = getRotation(self.rotationPartPacker.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPacker.maxRot, self.rotationPartPacker.minRot, 3, self.rotationPartPacker.rotTime, dt, not self.rotationMaxPacker);
			setRotation(self.rotationPartPacker.node, unpack(newRot));
		end	
		if self.rotationPartPacker2 ~= nil then
			local x, y, z = getRotation(self.rotationPartPacker2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPacker2.maxRot, self.rotationPartPacker2.minRot, 3, self.rotationPartPacker2.rotTime, dt, not self.rotationMaxPacker2);
			setRotation(self.rotationPartPacker2.node, unpack(newRot));
		end		
		if self.rotationPartPacker3 ~= nil then
			local x, y, z = getRotation(self.rotationPartPacker3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPacker3.maxRot, self.rotationPartPacker3.minRot, 3, self.rotationPartPacker3.rotTime, dt, not self.rotationMaxPacker3);
			setRotation(self.rotationPartPacker3.node, unpack(newRot));
		end	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	
        if self.dropBales then		
		    if table.getn(self.bales) > 0 then
                   Ferg_Baler.dropBale(self, 1);
                if self.isServer then
                   self:setFillLevel(0, self.currentFillType);
                end;
			end;
        end;
	if not self.isTransRotOn then
		self.fillLevel = 0;
		self.dropBales = true;
			setVisibility(self.pto[1], false);
			setVisibility(self.pto[2], true);
	end;
	if self.isTransRotOn then
		self.dropBales = false;
			setVisibility(self.pto[1], true);
			setVisibility(self.pto[2], false);

	end
		if self.isTurnedOn and self.movingDirection ~= 0 then
			Utils.setEmittingState(self.balerParticleSystems, true);
		else
			Utils.setEmittingState(self.balerParticleSystems, false);
		end;
    end;
end;
  
function Ferg_Baler:draw()
   if self.isClient then
        if self.isTransRotOn then
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        else
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FIELD"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        end;

		if not self.isTransRotOn and InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
			g_currentMission:addWarning(string.format("Rotate to Field Position Before Turning On", 0.07+0.022, 0.019+0.029));
		end;
	end;
end;
  
function Ferg_Baler:onDetach()

      if self.deactivateOnDetach then
          Ferg_Baler.onDeactivate(self);
      end;
end;

function Ferg_Baler:onAttach(attacherVehicle)

end;
  
function Ferg_Baler:onLeave()
	if self.balerParticleSystems ~= nil then
		Utils.setEmittingState(self.balerParticleSystems, false);
	end; 

end;
  
function Ferg_Baler:onDeactivate()
 	if self.balerParticleSystems ~= nil then
		Utils.setEmittingState(self.balerParticleSystems, false);
	end; 
end;

function Ferg_Baler:setTransRot(isTransRot,noEventSend)
	SetTransRotEvent.sendEvent(self, isTransRot, noEventSend);
	-- Play TransRot animation --
	self.isTransRotOn = isTransRot;
	if self.isTransRotOn then
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, 1, nil, true);
			self.TransRot = true;
		end;
	else
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, -1, nil, true);
			self.TransRot = false;
		end;
	end;	
end;

function Ferg_Baler:validateAttacherJoint(implement, jointDesc, dt)
        return true;
end;

function Ferg_Baler.dropBale(self, baleIndex)       
	local bale = self.bales[baleIndex];
      --local deltaRealTime = (self.time - self.baleLastPositionTime)/1000;
      local x,y,z = getWorldTranslation(bale.id);
      local rx,ry,rz = getWorldRotation(bale.id);
      --link(getRootNode(), bale.id);
  
 
      if self.isServer then
          local baleObject = Bale:new(self.isServer, self.isClient);
          baleObject:load(bale.filename, x,y,z,rx,ry,rz);
          baleObject:register();
 
         local lx, ly, lz = bale.lastX, bale.lastY, bale.lastZ;
         -- setLinearVelocity(baleObject.nodeId, (x-lx)/deltaRealTime, (y-ly)/deltaRealTime, (z-lz)/deltaRealTime);
      end;
      delete(bale.id);
      table.remove(self.bales, baleIndex);
  
      -- increase bale count if variable exists (baling mission)
	if self.CurrentBalesCount ~= nil and self.TotalBalesCount ~= nil then
		self.CurrentBalesCount = self.CurrentBalesCount +1;
		self.TotalBalesCount = self.TotalBalesCount +1;
	end;
end;
