  --
  -- cuttingBar
  -- Class for all mowers
  --
  -- @author  Stefan Geiger
  -- @date  11/05/08
  --
  -- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
 
cuttingBar = {};
  
function cuttingBar.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;
  
function cuttingBar:load(xmlFile)
  
      self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
  
      self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
      self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
      if self.groundReferenceNode == nil then
          self.groundReferenceNode = self.components[1].node;
      end;
      
      
      if self.isClient then
          local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
          if mowerSound ~= nil and mowerSound ~= "" then
              mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
              self.mowerSound = createSample("mowerSound");
              self.mowerSoundEnabled = false;
              loadSample(self.mowerSound, mowerSound, false);
              self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
              self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
          end;
      end;
  
      local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
      for i=1, numCuttingAreas do
          local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
          self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
          self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
      end;
  
      self.isTurnedOn = false;
      self.wasToFast = false;
      
      self.mowerGroundFlag = self.nextDirtyFlag;
      self.nextDirtyFlag = self.mowerGroundFlag*2;
	  
    self.onlyActiveWhenLowered = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.onlyActiveWhenLowered#value"), true);	
    self.myKnives = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myKnives#index"));
	self.drumNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drum#index"));
	self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
  
  	self.myKnivesMaxDisplacement = 0.04;
	self.myKnivesMinDisplacement = -0.04;
	self.myKnivesDisplacement = -0.005;
	self.knivesDirection = true;
	
	  self.mowerParticleSystems = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.mowerParticleSystems.mowerParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.mowerParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
      end;
		self.arfc = 0;	
end;
  
function cuttingBar:delete()
  
      if self.mowerSound ~= nil then
          delete(self.mowerSound);
      end;
 	Utils.deleteParticleSystem(self.mowerParticleSystems); 
end;
  
function cuttingBar:readStream(streamId, connection)
      local turnedOn = streamReadBool(streamId);
      self:setIsTurnedOn(turnedOn, true);
end;
  
function cuttingBar:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
end;
  
function cuttingBar:readUpdateStream(streamId, timestamp, connection)
end;
  
function cuttingBar:writeUpdateStream(streamId, connection, dirtyMask)
end;
  
function cuttingBar:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function cuttingBar:keyEvent(unicode, sym, modifier, isDown)
end;
  
function cuttingBar:update(dt)
  
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
              self:setIsTurnedOn(not self.isTurnedOn);
          end;
      end;
end;
  
function cuttingBar:updateTick(dt)
      self.wasToFast = false;
      if self:getIsActive() then
  
          if self.isTurnedOn and self.foldAnimTime > 0.5 then
			if self.drumNode1 ~= nil then
			rotate(self.drumNode1, 0, 0, 0.6);
			end;	
				if self.myKnives ~= nil then
					local x,y,z = getTranslation(self.myKnives);
					local displacement = x;
					if displacement >= self.myKnivesMaxDisplacement then
						self.knivesDirection = false;
					elseif displacement <= self.myKnivesMinDisplacement then
						self.knivesDirection = true;
					end;
					
					if self.knivesDirection then
						displacement = x-(self.myKnivesDisplacement*8);
					else
						displacement = x+(self.myKnivesDisplacement*8);
					end;
					--renderText(0.5, 0.9, 0.040, displacement);
					
					setTranslation(self.myKnives, displacement,y,z)
				end;
		  
              local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
              if not toFast and (not self.onlyActiveWhenLowered or self:isLowered(false)) then
                  if self.isServer then
				   local arfc = self.arfc;
					self.arfc = 0;
                      local x,y,z = getWorldTranslation(self.groundReferenceNode);
                      local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                      if terrainHeight+self.groundReferenceThreshold >= y then
                          local foldAnimTime = self.foldAnimTime;
                          local cuttingAreasSend = {};
                          for k, cuttingArea in pairs(self.cuttingAreas) do

                                  local x,y,z = getWorldTranslation(cuttingArea.start);
                                  local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                  local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                                  table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                  --Utils.updateMeadowArea(x, z, x1, z1, x2, z2)
							local area = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);
							if area > 0 then
								self.arfc = 1;	
							  end;
                          end;
                          if (table.getn(cuttingAreasSend) > 0) then
                              MowerAreaEvent.runLocally(cuttingAreasSend);
                              g_server:broadcastEvent(MowerAreaEvent:new(cuttingAreasSend));

                          end;
                      end;
                  end;
              end;
  
              if self.isClient then
                  if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                      setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                      playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                      self.mowerSoundEnabled = true;
                  end;
              end;
  
              self.wasToFast = toFast;
  
          else
              if self.isClient then
                  if self.mowerSoundEnabled then
                      stopSample(self.mowerSound);
                      self.mowerSoundEnabled = false;
                  end;
              end;
          end;
		if self.lastSpeed*3600 > 2 and self.arfc > 0 and self.isTurnedOn and self.foldAnimTime > 0.5 and (not self.onlyActiveWhenLowered or self:isLowered(false)) then
			Utils.setEmittingState(self.mowerParticleSystems, true);
		else
			Utils.setEmittingState(self.mowerParticleSystems, false);
		end; 
      end;
end;
  
function cuttingBar:draw()
      if self.isClient then
          if self.isTurnedOn then
              g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
          else
              g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
          end;
  
          if self.wasToFast then
              g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
          end;
          if self.foldAnimTime < 0.5 and InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) then
              g_currentMission:addWarning(string.format("Rotate to Field Position Before Turning On", 0.07+0.022, 0.019+0.029));
          end;
      end;
end;
  
function cuttingBar:onDetach()
      if self.deactivateOnDetach then
          cuttingBar.onDeactivate(self);
      else
          cuttingBar.onDeactivateSounds(self)
      end;

end;
  
function cuttingBar:onLeave()
      if self.deactivateOnLeave then
          cuttingBar.onDeactivate(self);
      else
          cuttingBar.onDeactivateSounds(self)
      end;
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end;
end;
  
function cuttingBar:onDeactivate()
      cuttingBar.onDeactivateSounds(self)
  
      self.isTurnedOn = false;
	if self.mowerParticleSystems ~= nil then
		Utils.setEmittingState(self.mowerParticleSystems, false);
	end;
end;
  
function cuttingBar:onDeactivateSounds()
      if self.isClient then
          if self.mowerSoundEnabled then
              stopSample(self.mowerSound);
              self.mowerSoundEnabled = false;
          end;
     end;
end;
  
function cuttingBar:setIsTurnedOn(turnedOn, noEventSend)
      SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
      self.isTurnedOn = turnedOn;
end;