--
-- henly 20 (Ls_uk Modteam)
-- 10.11.2010
--
-- > www.LS-UK.info

TE20FL = {};

function TE20FL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TE20FL:load(xmlFile)
	
	self.lifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifter#index"));
	self.lifterAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterAttacher#index"));
	self.lifterArmLower = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLower#index"));
	self.lifterArmLowerAttacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLowerAttacherJoint#index"));
	self.push1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push1#index"));
	self.push2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push2#index"));
	self.hydraulics1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics1#index"));
	self.hydraulics2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics2#index"));
	self.hydraulicsJoint1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint1#index"));
	self.hydraulicsJoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicsJoint2#index"));
	self.lifterStartAngle = 0;
    
	self.toplink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.topLink#index"));
	self.drawbar = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drawbar#index"));
	self.highhitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.highHitch#index"));
 	setVisibility((self.toplink), false);
 	setVisibility((self.drawbar), true);
	
    self.fanNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index"));

    self.hudInfoBasePosX = 0.83;
    self.hudInfoBaseWidth = 0.16;
    self.hudInfoBasePosY = 0.6;
    self.hudInfoBaseHeight = 0.19;
    self.infoPanelPath = Utils.getFilename("hud_Ferguson.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = false;
end;

function TE20FL:keyEvent(unicode, sym, modifier, isDown)
	if self.isEntered then 
		if isDown and sym == Input.KEY_KP_0 then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;

function TE20FL:update(dt)

	
	if self.lifterArmLower ~= nil and self.lifter ~= nil then
		local x,y,z = getRotation(self.lifterArmLower);
		if self.lifterStartAngle == 0 and x ~= 0 then
			self.lifterStartAngle = x;
		end;
		
		local lifterFactor = 0.8;
		local lifterRotation =  x * lifterFactor-self.lifterStartAngle * 0.8 * lifterFactor;
		setRotation(self.lifter, lifterRotation, y,z);
		
		local lifterAttacherFactor = 0.6;
		local lifterAttacherRotation =  self.lifterStartAngle * lifterAttacherFactor - x * lifterAttacherFactor;
		setRotation(self.lifterAttacher, lifterAttacherRotation, y,z);
	end;
	
	if self.hydraulicsJoint1 ~= nil and self.hydraulics1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics1);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint1);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics1), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics1, x, y, z, 0, 1, 0);
		setTranslation(self.push1,0,by-ay,0);
		
		
		local x2,y2,z2 = getRotation(self.hydraulics1);
		setRotation(self.hydraulics1,x2+2.9,y2,z2);
	end;
	
	if self.hydraulicsJoint2 ~= nil and self.hydraulics2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics2);
        local bx, by, bz = getWorldTranslation(self.hydraulicsJoint2);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics2), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics2, x, y, z, 0, 1, 0);
		setTranslation(self.push2,0,by-ay,0);
		
		
		local x2,y2,z2 = getRotation(self.hydraulics2);
		setRotation(self.hydraulics2,x2+2.9,y2,z2);
	end;
	if self.fanNode ~= nil and self.isMotorStarted then 
         rotate(self.fanNode, 0, 0, self.motor.lastMotorRpm*4);
    end;
end;


function TE20FL:draw()
 
	if self.showHudInfoBase then	
			g_currentMission:addExtraPrintText("Key KP 0:                                        Menu Off");
		else
			g_currentMission:addExtraPrintText("Key KP 0:                                        Menu On");
		end;

	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end; 
end;

function TE20FL:onEnter()
  
end;

function TE20FL:onLeave()
 
end;

function TE20FL:delete()

end;

function TE20FL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TE20FL:attachImplement(implement)
	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
			if jointIndex == 1 then
			setVisibility((self.toplink), true);
			setVisibility((self.drawbar), false);
	
			end;
	end;

	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility((self.toplink), false);
			setVisibility((self.drawbar), true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setVisibility((self.toplink), false);
			setVisibility((self.drawbar), true);
		end;
	end;
	self.updateJoint = true;	
end;

function TE20FL:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 or jointIndex == 3 then
		setVisibility((self.toplink), false);
		setVisibility((self.drawbar), true);
	end;
	if jointIndex == 2 then
		setVisibility((self.toplink), false);
		setVisibility((self.drawbar), true);
	end

end;

function TE20FL:validateAttacherJoint(implement, jointDesc, dt)
        return true;
end;