wheelParticlen = {};

function wheelParticlen.prerequisitesPresent(specializations)
    return true;
end;

function wheelParticlen:load(xmlFile)

	self.wheelParticlenSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticlenSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticlenSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticlenSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particlenSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particlenSystems, "vehicle.wheelParticlenSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticlenSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
end;

function wheelParticlen:delete()
	for i=1, table.getn(self.wheelParticlenSystems) do
		Utils.deleteParticleSystem(self.wheelParticlenSystems[i].particlenSystems);
    end;
end;

function wheelParticlen:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelParticlen:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelParticlen:update(dt)
	
	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[2].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for i=1, table.getn(self.wheelParticlenSystems) do
			Utils.setEmittingState(self.wheelParticlenSystems[i].particlenSystems, self.wheels[i].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticlenSystems) do
			Utils.setEmittingState(self.wheelParticlenSystems[i].particlenSystems, false);
		end;
	end;
	
end;

function wheelParticlen:draw()
end;