--
-- Shuttle
-- Specialization for a Power Shift shuttle.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Copyright (C) Templaer

Shuttle = {};

function Shuttle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Shuttle:load(xmlFile)
    self.reverse = false;
end;

function Shuttle:delete()
end;

function Shuttle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Shuttle:keyEvent(unicode, sym, modifier, isDown)
end;

function Shuttle:update(dt)
    if self.isMotorStarted then	
        if self:getIsActiveForInput() then
	        if InputBinding.hasEvent(InputBinding.REVERSE) then
		        self.reverse = not self.reverse;
            end;
	    end;
	
	    if self.isEntered then
            local acceleration = 0;
            if g_currentMission.allowSteerableMoving and not self.playMotorSound then
                acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
                if InputBinding.isAxisZero(acceleration) then
                    acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
                end;
                if math.abs(acceleration) > 0.8 then
                    self.motor:setSpeedLevel(0, true)
                end;
                if self.motor.speedLevel ~= 0 and not self.reverse then
                    acceleration = 1.0;
		    	elseif self.motor.speedLevel ~= 0 and self.reverse then
			        acceleration = -1.0;
                end;
		    end;
		
            if self.steeringEnabled then		
                if self.firstTimeRun then
                    WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
                end;	
            end;			
	    end;
	end;
end;

function Shuttle:draw()
    
end;

