--
-- lizard2000
-- Specialization for mediumTipper mod
--
-- @author  Rik Scott
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

mediunTipper = {};

function mediumTipper.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function mediumTipper:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function mediumTipper:delete()
    delete(self.burnerSoundId);
end;

function mediumTipper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mediumTipper:keyEvent(unicode, sym, modifier, isDown)
end;

function mediumTipper:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.LIZARD2000_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function mediumTipper:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Silly Horn"), InputBinding.LIZARD2000_SILLYHORN);
end;

