--
-- driveStick
-- Specialization for a driveStick.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

driveStick = {};

function driveStick.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function driveStick:load(xmlFile)
    self.accDirection = 1;
	self.cruiseControl = false;
	self.speedLevel = 3;
end;

function driveStick:delete()
end;

function driveStick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function driveStick:keyEvent(unicode, sym, modifier, isDown)
end;

function driveStick:update(dt)
    -- Check if engine is started
    if self.isMotorStarted and self.isEntered then	
        if self:getIsActiveForInput() then	
			if self.motor.speedLevel ~= 0 then
			    self.speedLevel = self.motor.speedLevel;
			end;
			
	        if InputBinding.hasEvent(InputBinding.REVERSE) then
		        self.accDirection = -self.accDirection;
				if self.hasAutoMode ~= nil then
					if self.currentMode > 1 then
						self:doPowershift("down");
					end;
				end;
            end;
			
			if InputBinding.hasEvent(InputBinding.CRUISECONTROL) then		
			    if self.motor.speedLevel == 0 and self.cruiseControl == false then
				    self.motor.speedLevel = self.speedLevel;
				end;	
			    self.cruiseControl = not self.cruiseControl;
			end;
	    end;
		
		if self.isAITractorActivated then
		    self.cruiseControl = false;
		end;
				    					
		local acceleration = 0;						
		if g_currentMission.allowSteerableMoving and not self.playMotorSound then			
			acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
			if InputBinding.isAxisZero(acceleration) then
				acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD); 
			end;
						
			if math.abs(acceleration) > 0.8 or self.motor.speedLevel == 0 then
				self.cruiseControl = false;
			end;
				
			if self.handThrottleEnabled ~= nil and self.handThrottleEnabled and self.cruiseControl then
				acceleration = self.accDirection * self.handThrottlePercentage;			
			elseif self.cruiseControl then
				acceleration = self.accDirection;
			else
				acceleration = self.accDirection * acceleration;
			end;	

			if self.motor.speedLevel ~= self.speedLevel then
				self.motor.speedLevel = self.speedLevel;
			end;
			
		    -- Update wheels
            if self.steeringEnabled then		
                if self.firstTimeRun then
                    WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
                end;	
            end;		
		end;		
	end;
end;

function driveStick:onLeave()
    self.cruiseControl = false;
end;

function driveStick:draw()
end;

