pickUpModeEvent = {};
pickUpModeEvent_mt = Class(pickUpModeEvent, Event);

InitEventClass(pickUpModeEvent, "pickUpModeEvent");

function pickUpModeEvent:emptyNew()
    local self = Event:new(pickUpModeEvent_mt);
    self.className="pickUpModeEvent";
    return self;
end;

function pickUpModeEvent:new(vehicle, mode)
    local self = pickUpModeEvent:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function pickUpModeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function pickUpModeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function pickUpModeEvent:run(connection)   
	self.vehicle:PrepareMode(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(pickUpModeEvent:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function pickUpModeEvent.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(pickUpModeEvent:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(pickUpModeEvent:new(vehicle, mode));
		end;
	end;
end;