﻿--
-- New Holland BB9090
--
-- author  Mythos
-- date  20/06/2011
-- www.Virtual-Farmers.gr
-- Copyright (C) ARM Team, All Rights Reserved.

NHBB9090 = {};
--________________________________________________________________________________________________________________________________________________________
function NHBB9090.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:load(xmlFile)

	-- Functions
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, NHBB9090.getIsAreaActive);
	self.WorkBB9090= SpecializationUtil.callSpecializationsFunction("WorkBB9090");
	self.pickUpMode= SpecializationUtil.callSpecializationsFunction("pickUpMode");
	
	-- Animations
	self.workAnim = getXMLString(xmlFile, "vehicle.chute#animationName");
	self.pickUpAnim = getXMLString(xmlFile, "vehicle.pickUp#animationName");

	-- Indexs
	self.roller = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.roller#index"));
	--self.strawBaleFilename = getXMLString(xmlFile, "vehicle.bales.bale2#filename");
	
	-- Particles
	self.bbParticles = {};
	local i = 0;
    while true do
        local key = string.format("vehicle.bbParticles.pSystem(%d)", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.. "#index"));
		if node == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.bbParticles, key, node, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	-- Booleans
	self.workPos = false;
	self.pickUpPos = false;
	self.previousLevel = 0;

end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:delete()
	Utils.deleteParticleSystem(self.bbParticles);
end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:mouseEvent(posX, posY, isDown, isUp, button)

end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:keyEvent(unicode, sym, modifier, isDown)

end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:update(dt)

	if self:getIsActiveForInput() then
			
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if not self.workPos then
				self.isTurnedOn = false;
			end;
		end;
			
		if (not self.isTurnedOn) and (not self.pickUpPos) then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:WorkBB9090(not self.workPos);
			end;
		end;
			
		if self.workPos then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self:pickUpMode(not self.pickUpPos);
			end;
		end;
		
		if self.isTurnedOn then
			rotate(self.roller, dt*-0.01, 0, 0);
			
			if self.previousLevel ~= self.fillLevel then
				Utils.setEmittingState(self.bbParticles, true);
				self.previousLevel = self.fillLevel;
			else
				Utils.setEmittingState(self.bbParticles, false);
			end;
		end;
		
		for i, v in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:updateTick(dt)

end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:draw()
			
		if not self.workPos then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WORKMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		elseif not self.isTurnedOn and not self.pickUpPos then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("TRANSPORTMODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
		
		if self.workPos then
			if not self.pickUpPos then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_DOWN"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PICKUP_UP"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			end;
		end;

end;

--________________________________________________________________________________________________________________________________________________________
function NHBB9090:WorkBB9090(mode,noEventSend)
	WorkBB9090Event.sendEvent(self, mode, noEventSend);
		
	if mode then
		self:playAnimation(self.workAnim, 1, nil, true);
		self.workPos = true;
	else
		self:playAnimation(self.workAnim, -1, nil, true);
		self.workPos = false;
	end;
end;

function NHBB9090:pickUpMode(mode,noEventSend)
	pickUpModeEvent.sendEvent(self, mode, noEventSend);
		
	if mode then
		self:playAnimation(self.pickUpAnim, 1, nil, true);
		self.pickUpPos = true;
	else
		self:playAnimation(self.pickUpAnim, -1, nil, true);
		self.pickUpPos = false;
	end;
end;

function NHBB9090:getIsAreaActive()
	return self.pickUpPos;
end;

