--
-- fendt1290s
-- Class for all fendt1290s
--
-- @author  Stefan Geiger
-- @date  10/09/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- @edit
-- @author  SpeedySC1978
-- @date  01/28/2010
--

fendt1290s = {};

function fendt1290s.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function fendt1290s:load(xmlFile)

--[[Blinker start]]--
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	
--[[Blinker ende]]--

--[[Bremslicht start]]--
    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
--[[Bremslicht ende]]--

    self.getTimeFromLevel = fendt1290s.getTimeFromLevel;
    self.moveBales = SpecializationUtil.callSpecializationsFunction("moveBales");
    self.moveBale = SpecializationUtil.callSpecializationsFunction("moveBale");
    self.allowFillType = fendt1290s.allowFillType;

    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);

	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.part" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
		for j=1, 3 do
			if part[i].rot[j] ~= 0 then
				part[i].rot[j] = 1/part[i].rot[j]
			end;
		end;
    end;	
	
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;	
	
    local firstBaleMarker = getXMLFloat(xmlFile, "vehicle.baleAnimation#firstBaleMarker");
    if firstBaleMarker ~= nil then
        local baleAnimCurve = AnimCurve:new(linearInterpolatorN);
        local keyI = 0;
        while true do
            local key = string.format("vehicle.baleAnimation.key(%d)", keyI);
            local t = getXMLFloat(xmlFile, key.."#time");
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#pos"));
            if x == nil or y == nil or z == nil then
                break;
            end;
            local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rot"));
            rx = math.rad(Utils.getNoNil(rx, 0));
            ry = math.rad(Utils.getNoNil(ry, 0));
            rz = math.rad(Utils.getNoNil(rz, 0));
            baleAnimCurve:addKeyframe({ v={x, y, z, rx, ry, rz}, time = t});
            keyI = keyI +1;
        end;
        if keyI > 0 then
            self.baleAnimCurve = baleAnimCurve;
            self.baleAnimRoot = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleAnimation#node")), self.components[1].node);
            self.firstBaleMarker = firstBaleMarker;
            --self.baleFilename = Utils.getNoNil(getXMLString(xmlFile, "vehicle.baleAnimation#filename"), "data/maps/models/objects/strawbale/strawbalefendt1290s.i3d");

            self.baleTypes = {};
            local i = 0;
            while true do
                local key = string.format("vehicle.baleTypes.baleType(%d)", i);
                local t = getXMLString(xmlFile, key.."#fruitType");
                local filename = getXMLString(xmlFile, key.."#filename");
                if t==nil or filename==nil then
                    break;
                end;

                local entry = {};
                entry.filename = filename;
                local desc = FruitUtil.fruitTypes[t];
                if desc ~= nil then
                    self.baleTypes[desc.index] = entry;

                    if self.defaultBaleType == nil then
                        self.defaultBaleType = entry;
                    end;
                end;
                i = i +1;
            end;
            if self.defaultBaleType == nil then
                self.baleTypes = nil;
            end;
        end;
    end;

    local fendt1290sSound = getXMLString(xmlFile, "vehicle.fendt1290sSound#file");
    if fendt1290sSound ~= nil and fendt1290sSound ~= "" then
        fendt1290sSound = Utils.getFilename(fendt1290sSound, self.baseDirectory);
        self.fendt1290sSound = createSample("fendt1290sSound");
        self.fendt1290sSoundEnabled = false;
        loadSample(self.fendt1290sSound, fendt1290sSound, false);
        self.fendt1290sSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fendt1290sSound#pitchOffset"), 1);
        self.fendt1290sSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fendt1290sSound#volume"), 1);
    end;

    self.baleMoveLastTime = 0;

    self.bales = {};
    self.wasToFast = false;
    self.isTurnedOn = false;
end;

function fendt1290s:delete()
    if self.fendt1290sSound ~= nil then
        delete(self.fendt1290sSound);
    end;
end;

function fendt1290s:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fendt1290s:keyEvent(unicode, sym, modifier, isDown)
--[[Blinker start]]--
--[[Blinker Rechts]]--
	if InputBinding.isPressed(InputBinding.fendt1290s_TURNRIGHTLIGHT) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]--
	if InputBinding.isPressed(InputBinding.fendt1290s_WARNLIGHT) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]--
	if InputBinding.isPressed(InputBinding.fendt1290s_TURNLEFTLIGHT) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;
--[[Blinker ende]]--
end;

function fendt1290s:update(dt)

    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;

    self.wasToFast = false;
    if self:getIsActive() then
        if self.isTurnedOn then
			self.rotationMaxLeft = true;
			self.rotationMaxLeft2 = true;		
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, self.drums[i].rot[1]  * dt, self.drums[i].rot[2]  * dt, self.drums[i].rot[3]  * dt);
			end;		

            local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 29;
            if not toFast then
                local totalArea =0;
                local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
                for k, cuttingArea in pairs(self.cuttingAreas) do
                    local x,y,z = getWorldTranslation(cuttingArea.start);
                    local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                    local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                    for fruitType,v in pairs(self.fillTypes) do
                        if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                            local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
                            area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area > 0 then
                                totalArea = totalArea+area;
                                usedFruitType = fruitType;
                            end;
                        end;
                    end;
                end;

                if totalArea > 0 then
                    local literPerPixel = 4*8000/1200 / 6 / (2*2) *12/4 / 4;

                    local deltaLevel = totalArea * literPerPixel * self.fillScale;

                    -- move all bales
                    local deltaTime = self:getTimeFromLevel(deltaLevel);
                    self:moveBales(deltaTime);

                    local oldFillLevel = self.fillLevel;
                    self:setFillLevel(self.fillLevel+deltaLevel, usedFruitType);
                    if self.fillLevel == self.capacity then
                        local restDeltaFillLevel = deltaLevel - (self.fillLevel-oldFillLevel)
                        self:setFillLevel(restDeltaFillLevel, usedFruitType);
                        -- create bale
                        if self.baleAnimCurve ~= nil and self.baleTypes ~= nil then
                            local baleType = self.baleTypes[usedFruitType];
                            if baleType == nil then
                                baleType = self.defaultBaleType;
                            end;
                            local fendt1290soot = Utils.loadSharedI3DFile(baleType.filename, self.baseDirectory);

                            local baleId = getChildAt(fendt1290soot, 0);
                            setRigidBodyType(baleId, "None");
                            link(self.baleAnimRoot, baleId);
                            delete(fendt1290soot);

                            local bale = {};
                            bale.id = baleId;
                            bale.time = 0;
                            bale.filename = Utils.getFilename(baleType.filename, self.baseDirectory);
                            table.insert(self.bales, bale);

                            self:moveBale(table.getn(self.bales), self:getTimeFromLevel(restDeltaFillLevel));
                        end;
                    end;
                end;
            end;

            if not self.fendt1290sSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.fendt1290sSound, self.fendt1290sSoundPitchOffset);
                playSample(self.fendt1290sSound, 0, self.fendt1290sSoundVolume, 0);
                self.fendt1290sSoundEnabled = true;
            end;

            self.wasToFast = toFast;
		else
			self.rotationMaxLeft = false;
			self.rotationMaxLeft2 = false;
        end;
        if not self.isTurnedOn and self.fendt1290sSoundEnabled then
            stopSample(self.fendt1290sSound);
            self.fendt1290sSoundEnabled = false;
        end;
    end;
	
		if self.rotationPartLeft ~= nil then
			local x, y, z = getRotation(self.rotationPartLeft.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
			setRotation(self.rotationPartLeft.node, unpack(newRot));
		end;
		if self.rotationPartLeft2 ~= nil then
			local x, y, z = getRotation(self.rotationPartLeft2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
			setRotation(self.rotationPartLeft2.node, unpack(newRot));
		end;

--[[Blinker start]]--
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.turnlightsActive2 = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.turnlightsActive2 = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.turnlightsActive2 = false;
		end;
	end;
	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashlightsLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 500;
				self.flashlightsLeftActive = true;
				self.turnlightsActive = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashlightsLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 500;
				self.flashlightsLeftActive = false;
				self.turnlightsActive = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.turnlightsActive = false;
		end;
	end;
	if self.turnlightsActive then
		for i=1, self.numTurnlights do
			local turnlight = self.turnlights[i];
			setVisibility(turnlight, self.turnlightsActive);
		end;
	else
		for i=1, self.numTurnlights do
			local turnlight = self.turnlights[i];
			setVisibility(turnlight, self.turnlightsActive, false);
		end;
	end;
   	if self.turnlightsActive2 then
		for i=1, self.numTurnlights2 do
			local turnlight2 = self.turnlights2[i];
			setVisibility(turnlight2, self.turnlightsActive2);
		end;
	else
		for i=1, self.numTurnlights2 do
			local turnlight2 = self.turnlights2[i];
			setVisibility(turnlight2, self.turnlightsActive2, false);
		end;
	end;	
--[[Blinker ende]]--	

--[[Bremslicht]]--
    inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
	if InputBinding.isAxisZero(inputAxisY) then
		inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;		

		if self.attacherVehicle ~= nil then
			if self.brakelightsActive then
				for i=1, self.numbrakelights do
					local brakelight = self.brakelights[i];
					setVisibility(brakelight, self.brakelightsActive);
				end;
			else
				for i=1, self.numbrakelights do
					local brakelight = self.brakelights[i];
					setVisibility(brakelight, self.brakelightsActive, false);
				end;
			end;
			if (self.attacherVehicle.movingDirection*self.attacherVehicle.lastSpeed*(-inputAxisY)) < -0.001 then		
				self.brakelightsActive = true;
				self.braking = true;
			else
				self.brakelightsActive = false;
				self.braking = false;
			end;
		end;
--[[Bremslicht]]--		
		
end;

function fendt1290s:draw()
    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;

    if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    end;
end;

function fendt1290s:onDetach()
    if self.deactivateOnDetach then
        fendt1290s.onDeactivate(self);
		self.rotationMaxLeft = false;
		self.rotationMaxLeft2 = false;		
    end;
	self.flashRight = false;
	self.flashLeft = false;	
end;

function fendt1290s:onLeave()
    if self.deactivateOnLeave then
        fendt1290s.onDeactivate(self);
    else
        fendt1290s.onDeactivateSounds(self);
    end;
end;

function fendt1290s:onDeactivate()
    self.wasToFast = false;
    self.isTurnedOn = false;
    fendt1290s.onDeactivateSounds(self)
end;

function fendt1290s:onDeactivateSounds()
    if self.fendt1290sSoundEnabled then
        stopSample(self.fendt1290sSound);
        self.fendt1290sSoundEnabled = false;
    end;
end;

function fendt1290s:getTimeFromLevel(level)
    -- level = capacity -> time = firstBaleMarker
    -- level = 0           -> time = 0
    if self.firstBaleMarker ~= nil then
        return level / self.capacity * self.firstBaleMarker;
    end;
    return 0;
end;

function fendt1290s:moveBales(dt)
    for i=table.getn(self.bales), 1, -1 do
        self:moveBale(i, dt);
    end;
    self.baleMoveLastTime = self.time
end;

function fendt1290s:moveBale(i, dt)
    local bale = self.bales[i];
    bale.time = bale.time + dt;
    local v = self.baleAnimCurve:get(bale.time);
    setTranslation(bale.id, v[1], v[2], v[3]);
    setRotation(bale.id, v[4], v[5], v[6]);
    if bale.time >= 1 then
        local deltaRealTime = (self.time - self.baleMoveLastTime)/1000;
        local lx, ly, lz = bale.lastX, bale.lastY, bale.lastZ;
        local x,y,z = getWorldTranslation(bale.id);
        local rx,ry,rz = getWorldRotation(bale.id);
        link(getRootNode(), bale.id);
        g_currentMission:addItemToSave(bale.filename, bale.id, 0);
        setTranslation(bale.id, x, y, z);
        setRotation(bale.id, rx, ry, rz);
        setRigidBodyType(bale.id, "Dynamic");
        setLinearVelocity(bale.id, (x-lx)/deltaRealTime, (y-ly)/deltaRealTime, (z-lz)/deltaRealTime);

        table.remove(self.bales, i);

        -- increase bale count if variable exists (baling mission)
        if g_currentMission.baleCount ~= nil then
            g_currentMission.baleCount = g_currentMission.baleCount + 1;
        end;
    else
        bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
    end;
end;

function fendt1290s:allowFillType(fillType)
    return self.fillTypes[fillType] == true;
end;
