--
-- infoHud
-- Specialization for an extra information hud in the left bottom corner of the screen. Information can be added from anywere within the script by using the addStats and addInfoText functions
--
-- @author  Templaer
-- @date  31/08/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

infoHud = {};

function infoHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function infoHud:load(xmlFile)
	self.addInfoText = SpecializationUtil.callSpecializationsFunction("addInfoText");
	self.addStats = SpecializationUtil.callSpecializationsFunction("addStats");

	self.hudInfoBasePosX = 0.012;
    self.hudInfoBaseWidth = 0.437-0.012;
    self.hudInfoBasePosY = 1-0.99;
    self.hudInfoBaseHeight = 0.24;

	self.infoPanelPath = Utils.getFilename("hud_info_base.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
	
	self.infoButtonTexts = {};
	self.showHudInfoBase = true;
	self.statisticsMode = false;
end;

function infoHud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function infoHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function infoHud:keyEvent(unicode, sym, modifier, isDown)
end;

function infoHud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
		
		if InputBinding.hasEvent(InputBinding.STATISTICS) then
		    self.statisticsMode = not self.statisticsMode;
		end;
	end;
end;
	
function infoHud:addInfoText(button, text)
	table.insert(self.infoButtonTexts, {text=text, button=button});
end;

function infoHud:addStats(left, right)
	table.insert(self.infoButtonTexts, {left=left, right=right});
end;
	
function infoHud:draw()
	if self.showHudInfoBase and self.isEntered then
	
		local renderTextsLeft = {};
		local renderTextsRight = {};
		
		if self.ignitionKey ~= nil then -- Display Ignition Instructions
			if not self.isMotorStarted then
				self:addInfoText(InputBinding.IGNITION, g_i18n:getText("Start"));
			elseif not self.statisticsMode then
				self:addInfoText(InputBinding.IGNITION, g_i18n:getText("Stop"));
			end;
		end;
		
		if self.isMotorStarted and not self.statisticsMode then -- Normal Mode
		    if self.accDirection ~= nil then
			    if self.accDirection == -1 then
					self:addInfoText(InputBinding.REVERSE, g_i18n:getText("Shuttle1"));
				else
				    self:addInfoText(InputBinding.REVERSE, g_i18n:getText("Shuttle2"));
				end;
			end;
												
			if self.cruiseControl ~= nil then
			    if self.cruiseControl then
					self:addInfoText(InputBinding.CRUISECONTROL, g_i18n:getText("CruiseControl2"));
				else
					self:addInfoText(InputBinding.CRUISECONTROL, g_i18n:getText("CruiseControl1"));
				end;
			end;
			
			if self.workLightsActive ~= nil then
				self:addInfoText(InputBinding.WORKLIGHTS, g_i18n:getText("Worklights"));
			end;
			
			if self.origMaxRpm ~= nil then
				if self.currentMode > 1 then
					self:addInfoText(InputBinding.AUTOMATIC, g_i18n:getText("Automatic1"));
				else
					self:addInfoText(InputBinding.AUTOMATIC, g_i18n:getText("Automatic2"));
				end;
			end;
			
			if self.backupChopperBlind ~= nil then
				if self.strawActive then
					self:addInfoText(InputBinding.STRAW_TOGGLE, g_i18n:getText("strawCutOn"));
				else
					self:addInfoText(InputBinding.STRAW_TOGGLE, g_i18n:getText("strawCutOff"));
				end;
			end;
		elseif self.statisticsMode and self.isMotorStarted then
			if self.origMaxRpm ~= nil then
				if not self.fullPowershift then
					self:addStats(string.format("%s/%s:", InputBinding.getButtonKeyName(InputBinding.RANGEUP), InputBinding.getButtonKeyName(InputBinding.RANGEDOWN)), string.format("Range %c %s", self.currentRange + 65, self.modes[self.currentMode]));
				end;
				self:addStats(string.format("%s/%s:", InputBinding.getButtonKeyName(InputBinding.LEVELUP), InputBinding.getButtonKeyName(InputBinding.LEVELDOWN)), string.format("Level %d %s", self.powershiftLevel, self.modes[self.currentMode]));
			end;
		
		    if self.runningTime ~= nil then
				self:addStats("Running Time:", string.format("%.1f Hours", self.runningTime)); 
			end;
						
			self:addStats("Current RPM:", string.format("%d RPM", math.min(self.lastRoundPerMinute + 300, 2100))); 
			
			if self.fuelConsumption ~= nil then
				self:addStats("Fuel consumption:", string.format("%d L/hour", self.fuelConsumption)); 
			end;
			
			if self.fuelUsed ~= nil then
				self:addStats("Fuel used:", string.format("%d Litres", self.fuelUsed)); 
			end;

			if self.distanceDriven ~= nil then
				self:addStats("Distance driven:", string.format("%.1f KM", self.distanceDriven)); 
			end;
		end;
		
		if not self.statisticsMode then
			self:addInfoText(InputBinding.STATISTICS, g_i18n:getText("Statistics"));
			self:addInfoText(InputBinding.TOGGLEHUD, g_i18n:getText("ToggleHud"));
		end;
		
		for i=1, table.getn(self.infoButtonTexts) do
			local button = self.infoButtonTexts[i].button;
			if button ~= nil then
				if InputBinding.getButtonName(button) ~= nil then
					table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(button)..":"));
				else	
					table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button)..":"));
				end;	
				table.insert(renderTextsRight, self.infoButtonTexts[i].text);
			else
				table.insert(renderTextsLeft, self.infoButtonTexts[i].left);
				table.insert(renderTextsRight, self.infoButtonTexts[i].right);
			end;
		end;
		self.infoButtonTexts = {};
		
		if table.getn(renderTextsLeft) >= 1 then
			self.hudInfoBaseOverlay:render();
		end;
		
		local num = math.min(7, table.getn(renderTextsLeft));
		
		for i=1, num do
			local left = renderTextsLeft[i];
			local right = renderTextsRight[i];
			renderText(0.03, (7-i)*0.03+(1-0.97), 0.025, left);
			renderText(0.221, (7-i)*0.03+(1-0.97), 0.025, right);
		end;
	end;
end;

