--
-- moveCamera
-- Engine management specialization for a working position for the indoor camera
--
-- @author  Templaer
-- @date  3/07/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

moveCamera = {};

function moveCamera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveCamera:load(xmlFile)
	local translationCamera = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationCamera#index"));
    if translationCamera ~= nil then
        self.translationCamera = {};
        self.translationCamera.node = translationCamera;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCamera#minTrans"));
        self.translationCamera.minTrans = {};
        self.translationCamera.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationCamera.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationCamera.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationCamera#maxTrans"));
        self.translationCamera.maxTrans = {};
        self.translationCamera.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationCamera.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationCamera.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationCamera.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationCamera#transTime"), 2)*1000;
    end; 	
end;

function moveCamera:delete()
end;

function moveCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveCamera:keyEvent(unicode, sym, modifier, isDown)
    if self.isEntered and self.translationCamera ~= nil then
		if self.translationCamera.node ~= nil then
			if sym == Input.KEY_KP_1 then
				self.translationCameraLeft = isDown;
			end;
			
			if sym == Input.KEY_KP_2 then
				local x, y, z = getTranslation(self.translationCamera.node); 
				if x ~= 0 then
					x = 0;
					local newTrans = {x, y, z};
					setTranslation(self.translationCamera.node, unpack(newTrans));
				end;
			end;
			
			if sym == Input.KEY_KP_3 then
				self.translationCameraRight = isDown;
			end;
		end;
	end;
end;

function moveCamera:update(dt)	
    if self.isEntered and self.translationCamera ~= nil then
		-- Handle the translation
		local doTranslate = self.translationCameraLeft or self.translationCameraRight
		if self.translationCamera ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.translationCamera.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationCamera.maxTrans, self.translationCamera.minTrans, 3, self.translationCamera.transTime, dt, not self.translationCameraLeft); 
			setTranslation(self.translationCamera.node, unpack(newTrans)); 
		end;	
	end;
end;

function moveCamera:stopMotor()
end;
	
function moveCamera:onLeave()
end;

function moveCamera:draw()  
end;
