--
--
--





MapFertilizerMod = {};
MapFertilizerMod.stations = {};


function MapFertilizerMod:loadMap(name)
end;

function MapFertilizerMod:deleteMap()
end;

function MapFertilizerMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapFertilizerMod:keyEvent(unicode, sym, modifier, isDown)
end;

function MapFertilizerMod:update(dt)
end;

function MapFertilizerMod:draw()
end;

function MapFertilizerMod:addFertilizerStation(station)
	table.insert(self.stations, station);
end;


addModEventListener(MapFertilizerMod);









--
--
--

function onCreate(self, id)
	local instance = FertilizerStation:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

FertilizerStation = {};

local FertilizerStation_mt = Class(FertilizerStation, Object);

function FertilizerStation:new(isServer, isClient)
	local self = Object:new(isServer, isClient, FertilizerStation_mt);
	self.className = "FertilizerStation";
	return self;
end;

function FertilizerStation:load(name)
	
	local dir = getUserProfileAppPath() .. "mods/MapFertilizerMod/";
	local file = dir .. "MapFertilizerMod.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		self.firstTimeRun = false;
	end;	
	
	self.fillTrailerRaycast = FertilizerStation.fillTrailerRaycast;

	local xmlFile = loadXMLFile("FertilizerStation", file);
	
	self.siloTrigger = {};
	self.siloTrigger.triggerIds = {};
	local firstTriggerId = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.siloTrigger.raycastSet#fillRaycast"));
	table.insert(self.siloTrigger.triggerIds, firstTriggerId);
	addTrigger(firstTriggerId, "fillTrailerRaycast", self);
    for i=1, 3 do
        local child = getChildAt(firstTriggerId, i-1);
        table.insert(self.siloTrigger.triggerIds, child);
        addTrigger(child, "fillTrailerRaycast", self);
    end;
	--self.siloTrigger.fillType = Fillable.FILLTYPE_FERTILIZER;
	local types = getUserAttribute(name, "fruitTypes");
	local desc = FruitUtil.fruitTypes[types];
	if desc ~= nil then	 
		self.siloTrigger.fillType = FruitUtil.fruitTypeToFillType[desc.index];
	end;
	self.siloTrigger.siloParticleSystem = {};
    Utils.loadParticleSystem(xmlFile, self.siloTrigger.siloParticleSystem, "vehicle.siloTrigger.particleSystem", name, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", dir);
	self.siloTrigger.activeAttachable = nil;
	self.siloTrigger.isEnable = true;
	self.siloTrigger.fillDone = false;
	self.siloTrigger.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.siloTrigger.fillSpeed#literPerSecond"), 200);
	self.siloTrigger.elevatorPart = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.siloTrigger.shader#elevatorPart"));
	self.siloTrigger.planePart = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.siloTrigger.shader#planePart"));
	setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
	setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
	self.siloTrigger.randomSound = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.siloTrigger.randomSound#index"));
	setVisibility(self.siloTrigger.randomSound, false);
	self.siloTrigger.fillTrailerId = nil;
	
	self.tipTrigger = {};
	local triggerId = Utils.indexToObject(name, getXMLString(xmlFile, "vehicle.tipTrigger.raycastSet#tipTriggerRaycast"));
	self.tipTrigger = TipTrigger:new(self.isServer, self.isClient);
	self.tipTrigger:load(triggerId);
	self.tipTrigger:register(true);		
	
	MapFertilizerMod:addFertilizerStation(self);
end;

function FertilizerStation:delete()
	Utils.deleteParticleSystem(self.siloTrigger.siloParticleSystem);
	for i=1, table.getn(self.siloTrigger.triggerIds) do
        removeTrigger(self.siloTrigger.triggerIds[i]);
    end;
	--for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
		--if tipTrigger == g_currentMission.currentTipTrigger then
			--g_currentMission.currentTipTrigger = nil;
		--end;
	--end;
	self.tipTrigger:register(false);		
	if self.isServer then
		self.tipTrigger:delete();
	end;
end;


function FertilizerStation:loadMap(name)
end;

function FertilizerStation:deleteMap()
end;


function FertilizerStation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FertilizerStation:keyEvent(unicode, sym, modifier, isDown)
end;

function FertilizerStation:update(dt)
end;

function FertilizerStation:updateTick(dt)

	--print("."..tostring(self.siloTrigger.fillTrailerId).." "..tostring(self.siloTrigger.fillDone));
	local isFilling = false;
	if self.siloTrigger.fillTrailerId ~= nil and not self.siloTrigger.fillDone then
		if self.siloTrigger.fillTrailerId.allowFillFromAir ~= nil then
			if self.siloTrigger.fillTrailerId.allowFillFromAir == true then 
				local selfFillType = self.siloTrigger.fillType;
				local trailer = self.siloTrigger.fillTrailerId;
				local fillLevel = trailer.fillLevel;
				isFilling = true;
				local deltaFillLevel = math.min(self.siloTrigger.literPerSecond*(dt/1000.0), 5000);
				trailer:setFillLevel(fillLevel+deltaFillLevel, selfFillType);
				local newFillLevel = trailer.fillLevel;
				if fillLevel == newFillLevel then
					self.siloTrigger.fillDone = true;
					isFilling = false;
				end;
				local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
				local fruitType = FruitUtil.fillTypeToFruitType[selfFillType];
				local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * difficultyMultiplier * deltaFillLevel;
				if self.isServer then
					g_currentMission:addSharedMoney(-money);
				end;
			end;
		end;
	end;
	if isFilling then
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 1, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", -12, 1, 1, 1, false);
	else
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
	end;
	Utils.setEmittingState(self.siloTrigger.siloParticleSystem, isFilling);
	setVisibility(self.siloTrigger.randomSound, isFilling);
	
	if not self.siloTrigger.isEnable then
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
		Utils.setEmittingState(self.siloTrigger.siloParticleSystem, false);
		setVisibility(self.siloTrigger.randomSound, false);
	end;	
	
end;

function FertilizerStation:draw()
end;

function FertilizerStation:fillTrailerRaycast(triggerId, otherId, onEnter, onLeave)
    if self.siloTrigger.isEnable then
		local selfFillType = self.siloTrigger.fillType;
        local trailer = g_currentMission.objectToTrailer[otherId];
		local attachable = nil;		
		local implements = g_currentMission.attachables;
		for k, implement in pairs(g_currentMission.attachables) do
			if implement.rootNode == otherId then
				attachable = implement;
			end;
		end;
        if trailer ~= nil then
			if trailer.allowFillType ~= nil then
				if trailer:allowFillType(selfFillType) then
					if onEnter then
						self.siloTrigger.fillTrailerId = trailer;
						self.siloTrigger.fillDone = false;
					elseif onLeave then
						self.siloTrigger.fillTrailerId = nil;
						self.siloTrigger.fillDone = false;
					end;
				end;
			end;
        end;
		if attachable ~= nil then
			if attachable.allowFillType ~= nil then
				if attachable:allowFillType(selfFillType) then
					if onEnter then
						self.siloTrigger.activeAttachable = attachable; 
					elseif onLeave then
						self.siloTrigger.activeAttachable = nil;
					end;
				end;
			end;
		end;
    end;
end;


