BresselLadeForkEvent = {};
BresselLadeForkEvent_mt = Class(BresselLadeForkEvent, Event);

InitEventClass(BresselLadeForkEvent, "BresselLadeForkEvent");

function BresselLadeForkEvent:emptyNew()
    local self = Event:new(BresselLadeForkEvent_mt);
    self.className="BresselLadeForkEvent";
    return self;
end;

function BresselLadeForkEvent:new(vehicle, fork)
    local self = BresselLadeForkEvent:emptyNew()
    self.vehicle = vehicle;
	self.fork = fork;
    return self;
end;

function BresselLadeForkEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fork = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BresselLadeForkEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.fork);	
end;

function BresselLadeForkEvent:run(connection)
	self.vehicle:setFork(self.fork, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(BresselLadeForkEvent:new(self.vehicle, self.fork), nil, connection, self.object);
	end;
end;

function BresselLadeForkEvent.sendEvent(vehicle, fork, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BresselLadeForkEvent:new(vehicle, fork), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BresselLadeForkEvent:new(vehicle, fork));
		end;
	end;
end;