--
-- BresselLadeFork
-- Specialization for BresselLadeFork
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		19/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

BresselLadeFork = {};

function BresselLadeFork.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function BresselLadeFork:load(xmlFile)	

	self.setFork = SpecializationUtil.callSpecializationsFunction("setFork");

	self.fork1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forks#index1"));
	self.fork2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forks#index2"));
	self.forkId = 0;
end;

function BresselLadeFork:delete()
end;

function BresselLadeFork:readStream(streamId, connection)
	self:setFork(streamReadInt8(streamId), true);
end;

function BresselLadeFork:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.forkId);	
end;

function BresselLadeFork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BresselLadeFork:keyEvent(unicode, sym, modifier, isDown)
end;

function BresselLadeFork:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Toggle_Forks) then
				self:setFork(math.abs(self.forkId - 1));
			end;
		end;
	end;
end;

function BresselLadeFork:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_fork"), InputBinding.Toggle_Forks);
end;

function BresselLadeFork:setFork(fork, noEventSend)
	BresselLadeForkEvent.sendEvent(self, fork, noEventSend);

	setVisibility(self.fork1, fork == 0);
	setVisibility(self.fork2, fork == 1);
	self.forkId = fork;
end;
