print("register fruit type: fertilizer");
local fertilizerhudFile = Utils.getFilename("mods/ExtreNort_Map_Fruits/Abono.png", getUserProfileAppPath());
FruitUtil.registerFruitType("fertilizer", false, false, false, 0, 2.5, 0, 0, 0, fertilizerhudFile);

local origLoadStatsFromXML = loadStatsFromXML;
local origSowingMachineLoad = SowingMachine.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	self.seeds = {};
	local i = 1;
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[i] = fruitType.index;
			i = i + 1;
        end;
    end;	
end;
 
QuickPlayMenu.loadStatsFromXML = function(self, baseXMLName, savegame)
    origLoadStatsFromXML(self, baseXMLName, savegame);
    for i = 1, FruitUtil.NUM_FRUITTYPES do
        if savegame.stats.farmSiloFruitAmount[i] == nil then
            savegame.stats.farmSiloFruitAmount[i] = 5000;
        end;
        if savegame.stats.fruitPrices[i] == nil then
            savegame.stats.fruitPrices[i] = FruitUtil.fruitIndexToDesc[i].pricePerLiter;
        end;
        if savegame.stats.yesterdaysFruitPrices[i] == nil then
            savegame.stats.yesterdaysFruitPrices[i] = FruitUtil.fruitIndexToDesc[i].yesterdaysPrice;
        end;
    end;
end;
