-- Rolltor
-- @author: Daniel (Desperados93) W. / GIANTS Software GmbH / fruktor
-- @date: 26.02.2011

-- Copyright () by Daniel "Desperados93" W.
   
  Rolltor = {};
  
  local Rolltor_mt = Class(Rolltor);
  
  function Rolltor.onCreate(id)
      g_currentMission:addUpdateable(Rolltor:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Rolltor:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Rolltor_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 1;
      self.maxTrans = 1;
      self.minTrans = 0.1;
  
      return instance;
  end;
  
  function Rolltor:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Rolltor:update(dt)

      local old = self.trans;
      if self.count > 0 then
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.0005;    
          end;
     else
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.0005;  
				if self.trans > self.maxTrans then
					self.trans = self.maxTrans;
				end;
          end;
      end;
	  
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setScale(self.barriers[i], 1, self.trans, 1);
          end;
      end;
      
  end;
  
  function Rolltor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("RolltorOnCreate", Rolltor.onCreate);

