--
-- Lichtanlage
-- Specialization for Lichtanlage
--
-- @author  SpeedySC1978
-- @date 03/09/2009
--

Lichtanlage = {};

function Lichtanlage.prerequisitesPresent(specializations)
    return true;
end;

function Lichtanlage:load(xmlFile)
--[[Rundumleuchte start]]--
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;	
--[[Rundumleuchte ende]]--
	
--[[Bremslicht start]]--
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;	
--[[Bremslicht ende]]--
	
--[[Arbeitslicht hinten start]]--
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;	
--[[Arbeitslicht hinten ende]]--
	
--[[Arbeitslicht vorn start]]--
	self.extra_lights = {};
    self.extra_lights.front = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.front#index"));
    self.frontlightActive = false;	
--[[Arbeitslicht vorn ende]]--

--[[Blinker start]]--
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	
--[[Blinker ende]]--

	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste";
end;

function Lichtanlage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lichtanlage:keyEvent(unicode, sym, modifier, isDown)
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste";
--[[Rundumleuchte start]]--
    if InputBinding.isPressed(InputBinding.RULLIGHT) then
		self.rundumleuchtenAn = not self.rundumleuchtenAn;
		for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
		end;
    end;
--[[Rundumleuchte ende]]--

--[[Arbeitslicht hinten start]]--
	if InputBinding.isPressed(InputBinding.BACKWORKLIGHT) then
		self.worklightsActive = not self.worklightsActive;
	end;
--[[Arbeitslicht hinten ende]]--

--[[Arbeitslicht vorn ende]]--
	if InputBinding.isPressed(InputBinding.FRONTWORKLIGHT) then
		self.frontlightActive = not self.frontlightActive;
		setVisibility(self.extra_lights.front, self.frontlightActive);
    end;
--[[Arbeitslicht vorn ende]]--

--[[Blinker start]]--
--[[Blinker Rechts]]--
	if InputBinding.isPressed(InputBinding.TURNRIGHTLIGHT) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]--
	if InputBinding.isPressed(InputBinding.WARNLIGHT) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]--
	if InputBinding.isPressed(InputBinding.TURNLEFTLIGHT) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;
--[[Blinker ende]]--

--[[Hilfeanzeige start]]--
    if InputBinding.isPressed(InputBinding.LIGHTHELP) then
		self.lightPanel = not self.lightPanel;
	end;
--[[Hilfeanzeige ende]]--
end;

function Lichtanlage:update(dt)
--[[AI Nightlight start]]--
	if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
        (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
        not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;
	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;
    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end;	
--[[AI Nightlight ende]]--

--[[Bremslicht start]]--
    inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;	
	end;
--[[Bremslicht ende]]--
	
--[[Blinker start]]--
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.turnlightsActive2 = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.turnlightsActive2 = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.turnlightsActive2 = false;
		end;
	end;
	if self.flashLeft then
		if self.delayOnLeft >= -1 then
			self.delayOnLeft = self.delayOnLeft -dt;
		end;
		if not self.flashlightsLeftActive then
			if self.delayOnLeft < 0 then
				self.delayOffLeft = 500;
				self.flashlightsLeftActive = true;
				self.turnlightsActive = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffLeft >= 0 then
			self.delayOffLeft = self.delayOffLeft -dt;
		end;
		if self.flashlightsLeftActive then
			if self.delayOffLeft < 0 then
				self.delayOnLeft = 500;
				self.flashlightsLeftActive = false;
				self.turnlightsActive = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.turnlightsActive = false;
		end;
	end;
	if self.turnlightsActive then
		for i=1, self.numTurnlights do
			local turnlight = self.turnlights[i];
			setVisibility(turnlight, self.turnlightsActive);
		end;
	else
		for i=1, self.numTurnlights do
			local turnlight = self.turnlights[i];
			setVisibility(turnlight, self.turnlightsActive, false);
		end;
	end;
   	if self.turnlightsActive2 then
		for i=1, self.numTurnlights2 do
			local turnlight2 = self.turnlights2[i];
			setVisibility(turnlight2, self.turnlightsActive2);
		end;
	else
		for i=1, self.numTurnlights2 do
			local turnlight2 = self.turnlights2[i];
			setVisibility(turnlight2, self.turnlightsActive2, false);
		end;
	end;	
--[[Blinker ende]]--

--[[Arbeitslicht hinten start]]--
    if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;	
--[[Arbeitslicht hinten ende]]--

--[[Rundumleuchte start]]--
    if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
    end;
--[[Rundumleuchte ende]]--
end;

function Lichtanlage:draw()
--[[Hilfeanzeige start]]--
		if not self.lightPanel then
			renderText(0.8335, 0.17, 0.02, self.keyName.. " " ..self.keyType(InputBinding.LIGHTHELP).. ": " ..g_i18n:getText("Lichtanlage Info1"));
		else
			renderText(0.8335, 0.17, 0.02, self.keyName.. " " ..self.keyType(InputBinding.LIGHTHELP).. ": " ..g_i18n:getText("Lichtanlage Info2"));
		end;
		if self.lightPanel then
			if not self.rundumleuchtenAn then
				renderText(0.72, 0.585, 0.02, self.keyName.. " " ..self.keyType(InputBinding.RULLIGHT).. ": " ..g_i18n:getText("Rundumleuchte1"));
			elseif  self.rundumleuchtenAn then
				renderText(0.72, 0.585, 0.02, self.keyName.. " " ..self.keyType(InputBinding.RULLIGHT).. ": " ..g_i18n:getText("Rundumleuchte2"));
			end;
			if not  self.frontlightActive then
				renderText(0.72, 0.57, 0.02, self.keyName.. " " ..self.keyType(InputBinding.FRONTWORKLIGHT).. ": " ..g_i18n:getText("Arbeitslicht1")); 
			elseif  self.frontlightActive then
				renderText(0.72, 0.57, 0.02, self.keyName.. " " ..self.keyType(InputBinding.FRONTWORKLIGHT).. ": " ..g_i18n:getText("Arbeitslicht2"));
			end;
			if not self.worklightsActive then
				renderText(0.72, 0.555, 0.02, self.keyName.. " " ..self.keyType(InputBinding.BACKWORKLIGHT).. ": " ..g_i18n:getText("Arbeitslicht3")); 
			elseif self.worklightsActive then
				renderText(0.72, 0.555, 0.02, self.keyName.. " " ..self.keyType(InputBinding.BACKWORKLIGHT).. ": " ..g_i18n:getText("Arbeitslicht4"));
			end;
			if not self.flashLeft then --[[do not change......its flashlight right]]--
				renderText(0.72, 0.53, 0.02, self.keyName.. " " ..self.keyType(InputBinding.TURNRIGHTLIGHT).. ": " ..g_i18n:getText("Blinkerrechts1")); 
			elseif self.flashLeft then --[[do not change......its flashlight right]]--
				renderText(0.72, 0.53, 0.02, self.keyName.. " " ..self.keyType(InputBinding.TURNRIGHTLIGHT).. ": " ..g_i18n:getText("Blinkerrechts2"));
			end;
			if not self.flash then --[[do not change......its flashwarnlight]]--
				renderText(0.72, 0.515, 0.02, self.keyName.. " " ..self.keyType(InputBinding.WARNLIGHT).. ": " ..g_i18n:getText("Warnblinker1")); 
			elseif self.flash then --[[do not change......its flashwarnlight]]--
				renderText(0.72, 0.515, 0.02, self.keyName.. " " ..self.keyType(InputBinding.WARNLIGHT).. ": " ..g_i18n:getText("Warnblinker2"));
			end;
			if not self.flashRight then --[[do not change......its flashlight left]]--
				renderText(0.72, 0.5, 0.02, self.keyName.. " " ..self.keyType(InputBinding.TURNLEFTLIGHT).. ": " ..g_i18n:getText("Blinkerlinks1")); 
			elseif self.flashRight then --[[do not change......its flashlight left]]--
				renderText(0.72, 0.5, 0.02, self.keyName.. " " ..self.keyType(InputBinding.TURNLEFTLIGHT).. ": " ..g_i18n:getText("Blinkerlinks2"));
			end;			
		end;
--[[Hilfeanzeige ende]]--
end;

function Lichtanlage:onLeave()
--[[Rundumleuchte start]]--
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
--[[Rundumleuchte ende]]--

--[[Arbeitslicht hinten start]]--
    self.worklightsActive = false;
--[[Arbeitslicht hinten ende]]--	

--[[Arbeitslicht vorne start]]--	
	self.frontlightActive = false;
--[[Arbeitslicht vorne ende]]--	
end;

function Lichtanlage:delete()
end;