HusqvarnaRider = {};

function HusqvarnaRider.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function HusqvarnaRider:load(xmlFile)
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

	self.cuttingAreas = {}
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
		self.cuttingAreas[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

	local rotationPartNodenoze = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.noze#index"));
    if rotationPartNodenoze ~= nil then
        self.rotationPartnoze = {};
        self.rotationPartnoze.node = rotationPartNodenoze;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartnoze#minRot"));
        self.rotationPartnoze.minRot = {};
        self.rotationPartnoze.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartnoze.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartnoze.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.noze#maxRot"));
        self.rotationPartnoze.maxRot = {};
        self.rotationPartnoze.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartnoze.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartnoze.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartnoze.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.noze#rotTime"), 2)*1000;
        self.rotationPartnoze.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.noze#touchRotLimit"), 10));
    end;
	
	local rotationPartNodewajcha = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wajcha#index"));
    if rotationPartNodewajcha ~= nil then
        self.rotationPartwajcha = {};
        self.rotationPartwajcha.node = rotationPartNodewajcha;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwajcha#minRot"));
        self.rotationPartwajcha.minRot = {};
        self.rotationPartwajcha.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwajcha.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwajcha.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajcha#maxRot"));
        self.rotationPartwajcha.maxRot = {};
        self.rotationPartwajcha.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwajcha.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwajcha.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartwajcha.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajcha#rotTime"), 2)*1000;
        self.rotationPartwajcha.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajcha#touchRotLimit"), 10));
    end;
	self.keys = {};
	self.isTurnedOn = false;
	self.isLowered = false;  
    self.wasToFast = false;       
end;

function HusqvarnaRider:keyEvent(unicode, sym, modifier, isDown)
		if isDown and sym == Input.KEY_n then 
			self.isTurnedOn = not self.isTurnedOn;
		end;
		if isDown and sym == Input.KEY_n then 
			self.rotationMaxnoze = not self.rotationMaxnoze;
			self.rotationMaxwajcha = not self.rotationMaxwajcha;
			self.isLowered = not self.isLowered;
		end;
end;

function HusqvarnaRider:update(dt)
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn and self.isLowered then			
			--local toFast = self:doCheckSpeedLimit() and self.lastSpeed*1600 > 20;
            --if not toFast then				
				local area = 0;
                for k, cuttingArea in pairs(self.cuttingAreas) do
                    local x,y,z = getWorldTranslation(cuttingArea.start);
                    local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                    local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					Utils.updateMeadowArea(x, z, x1, z1, x2, z2, 1);
                end;							
		end;
    end;
	if self.rotationPartnoze ~= nil then
		local x, y, z = getRotation(self.rotationPartnoze.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartnoze.maxRot, self.rotationPartnoze.minRot, 3, self.rotationPartnoze.rotTime, dt, self.rotationMaxnoze);
		setRotation(self.rotationPartnoze.node, unpack(newRot));
	end	;
	if self.rotationPartwajcha ~= nil then
		local x, y, z = getRotation(self.rotationPartwajcha.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwajcha.maxRot, self.rotationPartwajcha.minRot, 3, self.rotationPartwajcha.rotTime, dt, not self.rotationMaxwajcha);
		setRotation(self.rotationPartwajcha.node, unpack(newRot));
	end	;
end;

function HusqvarnaRider:draw()
	if self.isTurnedOn then
        g_currentMission:addExtraPrintText("Klawisz N: Wylacz kosiarke");
    else
        g_currentMission:addExtraPrintText("Klawisz N: Wlacz kosiarke");
    end;
	if self.rotationMaxnoze then
           g_currentMission:addExtraPrintText("Klawisz N: Podnies noze");
    else
          g_currentMission:addExtraPrintText("Klawisz N: Opusc noze");
    end;
    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;
 end; 
 
function HusqvarnaRider:onLeave() 
end;

function HusqvarnaRider:delete()
end;

function HusqvarnaRider:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HusqvarnaRider:onEnter()
end;