--
-- LaufenburgMap
--
-- Copyright (C) Hewaaa and Grisu118 @ www.ls2011.org.

LaufenburgMap = {}

local LaufenburgMap_mt = Class(LaufenburgMap, Mission00);

function LaufenburgMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = LaufenburgMap_mt;
    end;
    local self = LaufenburgMap:superClass():new(baseDirectory, mt);
    return self;
end;

function LaufenburgMap:delete()
    LaufenburgMap:superClass().delete(self);
end;

function LaufenburgMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));

    g_currentMission.milkProductionScale = 0.5;
    g_currentMission.milkPriceScale = 1.0;
    g_currentMission.manureProductionScale = 0.5;
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map_1.png", self.baseDirectory));
	
	-- load the Bottles in this Map
	self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
	
	--load Glass Containers
	self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
    local originalXML = loadXMLFile("originals", Utils.getFilename("Original.xml",self.baseDirectory));
    local o=0;
    while true do
    		local baseString = string.format("originals.original(%d)#",o);
    		o=o+1;
    		local filename = getXMLString(originalXML,baseString.."filename");
    		if filename == nil then break; end;
    		local position = {Utils.getVectorFromString(getXMLString(originalXML, baseString.."position"))};
    		local rotation = {Utils.getVectorFromString(getXMLString(originalXML, baseString.."rotation"))};
    		local scale = {Utils.getVectorFromString(getXMLString(originalXML, baseString.."scale"))};
    		local rigid = getXMLString(originalXML, baseString.."rigid");
    		
    		local original = loadI3DFile(Utils.getFilename(filename,self.baseDirectory));
    		link(getRootNode(), original);
    		
    		local doTranslation = false;
    		for i=1,3 do
    			if position[i] ~= nil and position[i] ~= 0 then
    				doTranslation = true;
    			end;
    		end;
    		if doTranslation then
    			setTranslation(original, unpack(position));
    		end;
    		
    		local doRotation = false;
    		for i=1,3 do
    			if rotation[i] ~= nil and rotation[i] ~= 0 then
    				rotation[i] = math.rad(rotation[i]);
    				doRotation = true;
    			end;
    		end;
    		if doRotation then
    			setRotation(original, unpack(rotation));
    		end;
    		 
    		local doScale = false;
    		for i=1,3 do
    			if scale[i] ~= nil and scale[i] ~= 1 then
    				doScale = true;
    			end;
    		end;
    		if doScale then
    			setScale(original, unpack(scale));
    		end;
    		
    		if rigid ~= nil and rigid ~= "" then
			setRigidBodyType(original, rigid);
    		end;

    	end;
    	delete(originalXML);	
    
    LaufenburgMap:superClass().load(self);
end
function LaufenburgMap:loadFinished()
    LaufenburgMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function LaufenburgMap:mouseEvent(posX, posY, isDown, isUp, button)
    LaufenburgMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function LaufenburgMap:keyEvent(unicode, sym, modifier, isDown)
    LaufenburgMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function LaufenburgMap:update(dt)
    LaufenburgMap:superClass().update(self, dt);
end;

function LaufenburgMap:draw()
    LaufenburgMap:superClass().draw(self);
end;