-- xyzspain

KvernelandTaarup = {};

function KvernelandTaarup.prerequisitesPresent(specializations)
    return true;
end;

function KvernelandTaarup:load(xmlFile)
 self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.5);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
----------------------------------
		---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	
	------------------------------
	-------------	
		-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
		-- animacion
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.animParts = {}
	self.Activated = {};
	------
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	
	
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
		local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.Activated[nameR] = false;
		-----
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
		
		
		
	end; 	
	
	self.AllActivated = SpecializationUtil.callSpecializationsFunction("AllActivated");
	------
		--------------------------
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	 local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
      
    end;
		 local rotationNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
      
    end;
			 local rotationNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
      
    end;
		 local rotationNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
      
    end;
		 local rotationNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
      
    end;
	
	 local rotationNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation7#index"));
    if rotationNode7 ~= nil then
        self.rotation7 = {};
        self.rotation7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#minRot"));
        self.rotation7.minRot = {};
        self.rotation7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation7#maxRot"));
        self.rotation7.maxRot = {};
        self.rotation7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

         self.rotation7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation7#rotTime"), 2)*1000;
      
    end;
	local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
	self.rotParts = true;
	
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
			-------------------------
	local numTedderDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.tedderDropAreas#count"), 0);
    if numTedderDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;
    self.tedderDropAreas = {}
    for i=1, numTedderDropAreas do
        self.tedderDropAreas[i] = {};
        local areanamei = string.format("vehicle.tedderDropAreas.tedderDropArea%d", i);
        self.tedderDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.tedderDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.tedderDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].groundthreshold = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#groundthreshold"), 0.2);
        self.cuttingAreas[i].groundindex = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundindex"));
		self.cuttingAreas[i].grassParticleSystemIndex = getXMLInt(xmlFile, areanamei .. "#particleSystemIndex");
    end;
	
	---------------
	 self.grassParticleSystems = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.grassParticleSystems.grassParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, "0>");
        local particleSystem = {};
        particleSystem.ps = {};
        local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, nodei, false, nil, self.baseDirectory)
        if ps == nil then
            break;
        end;
        particleSystem.disableTime = 0;
        table.insert(self.grassParticleSystems, particleSystem);
        i = i+1;
    end;

    local tedderSound = getXMLString(xmlFile, "vehicle.tedderSound#file");
    if tedderSound ~= nil and tedderSound ~= "" then
        tedderSound = Utils.getFilename(tedderSound, self.baseDirectory);
        self.tedderSound = createSample("tedderSound");
        self.tedderSoundEnabled = false;
        loadSample(self.tedderSound, tedderSound, false);
        self.tedderSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tedderSound#pitchOffset"), 1);
        self.tedderSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tedderSound#volume"), 1.0);
    end;
	
	local sound1 = getXMLString(xmlFile, "vehicle.sound1#file");
    if sound1 ~= nil and sound1 ~= "" then
        sound1 = Utils.getFilename(sound1, self.baseDirectory); 
        self.sound1 = createSample("sound1");
        self.sound1Enabled = false;
        loadSample(self.sound1, sound1, false);
        self.sound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#pitchOffset"), 1);
        self.sound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound1#volume"), 1);
    end;
	local sound2 = getXMLString(xmlFile, "vehicle.sound2#file");
    if sound2 ~= nil and sound2 ~= "" then
        sound2 = Utils.getFilename(sound2, self.baseDirectory); 
        self.sound2 = createSample("sound2");
        self.sound2Enabled = false;
        loadSample(self.sound2, sound2, false);
        self.sound2PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#pitchOffset"), 1);
        self.sound2Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sound2#volume"), 1);
    end;
	
	 ---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	 
	
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	-------------------
	  self.rotors = {};

    local psFile = getXMLString(xmlFile, "vehicle.rotors.rotor(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.rotors.rotor(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.rotors, node);
            end;
            i = i+1;
        end;
    end;
	
	 self.transmisions = {};

    local psFile = getXMLString(xmlFile, "vehicle.transmisions.transmision(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.transmisions.transmision(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.transmisions, node);
            end;
            i = i+1;
        end;
    end;
	--------------------
	
	self.isTurnedOn = false;
    self.wasToFast = false;
	self.fixAttacher = true;	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	self.rotation1Max = false;
	self.rotation2Max = false;
	self.rotation3Max = false;
	self.rotation4Max  =true;
	self.rotation5Max  =true;
	self.rotation6Max  =true;
	self.translation1Max=false;
	self.openFinished=false;
	-- self.rotParts= true;
	self.isReadyToTransport =true;
	self.free = false;
	self.rotation7Max = false;
	self.AIon=false;
end;
function KvernelandTaarup:delete()
if self.sound1 ~= nil then
        delete(self.sound1);
    end;
if self.tedderSound ~= nil then
        delete(self.tedderSound);
    end;
if self.sound2 ~= nil then
        delete(self.sound2);
    end;

end;
function KvernelandTaarup:mouseEvent(posX, posY, isDown, isUp, button)
end;
function KvernelandTaarup:keyEvent(unicode, sym, modifier, isDown)
		self.on=true;
---flashlights
	
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;
	-----------
end;
function KvernelandTaarup:update(dt)
if self.Go.Lift ~= nil and self.Done.Lift ~= false then
			self:anim("Lift", false); 
end;
self.wasToFast = false;		
		
if self.attacherVehicle then
	
	if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
	end;	
	
	if self:getIsActive() then 
	--- flashLights

		if self.FlashLightLeft ~= nil then
				if self.flashLightLeftActive then
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
					
			else
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
			end;
			end;

		if self.FlashLightRight ~= nil then
				if self.FlashLightRightActive then
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
			else
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
			end;
			end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashLightLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashLightLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashLightLeftActive = false;
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashLightRightActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashLightRightActive = false;
				end;
			end;
		end;

		if self.flash then
		
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					
					self.flashLightRightActive = true;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
					
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
				
					self.flashLightLeftActive = false;
					self.flashLightRightActive = false;
				end;
			end;
			else
			
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashLightRightActive = false;
				self.flashLightLeftActive = false;
			end;
		end;
			
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashLightRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashLightLeftActive = false;
			end;
		end;
		
		-------------------
		if InputBinding.hasEvent (InputBinding.SWITCH_IMPLEMENT) then 
			self.on=not self.on;
		end;
		if self.on then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self.rotation4Max  = not self.rotation4Max; 
			self.rotation5Max  = not self.rotation5Max; 
			self.rotation6Max  = not self.rotation6Max; 
		end;
			if self.isReadyToTransport then
				
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.isOpen=not self.isOpen;
				end;
			end;	
			if self.isOpen then
				self.rotation7Max = true;
				self.Go.Lift=true;
				self.Done.Lift= true;
				-- self.rotParts= true;
			elseif not self.isOpen then
				self.rotation7Max = false;
				self.rotation2Max = false;
				self.rotation3Max = false;
				self.Go.Lift=false;
				self.Done.Lift= true;
				
			end;	
			  	
		end;
			
		local x, y, z = getRotation(self.rotation7.node);
				if z > Utils.degToRad(15)  then	
						self.rotParts= true;
				elseif z < Utils.degToRad(10)  then
					self.rotParts= false;
				end;
				
				if z > Utils.degToRad(80)  then	
						self.free=true;
				elseif z < Utils.degToRad(60)  then
						self.free=false;
				end;
		
		
		self.Speed.Lift= 0.8; 
		
	if self.Go.Lift then
		if not self.sound2Enabled  and not self.AIon and self:getIsActiveForSound() then  ---activar sound2
				setSamplePitch(self.sound2, self.sound2PitchOffset);
				playSample(self.sound2, 0, self.sound2Volume, 0);
				self.sound2Enabled = true;
				end;
	end;
	
	if (self.CheckDone["Lift"] == true) and self.Activated["Lift"] == false then

	if self.sound2Enabled then ---desactivar sound2
	stopSample(self.sound2);
	self.sound2Enabled = false;
	end;
	self.openFinished=true;
	
	end;


	
	if not self.Go.Lift and not self.isTurnedOn  then
			
			if not self.sound1Enabled  and not self.AIon and self:getIsActiveForSound() then  ---activar sound1 cierre
			setSamplePitch(self.sound1, self.sound1PitchOffset);
			playSample(self.sound1, 0, self.sound1Volume, 0);
			self.sound1Enabled = true;
			end;
	end;
	if (self.CheckDone["Lift"] == false) and self.Activated["Lift"] == true  then
	if self.sound1Enabled then ---desactivar sound1
		stopSample(self.sound1);
		self.sound1Enabled = false;
	end;
	self.openFinished=false;
	-- self.rotParts= false;
	end;	
		if self.openFinished then
			self.rotation2Max = true;
			self.rotation3Max = true;
		
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				 self.isTurnedOn  = not self.isTurnedOn ;
				end;
		end;
	
	 if self.isTurnedOn then
	 self.isReadyToTransport=false;
            for i=1, table.getn(self.rotors) do
                local rotor = self.rotors[i].index;
                local rotorRot = (-0.007*self.rotors[i].direction)*dt;
                rotate(rotor,rotorRot,0 , 0);
            end;
			  for i=1, table.getn(self.transmisions) do
                local transmision = self.transmisions[i].index;
                local transmisionRot = (-0.006*self.transmisions[i].direction)*dt;
                rotate(transmision, 0,0 ,transmisionRot);
            end;
			
			if self:getIsActiveForSound() then
				if not self.tedderSoundEnabled and self:getIsActiveForSound() then
					playSample(self.tedderSound, 0, self.tedderSoundVolume, 0);
					setSamplePitch(self.tedderSound, self.tedderSoundPitchOffset);
					self.tedderSoundEnabled = true;
				end;
			end;
		else
		self.isReadyToTransport=true;
       end;
	
	 if not self.isTurnedOn and self.tedderSoundEnabled then
        stopSample(self.tedderSound);
        self.tedderSoundEnabled = false;
    end;
	
	 for k,v in pairs(self.grassParticleSystems) do
            if self.time > v.disableTime then
                Utils.setEmittingState(v.ps, false);
            end;
     end;
	
	
	
	 if self.isTurnedOn then
	 
		 local foldAnimTime = self.foldAnimTime;
         

                local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;

                if not toFast then
                    local numDropAreas = table.getn(self.tedderDropAreas);
                  for i=1, table.getn(self.cuttingAreas) do
					
                        local cuttingArea = self.cuttingAreas[i];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            local area = Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
                            area = area + Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 0);
                            area = area + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0)*ratio;
                            area = area + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 0)*ratio;
                            if area > 0 then
                                if i <= numDropAreas then
                                    local dropArea = self.tedderDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.1 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxCutLongValue);
                                        Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, value, true);
                                    end;
                                end;
                                local ps = nil;
                                if cuttingArea.grassParticleSystemIndex ~= nil then
                                    ps = self.grassParticleSystems[cuttingArea.grassParticleSystemIndex+1];
                                    if ps ~= nil then
                                        ps.disableTime = self.time + 300;
                                        Utils.setEmittingState(ps.ps, true);
                                    end;
                                end;
                            end;
						 end;
                      end;
                    -- end;
                end;
                self.wasToFast = toFast;
       end;
      
	
	
	
	
	
	
	end;---active
	
		
end; ----attacher

if self.rotation1Max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
if self.rotation2Max ~= nil then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
	if self.rotation3Max ~= nil then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;	
	if self.rotation4Max ~= nil then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
		if self.rotation5Max ~= nil then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;
		if self.rotation6Max ~= nil then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;
		if self.rotation7Max ~= nil then
        local x, y, z = getRotation(self.rotation7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation7.maxRot, self.rotation7.minRot, 3, self.rotation7.rotTime, dt, not self.rotation7Max);
        setRotation(self.rotation7.node, unpack(newRot));
    end;
if self.translation1Max ~= nil then
					local x, y, z = getTranslation(self.translation1.node);
					local trans = {x,y,z};
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max);
					setTranslation(self.translation1.node, unpack(newTrans));
				end;


	if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
				end;

	--- asignacion de libertad ejes de rotacion segun condiciones de emsamblage  0 x, 2 y ,1 z 
	
	self:setJointRotLimit(self.componentJoints[11],5, 0, 2000,self.rotParts == true, 1,dt);	
	self:setJointRotLimit(self.componentJoints[12],5, 0, 2000,self.rotParts == true, 1,dt);	
	self:setJointRotLimit(self.componentJoints[13],5, 0, 2000,self.rotParts == true, 1,dt);	
	self:setJointRotLimit(self.componentJoints[14],5, 0, 2000,self.rotParts == true, 1,dt);	
	-- self:setJointRotLimit(self.componentJoints[4],3, 0, 1000,self.rotation4Max == true, 0,dt);	
	
	self:setJointRotLimit(self.componentJoints[7],6, 0, 3000,self.free == true, 2,dt);	
	self:setJointRotLimit(self.componentJoints[8],6, 0, 3000,self.free == true, 2,dt);	
	self:setJointRotLimit(self.componentJoints[9],6, 0, 3000,self.free == true, 2,dt);	
	self:setJointRotLimit(self.componentJoints[10],6, 0, 3000,self.free == true, 2,dt);	
-- juntas

		local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[8];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[9];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[10];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[11];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[12];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[13];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[14];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[15];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[16];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[17];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[18];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[19];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[20];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
				local joint = self.componentJoints[21];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[22];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		
		self:setHydraulicDirection();
		
	
end;
function KvernelandTaarup:draw()
if self.attacherVehicle then
	if self.AIon == false then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		if self.isReadyToTransport then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
		if self.openFinished then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".2"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		end;
	end;
end;
end;
function KvernelandTaarup:onAttach()
	self.fixAttacher = true; 
	-- self.isOPen=false;
	self.rotation1Max = true;
	self.translation1Max=true;
	-- self.openFinished=false;
	self.rotation4Max  =true;
	self.rotation5Max  =true;
	self.rotation6Max  =true;
	self.isReadyToTransport =true;
	-- self.free = false;
	self.on=false;
	self.isTurnedOn = false;
end; 	

function KvernelandTaarup:onDetach()
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
    if self.deactivateOnDetach then
        KvernelandTaarup.onDeactivate(self);
    end;
	self.rotation1Max = false;
	self.translation1Max=false;
	self.rotation4Max  =true;
	self.rotation5Max  =true;
	self.rotation6Max  =true;
	
	self.isTurnedOn = false;
	self.on=false;

self.flashLightRightActive = false;
self.flashLightLeftActive = false;
setVisibility(self.FlashLightRight, false);
setVisibility(self.FlashLightLeft, false);
	
	
end;
function KvernelandTaarup:onLeave()
    if self.deactivateOnLeave then
        KvernelandTaarup.onDeactivate(self);
    end;
end;
function KvernelandTaarup:onDeactivate()
    for k,v in pairs(self.grassParticleSystems) do
        Utils.setEmittingState(v.ps, false);
    end;
    self.isTurnedOn = false;
    self:onDeactivateSounds();
end;

function KvernelandTaarup:onDeactivateSounds()
    if self.tedderSoundEnabled then
        stopSample(self.tedderSound);
        self.tedderSoundEnabled = false;
    end;
	 if self.sound1Enabled then
        stopSample(self.sound1);
        self.sound1Enabled = false;
    end;
	 if self.sound2Enabled then
        stopSample(self.sound2);
        self.sound2Enabled = false;
    end;
end;
function KvernelandTaarup:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function KvernelandTaarup:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
function KvernelandTaarup:anim(varName, loopCheck)	
	-- print("ANIMATION");
	
	self.Activated[varName] = true;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	 
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
			self.Activated[varName] = false;
		
			---final animacion hacia delante
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
			self.Activated[varName] = true;
			---final animacion hacia atras
		
		end;
	end;
end; 


function KvernelandTaarup:AllActivated()
	
	if (self.CheckDone["Lift"] == true) and not self.Activated["Lift"]  then
		return true;
	else
		return false;
	end;
	
	
end;
function KvernelandTaarup:getSaveAttributesAndNodes(nodeIdent)
if (self.CheckDone["Lift"] == true) and self.Activated["Lift"] == false then
					
	Lift = "true";	
else		
	Lift = "false";	
end;		
		

	-- 'name="'..tostring(name)..'" name="'..tonumber(name)..'"';
	 local attributes = 'Lift="'..tostring(Lift)..'"';
	
	return attributes, nil;
end;


function KvernelandTaarup:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local Lift = getXMLString(xmlFile, key.."#Lift");
	
	if Lift == "true" and not resetVehicles then
		self.Go.Lift = not self.Go.Lift ; 
		self.Done.Lift = true; 
		self.Speed.Lift = 30.0; 
		self.isOpen=not self.isOpen;
		self.rotation2Max=not self.rotation2Max;
		self.rotation3Max=not self.rotation3Max;
		-- self.rotation7Max=not self.rotation7Max;
		self.free=not self.free;
		self.rotation4Max  =true;
		self.rotation5Max  =true;
		self.rotation6Max  =true;
	end; 
	
    return BaseMission.VEHICLE_LOAD_OK;
end;
function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;