-- xyzspain

Kverneland3632FT = {};

function Kverneland3632FT.prerequisitesPresent(specializations)
     return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Kverneland3632FT:load(xmlFile)
	-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	

    
  self.discos = {};

    local psFile = getXMLString(xmlFile, "vehicle.discos.disco(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.discos.disco(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.discos, node);
            end;
            i = i+1;
        end;
    end;
	
	 self.acondicionadores = {};

    local psFile = getXMLString(xmlFile, "vehicle.acondicionadores.acondicionador(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.acondicionadores.acondicionador(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.acondicionadores, node);
            end;
            i = i+1;
        end;
    end;
	--------------------
	
	--------------------
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.5);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
				-------------------------
	

		-- animacion
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.animParts = {}
	self.Activated = {};
	------
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	
	
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
		local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.Activated[nameR] = false;
		-----
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
		
		
		
	end; 	
	
	self.AllActivated = SpecializationUtil.callSpecializationsFunction("AllActivated");
	------
		--------------------------
	 local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;
	
		---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	
	------------------------------
		--- ajuste orientacion attach
		self.doJointOrientation = false;
		self.attacherJointCopy = nil;
		self.updateJoint = false;
		
	local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
	end;
 
		--------------------------
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;

	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
	self.free = false;
	
	 self.isTurnedOn = false;
    self.wasToFast = false;
end;
function Kverneland3632FT:delete()
    if self.mowerSound ~= nil then
        delete(self.mowerSound);
    end;
end;

function Kverneland3632FT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kverneland3632FT:keyEvent(unicode, sym, modifier, isDown)
self.on=true;
end;

function Kverneland3632FT:update(dt)
if self.Go.Trsp ~= nil and self.Done.Trsp ~= false then
			self:anim("Trsp", false); 
end;

	if self.doJointOrientation and self.attacherVehicle ~= nil then
		for k,v in pairs(self.attacherVehicle.attachedImplements) do
			if v.object == self then
				local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
				self.attacherJointCopy = {};
				self.attacherJointCopy.joint = joint;	
				self.attacherJointCopy.minRotCopy = joint.minRot;
				self.attacherJointCopy.maxRotCopy = joint.maxRot;
				joint.minRot = joint.maxRot;
			end;
		end;
		self.doJointOrientation = false;
	end;
if self.attacherVehicle ~= nil then
		
    self.wasToFast = false;
	if self:getIsActiveForInput() then
	
	
		self.isModifierActive = false;
		local hydraulicMovingDirection = 0;
		
		
		
		   if InputBinding.hasEvent (InputBinding.SWITCH_IMPLEMENT) then 
			self.on=not self.on;
			end;
		if self.on then
				---- ajuste attach
		
				if InputBinding.isPressed(InputBinding.LOWER_HYDRAULIC) then
					hydraulicMovingDirection = -1;
				elseif InputBinding.isPressed(InputBinding.LIFT_HYDRAULIC) then
					hydraulicMovingDirection = 1;
				end;
			
	
			local jointDesc = self.attacherJointCopy.joint;
			setJointRotationLimit(jointDesc.jointIndex, 2, true, math.rad(0), math.rad(0));
			jointDesc.moveDown = false;
			self.movingDirection = 1;
			if hydraulicMovingDirection ~= 0 then				
				if jointDesc.rotationNode ~= nil then
					local x, y, z = getRotation(jointDesc.rotationNode);
					local rot = {x,y,z};
					local newRot = Utils.getMovedLimitedValues(rot, self.attacherJointCopy.maxRotCopy, self.attacherJointCopy.minRotCopy, 3, jointDesc.moveTime, dt, hydraulicMovingDirection == 1);
					setRotation(jointDesc.rotationNode, unpack(newRot));
					jointDesc.maxRot = newRot;
					jointDesc.minRot = newRot;
					setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
				end;
			end;
		
		
		
			if InputBinding.hasEvent (InputBinding.TURN_UP) then
				self.down=not self.down;
			
			end;
			if InputBinding.hasEvent (InputBinding.TURN_DOWN) then
				self.up=not self.up;
			
			end;
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self.free=not self.free;
				
			end;
			
			
				
			
			if not self.isTurnedOn then	
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.isOpen=not self.isOpen;
				self.isTurnedOn =false;
				end;
			end;
			
			if self.isOpen then
				 self.rotation1Max=true;
				self.Go.Trsp=true;
				self.Done.Trsp= true;
				
			elseif not self.isOpen then
				self.rotation1Max=false;
				self.Go.Trsp=false;
				self.Done.Trsp= true;
				
			end;
	if (self.CheckDone["Trsp"] == true) and self.Activated["Trsp"] == false then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self.isTurnedOn = not self.isTurnedOn;
				end;
	end;			
			
			
			
				self.Speed.Trsp= 0.8; 
		end;
	end;
if self:getIsActive() then
       
	  if self.isTurnedOn then
		 for i=1, table.getn(self.discos) do
                local disco = self.discos[i].index;
                local discoRot = (-0.7*self.discos[i].direction)*dt;
                rotate(disco,0 , discoRot, 0);
            end;
			  for i=1, table.getn(self.acondicionadores) do
                local acondicionador = self.acondicionadores[i].index;
                local acondicionadorRot = (-0.6*self.acondicionadores[i].direction)*dt;
                rotate(acondicionador, acondicionadorRot, 0, 0 );
            end;
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
            if terrainHeight+self.groundReferenceThreshold >= y then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 30;
				if not toFast then
					local area = 0;
					local areaWheat = 0;
					local areaBarley = 0;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
						if k == 1 then
							local x,y,z = getWorldTranslation(self.cuttingAreas[k].start);
							local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[k].width);
							local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[k].height);
							area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
							areaWheat = Utils.cutFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
							areaBarley = Utils.cutFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
						else
							local x,y,z = getWorldTranslation(self.cuttingAreas[k].start);
							local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[k].width);
							local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[k].height);
							if area > 0 then
								local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2);							
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, value, true, false);						
							end;
							if areaWheat > 0 then							
								local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);	
							end;
							if areaBarley > 0 then
								local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);							
							end;
						end;
                    end;
                end;
				self.wasToFast = toFast;
            end;
            if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                self.mowerSoundEnabled = true;
            end;
        else
            if self.mowerSoundEnabled then
                stopSample(self.mowerSound);
                self.mowerSoundEnabled = false;
            end;
      

				
        end;--turnedon
	end; ----active
end; ---attacher
	if self.rotation1Max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	

	if self.translation1Max ~= nil then
					local x, y, z = getTranslation(self.translation1.node);
					local trans = {x,y,z};
					local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1Max);
					setTranslation(self.translation1.node, unpack(newTrans));
				end;
	 if self.down then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
	    end;		
		if self.up then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
	    end;  			
	
	--- asignacion de libertad ejes de rotacion segun condiciones de emsamblage  0 x, 2 y ,1 z 
	
	
	
	self:setJointRotLimit(self.componentJoints[1],110, 0, 1000, self.free == true, 0,dt);	
	self:setJointRotLimit(self.componentJoints[2],60, 0, 1000, self.free == true, 0,dt);	
	self:setJointRotLimit(self.componentJoints[3],60, 0, 1000, self.free == true, 0,dt);	
	self:setJointRotLimit(self.componentJoints[4],110, 0, 1000,self.free == true, 0,dt);				
	self:setJointRotLimit(self.componentJoints[5],20, 0, 1000, self.free == true, 0,dt);			
	self:setJointRotLimit(self.componentJoints[6],60, 0, 1000, self.free == true, 0,dt);			
	self:setJointRotLimit(self.componentJoints[7],15, 0, 1000, self.free == true, 0,dt);			
	
	
	
	
	local joint = self.componentJoints[1];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[7];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[8];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[9];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[10];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[11];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			local joint = self.componentJoints[12];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
			self:setHydraulicDirection();
		
		
end;



function Kverneland3632FT:draw()
   if self.attacherVehicle  then
	
		g_currentMission:addExtraPrintText(g_i18n:getText(self.vehicleType..".2"));
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".3"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
		
		
	
		 if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.vehicleType..".1"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
    end;

	
end;

   
end;
function Kverneland3632FT:onAttach()
	self.doJointOrientation = true;	
	setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(0), math.rad(0));
	setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(0), math.rad(0));
	self.on=false;
	self.isTurnedOn = false;
	self.translation1Max=true;
self.free = false;
end;
function Kverneland3632FT:onDetach()
	self.isTurnedOn = false;
	self.translation1Max=false;
	self.on=false;
	self.free = false;
    if self.deactivateOnDetach then
        Kverneland3632FT.onDeactivate(self);
    else
        Kverneland3632FT.onDeactivateSounds(self)
    end;
	if self.attacherJointCopy ~= nil then
		local jointDesc = self.attacherJointCopy.joint;
		jointDesc.maxRot = self.attacherJointCopy.maxRotCopy;
		jointDesc.minRot = self.attacherJointCopy.minRotCopy;
	end;
	setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(0), math.rad(0));
	setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(0), math.rad(0));
	
end;

function Kverneland3632FT:onLeave()
    if self.deactivateOnLeave then
        Kverneland3632FT.onDeactivate(self);
    else
        Kverneland3632FT.onDeactivateSounds(self)
    end;
end;

function Kverneland3632FT:onDeactivate()
    Kverneland3632FT.onDeactivateSounds(self)

    self.isTurnedOn = false;
end;

function Kverneland3632FT:onDeactivateSounds()
    if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
end;
function Kverneland3632FT:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end;
function Kverneland3632FT:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;

function Kverneland3632FT:anim(varName, loopCheck)	
	-- print("ANIMATION");
	
	self.Activated[varName] = true;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	 
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
			self.Activated[varName] = false;
		
			---final animacion hacia delante
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -speed);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
			self.Activated[varName] = true;
			---final animacion hacia atras
		
		end;
	end;
end; 


function Kverneland3632FT:AllActivated()
	
	if (self.CheckDone["Trsp"] == true) and not self.Activated["Trsp"]  then
		return true;
	else
		return false;
	end;
	
	
end;
function Kverneland3632FT:getSaveAttributesAndNodes(nodeIdent)
if (self.CheckDone["Trsp"] == true) and self.Activated["Trsp"] == false then
					
	Trsp = "true";	
else		
	Trsp = "false";	
end;		
		

	-- 'name="'..tostring(name)..'" name="'..tonumber(name)..'"';
	 local attributes = 'Trsp="'..tostring(Trsp)..'"';
	
	return attributes, nil;
end;


function Kverneland3632FT:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local Trsp = getXMLString(xmlFile, key.."#Trsp");
	
	if Trsp == "true" and not resetVehicles then
		self.Go.Trsp = not self.Go.Trsp ; 
		self.Done.Trsp = true; 
		self.Speed.Trsp = 30.0; 
		self.isOpen=not self.isOpen;
		self.rotation1Max=not self.rotation1Max;
	end; 
	
    return BaseMission.VEHICLE_LOAD_OK;
end;






