StollGXT = {};

function StollGXT.prerequisitesPresent(specializations)
    return true;
end;

function StollGXT:load(xmlFile)

	self.startMower = SpecializationUtil.callSpecializationsFunction("startMower");
	self.stopMower = SpecializationUtil.callSpecializationsFunction("stopMower");
	self.setWindrowStatus = SpecializationUtil.callSpecializationsFunction("setWindrowStatus");
	self.playHydraulicSound = SpecializationUtil.callSpecializationsFunction("playHydraulicSound");

    self.groundReferenceNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNodeLeft#index"));
	self.groundReferenceNodeRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNodeRight#index"));
    
    local workSoundStart = getXMLString(xmlFile, "vehicle.workSoundStart#file");
    if workSoundStart ~= nil and workSoundStart ~= "" then
       workSoundStart = Utils.getFilename(workSoundStart, self.baseDirectory);
       self.workSoundStart = createSample("workSoundStart");
       self.workSoundStartEnabled = false;
	   self.playStartSoundTime = 0;
       loadSample(self.workSoundStart, workSoundStart, false);
       self.workSoundStartPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSoundStart#pitchOffset"), 1);
       self.workSoundStartVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSoundStart#volume"), 1);
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
       workSound = Utils.getFilename(workSound, self.baseDirectory);
       self.workSound = createSample("workSound");
       self.workSoundEnabled = false;
       loadSample(self.workSound, workSound, false);
       self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
       self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	local workSoundStop = getXMLString(xmlFile, "vehicle.workSoundStop#file");
    if workSoundStop ~= nil and workSoundStop ~= "" then
       workSoundStop = Utils.getFilename(workSoundStop, self.baseDirectory);
       self.workSoundStop = createSample("workSoundStop");
       self.workSoundStopEnabled = false;
       loadSample(self.workSoundStop, workSoundStop, false);
       self.workSoundStopPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSoundStop#pitchOffset"), 1);
       self.workSoundStopVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSoundStop#volume"), 1);
    end;
	
	local hydraulicSound = getXMLString(xmlFile, "vehicle.hydraulicSound#file");
    if hydraulicSound ~= nil and hydraulicSound ~= "" then
        self.hydraulicSound = createSample("hydraulicSound");
        loadSample(self.hydraulicSound, hydraulicSound, false);
        self.hydraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchOffset"), 1);
        self.hydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchMax"), 2.0);
        self.hydraulicSoundEnabled = false;
    end;
	
	local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	local numParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotationParts#count"), 0);
    self.rotationParts = {};
    for i=1, numParts do
        local partNamei = string.format("vehicle.rotationParts.rotationPart%d", i);
        self.rotationParts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partNamei .. "#index"));
    end;
	
	self.particleSystems = {};
	
	self.psRightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.particleSystemRightNode#index"));
	self.particleSystemRight = {};
	local psNameRight = "vehicle.particleSystemRightGrass";
	Utils.loadParticleSystem(xmlFile, self.particleSystemRight, psNameRight, self.psRightNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemRight);
	
	self.psLeftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.particleSystemLeftNode#index"));
	self.particleSystemLeft = {};
	local psNameLeft = "vehicle.particleSystemLeftGrass";
	Utils.loadParticleSystem(xmlFile, self.particleSystemLeft, psNameLeft, self.psLeftNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemLeft);
	
	self.psWindrowRightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.particleSystemWindrowRightNode#index"));
	self.particleSystemWindrowRight = {};
	local psNameWindrowRight = "vehicle.particleSystemWindrowRightGrass";
	Utils.loadParticleSystem(xmlFile, self.particleSystemWindrowRight, psNameWindrowRight, self.psWindrowRightNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemWindrowRight);
	
	self.psWindrowLeftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.particleSystemWindrowLeftNode#index"));
	self.particleSystemWindrowLeft = {};
	local psNameWindrowLeft = "vehicle.particleSystemWindrowLeftGrass";
	Utils.loadParticleSystem(xmlFile, self.particleSystemWindrowLeft, psNameWindrowLeft, self.psWindrowLeftNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemWindrowLeft);
	
	self.particleSystemRightStraw = {};
	local psNameRightStraw = "vehicle.particleSystemRightStraw";
	Utils.loadParticleSystem(xmlFile, self.particleSystemRightStraw, psNameRightStraw, self.psRightNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemRightStraw);
	
	self.particleSystemLeftStraw = {};
	local psNameLeftStraw = "vehicle.particleSystemLeftStraw";
	Utils.loadParticleSystem(xmlFile, self.particleSystemLeftStraw, psNameLeftStraw, self.psLeftNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemLeftStraw);
	
	self.particleSystemWindrowRightStraw = {};
	local psNameWindrowRightStraw = "vehicle.particleSystemWindrowRightStraw";
	Utils.loadParticleSystem(xmlFile, self.particleSystemWindrowRightStraw, psNameWindrowRightStraw, self.psWindrowRightNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemWindrowRightStraw);
	
	self.particleSystemWindrowLeftStraw = {};
	local psNameWindrowLeftStraw = "vehicle.particleSystemWindrowLeftStraw";
	Utils.loadParticleSystem(xmlFile, self.particleSystemWindrowLeftStraw, psNameWindrowLeftStraw, self.psWindrowLeftNode, false, nil, self.baseDirectory);
	table.insert(self.particleSystems, self.particleSystemWindrowLeftStraw);
	
	self.shaderPart1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shaderParts#part1"));
	self.shaderPart2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shaderParts#part2"));
	setShaderParameter(self.shaderPart1, "partScale",90000000000,1,0, 0,false);
	setShaderParameter(self.shaderPart2, "partScale",90000000000,1,0, 0,false);
	
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armLinks#rotLimit"));
    local rotLimitsArmLinks = {};
    rotLimitsArmLinks[1] = math.rad(Utils.getNoNil(x, 0));
    rotLimitsArmLinks[2] = math.rad(Utils.getNoNil(y, 0));
    rotLimitsArmLinks[3] = math.rad(Utils.getNoNil(z, 0));
	self.rotLimitArmLinks = {0, 0, 0};
	self.maxRotLimitArmLinks = {rotLimitsArmLinks[1], rotLimitsArmLinks[2], rotLimitsArmLinks[3]};
	
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.messerLinks#rotLimit"));
    local rotLimitsMesserLinks = {};
    rotLimitsMesserLinks[1] = math.rad(Utils.getNoNil(x, 0));
    rotLimitsMesserLinks[2] = math.rad(Utils.getNoNil(y, 0));
    rotLimitsMesserLinks[3] = math.rad(Utils.getNoNil(z, 0));
	self.rotLimitMesserLinks = {0, 0, 0};
	self.maxRotLimitMesserLinks = {rotLimitsMesserLinks[1], rotLimitsMesserLinks[2], rotLimitsMesserLinks[3]};
	
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armRechts#rotLimit"));
    local rotLimitsArmRechts = {};
    rotLimitsArmRechts[1] = math.rad(Utils.getNoNil(x, 0));
    rotLimitsArmRechts[2] = math.rad(Utils.getNoNil(y, 0));
    rotLimitsArmRechts[3] = math.rad(Utils.getNoNil(z, 0));
	self.rotLimitArmRechts = {0, 0, 0};
	self.maxRotLimitArmRechts = {rotLimitsArmRechts[1], rotLimitsArmRechts[2], rotLimitsArmRechts[3]};
	
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.messerRechts#rotLimit"));
    local rotLimitsMesserRechts = {};
    rotLimitsMesserRechts[1] = math.rad(Utils.getNoNil(x, 0));
    rotLimitsMesserRechts[2] = math.rad(Utils.getNoNil(y, 0));
    rotLimitsMesserRechts[3] = math.rad(Utils.getNoNil(z, 0));
	self.rotLimitMesserRechts = {0, 0, 0};
	self.maxRotLimitMesserRechts = {rotLimitsMesserRechts[1], rotLimitsMesserRechts[2], rotLimitsMesserRechts[3]};
	
	self.isTurnedOn = false;
	self.readyToMow = false;
	self.makeWindrow = false;
	self.readyToWindrow = false;
	self.time = 0;
	self.turnSpeed = 0;
    self.wasToFast = false;
	self.foldInStreetMode = false;
	self.timer = 0;

	self.infoPanelPath = Utils.getFilename("hud.png", self.baseDirectory);
	self.HudWidth = 0.326;
	self.HudHeight = 0.232;
	self.HudPosX = g_currentMission.hudHelpBaseWidth+0.03; --0.437;
	self.HudPosY = 1-self.HudHeight;
	self.infoPanelOverlay = Overlay:new("InfoPanel", self.infoPanelPath, self.HudPosX, self.HudPosY, self.HudWidth, self.HudHeight);
	
end;

function StollGXT:delete()
    if self.workSoundStart ~= nil then
        delete(self.workSoundStart);
    end;
	if self.workSound ~= nil then
        delete(self.workSound);
    end;
	if self.workSoundStop ~= nil then
        delete(self.workSoundStop);
    end;
	if self.hydraulicSound ~= nil then
        delete(self.hydraulicSound);
    end;
	if self.infoPanelOverlay ~= nil then
        delete(self.infoPanelOverlay);
    end;
	for k, v in pairs(self.particleSystems) do
		Utils.deleteParticleSystem(self.particleSystems[k]);
	end;
end;

function StollGXT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StollGXT:keyEvent(unicode, sym, modifier, isDown)
end;

function StollGXT:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local transportMode = getXMLString(xmlFile, key.."#transportMode");
    local windrow = getXMLString(xmlFile, key.."#windrow");
	local isDownLeft = getXMLString(xmlFile, key.."#isDownLeft");
	local isDownRight = getXMLString(xmlFile, key.."#isDownRight");
    if transportMode ~= nil and transportMode == "true" then
        self.Speed.StollGTXTransport = 20;
		self.Go.StollGTXTransport = true;
		self.Done.StollGTXTransport = true;
    end;
	if windrow ~= nil and windrow == "true" then
		self.Speed.StollGTXBandHub = 20;
		self.Go.StollGTXBandHub = true;
		self.Done.StollGTXBandHub = true;
		self.makeWindrow = true;
		self.readyToWindrow = true;
	end;
	if isDownLeft ~= nil and isDownLeft == "false" then
		self.Speed.StollGTXHubLeft = 20;
		self.Go.StollGTXHubLeft = true;
		self.Done.StollGTXHubLeft = true;
	end;
	if isDownRight ~= nil and isDownRight == "false" then
		self.Speed.StollGTXHubRight = 20;
		self.Go.StollGTXHubRight = true;
		self.Done.StollGTXHubRight = true;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function StollGXT:getSaveAttributesAndNodes(nodeIdent)
    local transportMode = "false";
	local windrow = "false";
	local isDownLeft = "true";
	local isDownRight = "true";
    if self.CheckDone.StollGTXTransport then
        transportMode = "true";
    end;
	if self.CheckDone.StollGTXBandHub then
        windrow = "true";
    end;
	if self.CheckDone.StollGTXHubLeft then
        isDownLeft = "false";
    end;
	if self.CheckDone.StollGTXHubRight then
        isDownRight = "false";
    end;
    local attributes = 'transportMode="'..transportMode..'" windrow="'..windrow..'"  isDownLeft="'..isDownLeft..'"  isDownRight="'..isDownRight..'"';
    return attributes, nil;
end;

function StollGXT:update(dt)

	self.time = self.time+dt;
	self:playHydraulicSound(dt);
	
	self:anim("StollGTXSupport", false);
	self:anim("StollGTXTransport", false);
	self:anim("StollGTXHubRight", false);
	self:anim("StollGTXHubLeft", false);
	self:anim("StollGTXBandHub", false);
	
	local joint = self.componentJoints[3];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[4];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[5];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[6];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	local joint = self.componentJoints[7];
	setJointFrame(joint.jointIndex, 0,joint.jointNode);
	
	local newRotLimit = {0,0,0};
	newRotLimit = Utils.getMovedLimitedValues(self.rotLimitArmLinks, self.maxRotLimitArmLinks, {0,0,0}, 3, 1500, dt, self.Go.StollGTXHubLeft);
	for i=1, 3 do
		if math.abs(newRotLimit[i] - self.rotLimitArmLinks[i]) > 0.001 then
			setJointRotationLimit(self.componentJoints[3].jointIndex, i-1, true, -newRotLimit[i], newRotLimit[i]);
		end;
	end;
	self.rotLimitArmLinks = newRotLimit;
	
	local newRotLimit = {0,0,0};
	newRotLimit = Utils.getMovedLimitedValues(self.rotLimitMesserLinks, self.maxRotLimitMesserLinks, {0,0,0}, 3, 1500, dt, self.Go.StollGTXHubLeft);
	for i=1, 3 do
		if math.abs(newRotLimit[i] - self.rotLimitMesserLinks[i]) > 0.001 then
			setJointRotationLimit(self.componentJoints[5].jointIndex, i-1, true, -newRotLimit[i], newRotLimit[i]);
		end;
	end;
	self.rotLimitMesserLinks = newRotLimit;
	
	local newRotLimit = {0,0,0};
	newRotLimit = Utils.getMovedLimitedValues(self.rotLimitArmRechts, self.maxRotLimitArmRechts, {0,0,0}, 3, 1500, dt, self.Go.StollGTXHubRight);
	for i=1, 3 do
		if math.abs(newRotLimit[i] - self.rotLimitArmRechts[i]) > 0.001 then
			setJointRotationLimit(self.componentJoints[4].jointIndex, i-1, true, -newRotLimit[i], newRotLimit[i]);
		end;
	end;
	self.rotLimitArmRechts = newRotLimit;
	
	local newRotLimit = {0,0,0};
	newRotLimit = Utils.getMovedLimitedValues(self.rotLimitMesserRechts, self.maxRotLimitMesserRechts, {0,0,0}, 3, 1500, dt, self.Go.StollGTXHubRight);
	for i=1, 3 do
		if math.abs(newRotLimit[i] - self.rotLimitMesserRechts[i]) > 0.001 then
			setJointRotationLimit(self.componentJoints[6].jointIndex, i-1, true, -newRotLimit[i], newRotLimit[i]);
		end;
	end;
	self.rotLimitMesserRechts = newRotLimit;
	
    self.wasToFast = false;
    if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.StollGTXTransport) then
			if self.CheckDone.StollGTXTransport then
				self.foldInStreetMode = false;
				self.Speed.StollGTXTransport = 1;
				self.Go.StollGTXTransport = false;
				self.Done.StollGTXTransport = true;
			else
				self:stopMower();
				self:setWindrowStatus(false);
				self.Speed.StollGTXHubRight = 1;
				self.Go.StollGTXHubRight = true;
				self.Done.StollGTXHubRight = true;
				self.Speed.StollGTXHubLeft = 1;
				self.Go.StollGTXHubLeft = true;
				self.Done.StollGTXHubLeft = true;
				self.foldInStreetMode = true;
			end;
		end;
		if self.foldInStreetMode and self.CheckDone.StollGTXHubLeft and self.CheckDone.StollGTXHubLeft and not self.CheckDone.StollGTXBandHub then
			self.Speed.StollGTXTransport = 1;
			self.Go.StollGTXTransport = true;
			self.Done.StollGTXTransport = true;
		end;
		if self.currentPosition.StollGTXTransport < 20 then
			if InputBinding.hasEvent(InputBinding.StollGTXHubLeft) then
				self.Speed.StollGTXHubLeft = 1;
				self.Go.StollGTXHubLeft = not self.Go.StollGTXHubLeft;
				self.Done.StollGTXHubLeft = true;
			end;
			if InputBinding.hasEvent(InputBinding.StollGTXHubRight) then
				self.Speed.StollGTXHubRight = 1;
				self.Go.StollGTXHubRight = not self.Go.StollGTXHubRight;
				self.Done.StollGTXHubRight = true;
			end;
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self.Speed.StollGTXHubLeft = 1;
				self.Speed.StollGTXHubRight = 1;
				if self.CheckDone.StollGTXHubRight then
					self.Go.StollGTXHubRight = false;
					self.Done.StollGTXHubRight = true;
					self.Go.StollGTXHubLeft = false;
					self.Done.StollGTXHubLeft = true;
				else
					self.Go.StollGTXHubRight = true;
					self.Done.StollGTXHubRight = true;
					self.Go.StollGTXHubLeft = true;
					self.Done.StollGTXHubLeft = true;
				end;
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				if self.isTurnedOn then
					self:stopMower();
				else
					self:startMower();
				end;
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				if self.makeWindrow then
					self:setWindrowStatus(false);
				else
					self:setWindrowStatus(true);
				end;
			end;
		end;
    end;
	
	if self.readyToWindrow and self.isTurnedOn then
		setShaderParameter(self.shaderPart1, "partScale",-1,1,0, 0, false);
		setShaderParameter(self.shaderPart2, "partScale",-1,1,0, 0, false);
	else
		setShaderParameter(self.shaderPart1, "partScale",90000000000,1,0, 0, false);
		setShaderParameter(self.shaderPart2, "partScale",90000000000,1,0, 0, false);
	end;

    if self:getIsActive() then
		if self.isTurnedOn and self.playStartSoundTime <= self.time and not self.workSoundEnabled then
			stopSample(self.workSoundStart);
			self.workSoundStartEnabled = false;
			playSample(self.workSound, 0, self.workSoundVolume, 0);
			setSamplePitch(self.workSound, self.workSoundPitchOffset);
			self.readyToMow = true;
			self.workSoundEnabled = true;
		end;
		if self.makeWindrow then
			if self.currentPosition.StollGTXBandHub > 1800 then
				self.readyToWindrow = true;
			else
				self.readyToWindrow = false;
			end;
		else
			self.readyToWindrow = false;
		end;
		if self.isTurnedOn and not self.readyToMow then
			self.turnSpeed = self.turnSpeed-0.05;
			if self.turnSpeed < -6 then
				self.turnSpeed = -6;
			end;
		end;
		if not self.isTurnedOn then
			self.turnSpeed = self.turnSpeed+0.03;
			if self.turnSpeed > 0 then
				self.turnSpeed = 0;
			end;
		end;
		if self.readyToMow and self.isTurnedOn then
			for k, part in pairs(self.rotationParts) do
				rotate(part, dt*-0.095, 0, 0);
			end;
		else
			for k, part in pairs(self.rotationParts) do
				rotate(part, self.turnSpeed, 0, 0);
			end;
		end;
        if self.readyToMow then
			local grassArea = 0;
			local wheatArea = 0;
			local barleyArea = 0;
			local xL,yL,zL = getWorldTranslation(self.groundReferenceNodeLeft);
			local xR,yR,zR = getWorldTranslation(self.groundReferenceNodeRight);
			local terrainHeightL = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, xL, 0, zL);
			local terrainHeightR = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, xR, 0, zR);
			if terrainHeightL >= yL then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
				if not toFast then
					local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
					grassArea = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
					wheatArea = Utils.cutFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
					barleyArea = Utils.cutFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
					if grassArea ~= 0 and self.readyToWindrow then 
						local ratio = g_currentMission.windrowCutLongRatio;
						local fruitType = FruitUtil.FRUITTYPE_GRASS;
						local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
						area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
						if area == 0 then
							fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
							area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
							area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
						end;
						if area > 0 then
							local dropArea = self.windrowerDropAreas[1];
							local x,y,z = getWorldTranslation(dropArea.start);
							local x1,y1,z1 = getWorldTranslation(dropArea.width);
							local x2,y2,z2 = getWorldTranslation(dropArea.height);
							local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
							area = area + old;
							local value = area / total;
							if value < 1 and value > 0.08 then
								value = 1;
							else
								value = math.floor(value + 0.6);
							end;
							if value >= 1 then
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
							end;
						end;
					end;
					if wheatArea ~= 0 then
						if self.readyToWindrow then
							local dropArea = self.windrowerDropAreas[1];
							x,y,z = getWorldTranslation(dropArea.start);
							x1,y1,z1 = getWorldTranslation(dropArea.width);
							x2,y2,z2 = getWorldTranslation(dropArea.height);
						end;
						local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
						local value = 1+math.floor(old / total + 0.7);
						value = math.min(value, g_currentMission.maxWindrowValue);
						Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);	
					end;
					if barleyArea ~= 0 then
						if self.readyToWindrow then
							local dropArea = self.windrowerDropAreas[1];
							x,y,z = getWorldTranslation(dropArea.start);
							x1,y1,z1 = getWorldTranslation(dropArea.width);
							x2,y2,z2 = getWorldTranslation(dropArea.height);
						end;
						local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
						local value = 1+math.floor(old / total + 0.7);
						value = math.min(value, g_currentMission.maxWindrowValue);
						Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);							
					end;
					if grassArea > 0 then
						Utils.setEmittingState(self.particleSystems[2], true);
						if self.readyToWindrow then
							Utils.setEmittingState(self.particleSystems[4], true);
						else
							Utils.setEmittingState(self.particleSystems[4], false);
						end;
					else
						Utils.setEmittingState(self.particleSystems[2], false);
						Utils.setEmittingState(self.particleSystems[4], false);
						if barleyArea ~= 0 or wheatArea ~= 0 then
							Utils.setEmittingState(self.particleSystems[6], true);
							if self.readyToWindrow then
								Utils.setEmittingState(self.particleSystems[8], true);
							else
								Utils.setEmittingState(self.particleSystems[8], false);
							end;
						else
							Utils.setEmittingState(self.particleSystems[6], false);
							Utils.setEmittingState(self.particleSystems[8], false);
						end;
					end;
				else
					Utils.setEmittingState(self.particleSystems[2], false);
					Utils.setEmittingState(self.particleSystems[4], false);
					Utils.setEmittingState(self.particleSystems[6], false);
					Utils.setEmittingState(self.particleSystems[8], false);
				end;
			else
				Utils.setEmittingState(self.particleSystems[2], false);
				Utils.setEmittingState(self.particleSystems[4], false);
				Utils.setEmittingState(self.particleSystems[6], false);
				Utils.setEmittingState(self.particleSystems[8], false);
			end;
			if terrainHeightR >= yR then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
				if not toFast then
					local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
					local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
					local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
					grassArea = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
					wheatArea = Utils.cutFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
					barleyArea = Utils.cutFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
					if grassArea ~= 0 and self.readyToWindrow then 
						local ratio = g_currentMission.windrowCutLongRatio;
						local fruitType = FruitUtil.FRUITTYPE_GRASS;
						local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
						area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
						if area == 0 then
							fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
							area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
							area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
						end;
						if area > 0 then
							local dropArea = self.windrowerDropAreas[2];
							local x,y,z = getWorldTranslation(dropArea.start);
							local x1,y1,z1 = getWorldTranslation(dropArea.width);
							local x2,y2,z2 = getWorldTranslation(dropArea.height);
							local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
							area = area + old;
							local value = area / total;
							if value < 1 and value > 0.08 then
								value = 1;
							else
								value = math.floor(value + 0.6);
							end;
							if value >= 1 then
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
							end;
						end;
					end;
					if wheatArea ~= 0 then
						if self.readyToWindrow then
							local dropArea = self.windrowerDropAreas[2];
							x,y,z = getWorldTranslation(dropArea.start);
							x1,y1,z1 = getWorldTranslation(dropArea.width);
							x2,y2,z2 = getWorldTranslation(dropArea.height);
						end;
						local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
						local value = 1 + math.floor(old / total + 0.7);
						value = math.min(value, g_currentMission.maxWindrowValue);
						Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);	
					end;
					if barleyArea ~= 0 then
						if self.readyToWindrow then
							local dropArea = self.windrowerDropAreas[2];
							x,y,z = getWorldTranslation(dropArea.start);
							x1,y1,z1 = getWorldTranslation(dropArea.width);
							x2,y2,z2 = getWorldTranslation(dropArea.height);
						end;
						local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
						local value = 1 + math.floor(old / total + 0.7);
						value = math.min(value, g_currentMission.maxWindrowValue);
						Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);							
					end;
					if grassArea > 0 then
						Utils.setEmittingState(self.particleSystems[1], true);
						if self.readyToWindrow then
							Utils.setEmittingState(self.particleSystems[3], true);
						else
							Utils.setEmittingState(self.particleSystems[3], false);
						end;
					else
						Utils.setEmittingState(self.particleSystems[1], false);
						Utils.setEmittingState(self.particleSystems[3], false);
						if barleyArea ~= 0 or wheatArea ~= 0 then
							Utils.setEmittingState(self.particleSystems[5], true);
							if self.readyToWindrow then
								Utils.setEmittingState(self.particleSystems[7], true);
							else
								Utils.setEmittingState(self.particleSystems[7], false);
							end;
						else
							Utils.setEmittingState(self.particleSystems[5], false);
							Utils.setEmittingState(self.particleSystems[7], false);
						end;
					end;
				else
					Utils.setEmittingState(self.particleSystems[1], false);
					Utils.setEmittingState(self.particleSystems[3], false);
					Utils.setEmittingState(self.particleSystems[5], false);
					Utils.setEmittingState(self.particleSystems[7], false);
				end;
				self.wasToFast = toFast;
			else
				Utils.setEmittingState(self.particleSystems[1], false);
				Utils.setEmittingState(self.particleSystems[3], false);
				Utils.setEmittingState(self.particleSystems[5], false);
				Utils.setEmittingState(self.particleSystems[7], false);
			end;
		else
			for k, v in pairs(self.particleSystems) do
				Utils.setEmittingState(self.particleSystems[k], false);
			end;
			self.wasToFast = false;
        end;
    end;
end;

function StollGXT:playHydraulicSound(dt)
	local playSound = false;
	if self.currentPosition.StollGTXTransport > 100 and not self.Go.StollGTXTransport then
		playSound = true;
	end;
	if self.currentPosition.StollGTXTransport < 7900 and self.Go.StollGTXTransport then
		playSound = true;
	end;
	if self.currentPosition.StollGTXHubLeft > 1200 and not self.Go.StollGTXHubLeft then
		playSound = true;
	end;
	if self.currentPosition.StollGTXHubLeft < 2450 and self.Go.StollGTXHubLeft then
		playSound = true;
	end;
	if self.currentPosition.StollGTXHubRight > 1200 and not self.Go.StollGTXHubRight then
		playSound = true;
	end;
	if self.currentPosition.StollGTXHubRight < 2450 and self.Go.StollGTXHubRight then
		playSound = true;
	end;
	if self.currentPosition.StollGTXBandHub > 100 and not self.Go.StollGTXBandHub then
		playSound = true;
	end;
	if self.currentPosition.StollGTXBandHub < 1970 and self.Go.StollGTXBandHub then
		playSound = true;
	end;
	if playSound then
		if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
			playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
			setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset-0.4);
			self.hydraulicSoundEnabled = true;   
		end;
	else
		if self.hydraulicSoundEnabled then
			stopSample(self.hydraulicSound);
			self.hydraulicSoundEnabled = false;   
		end;
	end;
end;

function StollGXT:draw()
    if g_currentMission.showHelpText then
		if self.CheckDone.StollGTXTransport then
			g_currentMission:addHelpButtonText(g_i18n:getText("StollGXT_1"), InputBinding.StollGTXTransport);
		elseif self.currentPosition.StollGTXTransport < 20 then
			if self.wasToFast then
				g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
			end;
			self.infoPanelOverlay:render();
			renderText(self.HudPosX+0.085, self.HudPosY+0.108, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollGTXTransport)));
			if self.CheckDone.StollGTXHubLeft then
				renderText(self.HudPosX+0.006, self.HudPosY+0.13, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollGTXHubLeft)));
			elseif self.currentPosition.StollGTXHubLeft < 20 then
				renderText(self.HudPosX+0.006, self.HudPosY+0.01, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollGTXHubLeft)));
			end;
			if self.CheckDone.StollGTXHubRight then
				renderText(self.HudPosX+0.085, self.HudPosY+0.13, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LOWER_IMPLEMENT)));
				renderText(self.HudPosX+0.17, self.HudPosY+0.13, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollGTXHubRight)));
			elseif self.currentPosition.StollGTXHubRight < 20 then
				renderText(self.HudPosX+0.085, self.HudPosY+0.01, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LOWER_IMPLEMENT)));
				renderText(self.HudPosX+0.17, self.HudPosY+0.01, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.StollGTXHubRight)));
			end;
			if self.CheckDone.StollGTXBandHub then
				renderText(self.HudPosX+0.25, self.HudPosY+0.01, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA2)));
			elseif self.currentPosition.StollGTXBandHub < 20 then
				renderText(self.HudPosX+0.25, self.HudPosY+0.13, 0.025, string.format("%s", InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA2)));
			end;
			if self.isTurnedOn then
				renderText(self.HudPosX+0.045, self.HudPosY+0.17, 0.025, string.format("Key%s: Turn OFF", InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA)));
			else
				renderText(self.HudPosX+0.045, self.HudPosY+0.17, 0.025, string.format("Key%s: Turn ON", InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA)));
			end;
		end;
	end;
end;

function StollGXT:startMower()
	if not self.isTurnedOn then
		if not self.workSoundStartEnabled then
			playSample(self.workSoundStart, 1, self.workSoundStartVolume, 0);
			setSamplePitch(self.workSoundStart, self.workSoundStartPitchOffset);
			self.workSoundStartEnabled = true;
			local startSoundOffset = getSampleDuration(self.workSoundStart); 
			self.playStartSoundTime = self.time+startSoundOffset;			
		end;
		self.workSoundStopEnabled = false;
		self.isTurnedOn = true;
	end;
end;

function StollGXT:stopMower()
    if self.isTurnedOn then
		self.readyToMow = false;
		if self.workSoundStartEnabled then
			stopSample(self.workSoundStart);
			self.workSoundStartEnabled = false;
		end;
		if self.workSoundEnabled then
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
		if not self.workSoundStopEnabled then
			playSample(self.workSoundStop, 1, self.workSoundStopVolume, 0);
			setSamplePitch(self.workSoundStop, self.workSoundStopPitchOffset);
			self.workSoundStopEnabled = true;
		end;
		self.isTurnedOn = false;
		for k, v in pairs(self.particleSystems) do
			Utils.setEmittingState(self.particleSystems[k], false);
		end;
	end;
end;

function StollGXT:setWindrowStatus(status)
    if self.makeWindrow ~= status then
		self.Speed.StollGTXBandHub = 1;
		self.Go.StollGTXBandHub = not self.Go.StollGTXBandHub;
		self.Done.StollGTXBandHub = true;
		self.makeWindrow = status;
	end;
end;

function StollGXT:onAttach()
	self.Go.StollGTXSupport = true;
	self.Done.StollGTXSupport = true;
end;

function StollGXT:onDetach()
	for i=1, table.getn(self.wheels) do
		local wheel = self.wheels[i];
		setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 5, wheel.steeringAngle);
	end;
    if self.deactivateOnDetach then
        StollGXT.onDeactivate(self);
    else
        StollGXT.onDeactivateSounds(self)
    end;
	self.Go.StollGTXSupport = false;
	self.Done.StollGTXSupport = true;
end;

function StollGXT:onLeave()
    if self.deactivateOnLeave then
        StollGXT.onDeactivate(self);
    else
        StollGXT.onDeactivateSounds(self)
    end;
end;

function StollGXT:onDeactivate()
    StollGXT.onDeactivateSounds(self)
	setShaderParameter(self.shaderPart1, "partScale",90000000000,1,0, 0, false);
	setShaderParameter(self.shaderPart2, "partScale",90000000000,1,0, 0, false);
    self:stopMower();
	for k, v in pairs(self.particleSystems) do
		Utils.setEmittingState(self.particleSystems[k], false);
	end;
end;

function StollGXT:onDeactivateSounds()
    if self.workSoundStartEnabled then
        stopSample(self.workSoundStart);
        self.workSoundStartEnabled = false;
    end;
	if self.workSoundEnabled then
        stopSample(self.workSound);
        self.workSoundEnabled = false;
    end;
	if self.workSoundStopEnabled then
        stopSample(self.workSoundStop);
        self.workSoundStopEnabled = false;
    end;
	if self.hydraulicSoundEnabled then
        stopSample(self.hydraulicSound);
        self.hydraulicSoundEnabled = false;
    end;
end;