StollCM = {};

function StollCM.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FastCouplerAttachment, specializations);
end;

function StollCM:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

    local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;
	
	local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint#jointType");
	if jointTypeStr ~= nil then
		local jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		
		if jointType == nil then
			Vehicle.registerJointType(jointTypeStr);
			print("register Jointtype: " .. jointTypeStr);
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
		end;
		
		if jointType ~= nil then
			self.attacherJoint.jointType = jointType;			
		end;
	end;

    self.isTurnedOn = false;
    self.wasToFast = false;
end;

function StollCM:delete()
    if self.mowerSound ~= nil then
        delete(self.mowerSound);
    end;
end;

function StollCM:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StollCM:keyEvent(unicode, sym, modifier, isDown)
end;

function StollCM:update(dt)

    self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;

    if self:getIsActive() then
        if self.isTurnedOn then
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
            if terrainHeight+self.groundReferenceThreshold >= y then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
				if not toFast then
					local area = 0;
					local areaWheat = 0;
					local areaBarley = 0;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
						if k == 1 then
							local x,y,z = getWorldTranslation(self.cuttingAreas[k].start);
							local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[k].width);
							local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[k].height);
							area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
							areaWheat = Utils.cutFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
							areaBarley = Utils.cutFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
						else
							local x,y,z = getWorldTranslation(self.cuttingAreas[k].start);
							local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[k].width);
							local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[k].height);
							if area > 0 then
								local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2);							
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, value, true);						
							end;
							if areaWheat > 0 then							
								local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);	
							end;
							if areaBarley > 0 then
								local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
								local value = 1+math.floor(old / total + 0.7);
								value = math.min(value, g_currentMission.maxWindrowValue);
								Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);							
							end;
						end;
                    end;
                end;
				self.wasToFast = toFast;
            end;
            if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                self.mowerSoundEnabled = true;
            end;
        else
            if self.mowerSoundEnabled then
                stopSample(self.mowerSound);
                self.mowerSoundEnabled = false;
            end;
        end;

    end;

end;

function StollCM:draw()
    if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    end;

    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;
end;

function StollCM:onDetach()
    if self.deactivateOnDetach then
        StollCM.onDeactivate(self);
    else
        StollCM.onDeactivateSounds(self)
    end;
end;

function StollCM:onLeave()
    if self.deactivateOnLeave then
        StollCM.onDeactivate(self);
    else
        StollCM.onDeactivateSounds(self)
    end;
end;

function StollCM:onDeactivate()
    StollCM.onDeactivateSounds(self)

    self.isTurnedOn = false;
end;

function StollCM:onDeactivateSounds()
    if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
end;
