--
-- KroneHud
-- HUD script for the Krone Big X Cargo
--
-- @author  Kyosho
-- @date  04/01/11
--


KroneHud = {};

function KroneHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function KroneHud:load(xmlFile)
    -- Information Hud Dimensions
	self.hudInfoBasePosX = 0.012;
    self.hudInfoBaseWidth = 0.25;
    self.hudInfoBasePosY = 0.01;
    self.hudInfoBaseHeight = 0.22;
	
	-- The actual overlay
	self.infoPanelPath = Utils.getFilename("Textur/hud_info_base.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
		
	-- Boolean to show or hide the 
	self.showHudInfoBase = true;
end;

function KroneHud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function KroneHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneHud:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneHud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.KroneHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;
	
function KroneHud:draw()
	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end;
end;

