KroneBigPack = {};

function KroneBigPack.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function KroneBigPack:load(xmlFile)

		self.rotpart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart#index"));
        self.rotpart2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart2#index"));
		self.rotpart3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotpart3#index"));
		
		self.extraParticleSystems = {};
		local extraParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraParticleSystems#count"), 0);
			for i=1, extraParticleSystemCount do
				local namei = string.format("vehicle.extraParticleSystems.extraParticleSystem%d", i);
				Utils.loadParticleSystem(xmlFile, self.extraParticleSystems, namei, self.components, false, nil, self.baseDirectory)
			end;
			
		self.moveBalesOut = KroneBigPack.moveBalesOut;	
end;


function KroneBigPack:delete()
	Utils.deleteParticleSystem(self.extraParticleSystems);
end;

function KroneBigPack:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneBigPack:keyEvent(unicode, sym, modifier, isDown)
end;

function KroneBigPack:update(dt)
	
	if self:getIsActive() then
        if self.isTurnedOn then
			rotate(self.rotpart, dt*0.02, 0, 0);
			rotate(self.rotpart2, dt*0.02, 0, 0);
			rotate(self.rotpart3, dt*0.02, 0, 0);
			
				if self.movingDirection ~= 0 then
						Utils.setEmittingState(self.extraParticleSystems, true)
					else
						Utils.setEmittingState(self.extraParticleSystems, false)
				end;
			
		end;
		if InputBinding.hasEvent(InputBinding.eject) then
		if self.moveBalesOutside then
				self.printWait = false;
			else
				self:moveBalesOut(dt);
				self.printWait = true;
			end;
			else
				self.printWait = false;
				self.moveBalesOutside = false;
		end;
		
	end;
	
	self.presskanal = true
	
end;

function KroneBigPack:draw()
	if self.presskanal == true then
		g_currentMission:addHelpButtonText(g_i18n:getText("presskanal"), InputBinding.eject);
	end;
end;



function KroneBigPack:setTransport(isTransport,noEventSend)
	SetTransportEvent.sendEvent(self, isTransport, noEventSend);
	-- Play transport animation --
	if isTransport then
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, -1, nil, true);
			self.Transport = true;
		end;
	else
		if self.TransportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransportAnimation, 1, nil, true);
			self.Transport = false;
		end;
	end;
end;



function KroneBigPack:moveBalesOut(dt)
	local done = false;
	local drive = true;
	for i=1, table.getn(self.bales) do
		local bale = self.bales[i];
		if bale ~= nil then
			local sendTime = dt/200;
			self:moveBale(i, sendTime, noEventSend)
		else
			drive = false;
		end;
	end;
	if table.getn(self.bales) == 0 then
		done = true;
		drive = false;
	end;
	if self.attacherVehicle ~= nil then
		local kmh = self.attacherVehicle.lastSpeed*self.attacherVehicle.speedDisplayScale*3600;
		if drive then
			if kmh < 10 then
				self.attacherVehicle.motor:setSpeedLevel(1, true);
			else
				self.attacherVehicle.motor:setSpeedLevel(0, false);
			end;
		else
			self.attacherVehicle.motor:setSpeedLevel(0, false);
		end;
	end;
	self.moveBalesOutside = done;
end;