--
-- pillar
-- Specialization for pillar
--
-- @author  Geri-G
-- @date  06/07/2010
--

pillar = {};

function pillar.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function pillar:load(xmlFile)
	self.PlayerInRange = pillar.PlayerInRange;
	self.pillar = {};
	self.attacher = {};
	self.anlegeKl = {};
	self.anlegeKl[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.anlegeklotz#index1"));
	self.anlegeKl[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.anlegeklotz#index2"));
	
	self.pillar.nodeRot = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pillar#indexRot"));
	self.pillar.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pillar#index"));
	self.pillar.minTrans = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pillar#minTrans"),"0 0 0"))};
	self.pillar.maxTrans = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pillar#maxTrans"),"0 0 0"))};
	self.pillar.MoveTime = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.pillar#MoveTime"),5)*1000;	
	self.pillar.colli = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.pillar#Colli"),1);	
	
	self.attacher.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.attacher#Rot1"));
	self.attacher.node2 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.attacher#Rot2"));
	self.attacher.minRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.attacher#minRot"),"0 0 0"))};
	for k,v in pairs(self.attacher.minRot) do
		self.attacher.minRot[k] = Utils.degToRad(v);
	end;
	self.attacher.maxRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.attacher#maxRot"),"0 0 0"))};
	for k,v in pairs(self.attacher.maxRot) do
		self.attacher.maxRot[k] = Utils.degToRad(v);
	end;
	self.attacher.MoveTime = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.attacher#MoveTime"),5)*1000;
	
	setVisibility(self.anlegeKl[1], true);
	setVisibility(self.anlegeKl[2], false);
	
	self.doJointSearch = false;
	self.vehicleJoint = nil;
	self.Move = false;
end;

function pillar:delete()
end;

function pillar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pillar:keyEvent(unicode, sym, modifier, isDown)
end;

function pillar:update(dt)
	if self:getIsActive() then
		if self.doJointSearch then	
			for i,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;	
					break;
				end;
			end;
			self.doJointSearch = false;
		end;
	end;
	self.Move = false;
	if not self:getIsActive() then
		local playerInRange = self:PlayerInRange();
		if playerInRange == true then
			g_currentMission:addHelpButtonText(g_i18n:getText("KroneVarioPack1500_up"), InputBinding.footUp);
			g_currentMission:addHelpButtonText(g_i18n:getText("KroneVarioPack1500_down"), InputBinding.footDown);
			g_currentMission:addHelpButtonText(g_i18n:getText("KroneVarioPack1500_up2"), InputBinding.deichselUp);
			g_currentMission:addHelpButtonText(g_i18n:getText("KroneVarioPack1500_down2"), InputBinding.deichselDown);
			local up = nil;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POS) then
				up = true;
			end;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEG) then
				up = false;
			end;
			if up ~= nil then
				local trans = {getTranslation(self.pillar.node)};				
				local newTrans = Utils.getMovedLimitedValues(trans, self.pillar.minTrans, self.pillar.maxTrans, 3, self.pillar.MoveTime , dt, up);
				setTranslation(self.pillar.node,unpack(newTrans));
				
				if math.abs(newTrans[2]-trans[2]) > 0.001 then
					setJointFrame(self.componentJoints[self.pillar.colli].jointIndex, 0,self.componentJoints[self.pillar.colli].jointNode);
					if up == true then
						rotate(self.pillar.nodeRot,0,0.1,0);
					else
						rotate(self.pillar.nodeRot,0,-0.1,0);
					end;
				end;
			end;			
			
			local up2 = nil;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POS) then
				up2 = true;
			end;
			if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEG) then
				up2 = false;
			end;
			if up2 ~= nil then
				self.Move = true;
				local rot = {getRotation(self.attacher.node)};				
				local newRot = Utils.getMovedLimitedValues(rot, self.attacher.minRot, self.attacher.maxRot, 3, self.attacher.MoveTime , dt, up2);
				setRotation(self.attacher.node,unpack(newRot));
				setRotation(self.attacher.node2,-newRot[1],-newRot[2],-newRot[3]);
				
				if self.vehicleJoint ~= nil then
					setJointFrame(self.vehicleJoint.jointIndex, 1, self.attacherJoint.node);
				end;
			end;
		end;
	end;
end;

function pillar:draw()
end;

function pillar:PlayerInRange()
	if g_currentMission.currentVehicle ~= nil then
		return false;
	else
		local x1,y1,z1 = getWorldTranslation(self.pillar.nodeRot);
		local x2,y2,z2 = getWorldTranslation(Player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance <= 1 then
			return true;
		else
			return false;
		end;	
	end;
end;
--

function pillar:onAttach(attacherVehicle)
	setVisibility(self.anlegeKl[1], true);
	setVisibility(self.anlegeKl[2], false);
	self.doJointSearch = true;
end;

function pillar:onDetach()
	setVisibility(self.anlegeKl[2], true);
	setVisibility(self.anlegeKl[1], false);
	self.vehicleJoint = nil;
end;
function pillar:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.BaleCount = Utils.getNoNil(getXMLInt(xmlFile,key.."#BaleCount"),0);
		local rot = getXMLString(xmlFile,key.."#RotD");
		if rot ~= nil then
			rot = {Utils.getVectorFromString(rot)};
			setRotation(self.attacher.node,unpack(rot));
			setRotation(self.attacher.node2,-rot[1],-rot[2],-rot[3]);
		end;
		local trans = getXMLString(xmlFile,key.."#transS");
		if trans ~= nil then
			trans = {Utils.getVectorFromString(trans)};
			setTranslation(self.pillar.node,unpack(trans));
			setJointFrame(self.componentJoints[self.pillar.colli].jointIndex, 0,self.componentJoints[self.pillar.colli].jointNode);
		end;
	end;
	self:loadBale(xmlFile, key, resetVehicles);
    return BaseMission.VEHICLE_LOAD_OK;
end;

function pillar:getSaveAttributesAndNodes(nodeIdent)
	local x,y,z = getRotation(self.attacher.node);
	local x1,y1,z1 = getTranslation(self.pillar.node);
    local attributes = ' RotD="'.. string.format("%0.2f %0.2f %0.2f",x,y,z)..'" transS="'.. string.format("%0.2f %0.2f %0.2f",x1,y1,z1)..'" BaleCount="'..tonumber(self.BaleCount)..'"';
    local node = nil;
    return attributes, node;
end;