﻿--
-- self
-- for all self
--
-- @author by landwirtschaftssimulator-2009.de
-- @date  08/06/09
--
-- Copyright (C) 

F930TMS = {};

function F930TMS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function F930TMS:load(xmlFile)

    self.twinVL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVL#index"));
    self.twinVR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVR#index"));
    self.twinHL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHL#index"));
    self.twinHR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHR#index"));	
      
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	local radioSound = getXMLString(xmlFile, "vehicle.radioSound#file");
    if  radioSound ~= nil and  radioSound ~= "" then
        radioSound = Utils.getFilename( radioSound, self.baseDirectory); 
        self.radioSound = createSample(" radioSound");
        self.radioSoundPlaying = false;
        loadSample(self. radioSound, radioSound, false);
        self.radioSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.radioSound#volume"),1);
    end;
	local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
	brakeSound = Utils.getFilename(brakeSound, self.baseDirectory);
        self.brakeSound = createSample("brakeSound");
        loadSample(self.brakeSound, brakeSound, false);
    end;
	
	local handbrakeSound = getXMLString(xmlFile, "vehicle.handbrakeSound#file");
    if handbrakeSound ~= nil and handbrakeSound ~= "" then
	handbrakeSound = Utils.getFilename(handbrakeSound, self.baseDirectory);
        self.handbrakeSound = createSample("handbrakeSound");
        loadSample(self.handbrakeSound, handbrakeSound, false);
    end;
	
	local compressorSound = getXMLString(xmlFile, "vehicle.compressorSound#file");
    if compressorSound ~= nil and compressorSound ~= "" then
	compressorSound = Utils.getFilename(compressorSound, self.baseDirectory);
        self.compressorSound = createSample("compressorSound");
        loadSample(self.compressorSound, compressorSound, false);
    end;
	
	local compressorStopSound = getXMLString(xmlFile, "vehicle.compressorStopSound#file");
    if compressorStopSound ~= nil and compressorStopSound ~= "" then
	compressorStopSound = Utils.getFilename(compressorStopSound, self.baseDirectory);
        self.compressorStopSound = createSample("compressorStopSound");
        loadSample(self.compressorStopSound, compressorStopSound, false);
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontlights = {};
    for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;	
   
	local rotationPartNodeWischer = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischer#index"));
    if rotationPartNodeWischer ~= nil then
        self.rotationPartWischer = {};
        self.rotationPartWischer.node = rotationPartNodeWischer;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#minRot"));
        self.rotationPartWischer.minRot = {};
        self.rotationPartWischer.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischer#maxRot"));
        self.rotationPartWischer.maxRot = {};
        self.rotationPartWischer.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischer.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischer.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischer.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#rotTime"), 2)*1000;
        self.rotationPartWischer.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischer#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWischerblatt = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#index"));
    if rotationPartNodeWischerblatt ~= nil then
        self.rotationPartWischerblatt = {};
        self.rotationPartWischerblatt.node = rotationPartNodeWischerblatt;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#minRot"));
        self.rotationPartWischerblatt.minRot = {};
        self.rotationPartWischerblatt.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#maxRot"));
        self.rotationPartWischerblatt.maxRot = {};
        self.rotationPartWischerblatt.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerblatt.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerblatt.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischerblatt.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#rotTime"), 2)*1000;
        self.rotationPartWischerblatt.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerblatt#touchRotLimit"), 10));
    end;
	local rotationPartNodeDruck = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDruck#index"));
    if rotationPartNodeDruck ~= nil then
        self.rotationPartDruck = {};
        self.rotationPartDruck.node = rotationPartNodeDruck;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruck#minRot"));
        self.rotationPartDruck.minRot = {};
        self.rotationPartDruck.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruck.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruck.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruck#maxRot"));
        self.rotationPartDruck.maxRot = {};
        self.rotationPartDruck.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruck.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruck.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDruck.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruck#rotTime"), 2)*1000;
        self.rotationPartDruck.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruck#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDruckLight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDruckLight#index"));
    if rotationPartNodeDruckLight ~= nil then
        self.rotationPartDruckLight = {};
        self.rotationPartDruckLight.node = rotationPartNodeDruckLight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#minRot"));
        self.rotationPartDruckLight.minRot = {};
        self.rotationPartDruckLight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruckLight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruckLight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#maxRot"));
        self.rotationPartDruckLight.maxRot = {};
        self.rotationPartDruckLight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruckLight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruckLight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDruckLight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#rotTime"), 2)*1000;
        self.rotationPartDruckLight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#touchRotLimit"), 10));
    end;
	
	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	
	 local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	
	local rotationNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation11#index"));
        self.rotation11 = {};
          self.rotation11.node = rotationNode11;

	local rotationNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation12#index"));
        self.rotation12 = {};
          self.rotation12.node = rotationNode12;
		  
   local rotationNode13 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation13#index"));
        self.bottomArm2 = {};
          self.bottomArm2.node = rotationNode13;
		  
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    hornSoundFile = Utils.getFilename("sounds/horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("HupenSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
	
    self.exhaustParticleLow = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleLow, "vehicle.exhaustParticleLow", self.rootNode, false, nil, self.baseDirectory);
    self.exhaustParticleHigh = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleHigh, "vehicle.exhaustParticleHigh", self.rootNode, false, nil, self.baseDirectory);
	
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
	--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	
	self.brakeOn = false;
	self.lightsbrake = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.brake#index"));
	self.druckl_green = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.druckl_green#index"));
    self.druckl_red = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.druckl_red#index"));
	self.lightsfuelwarn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.fuelwarn#index"));
	self.lightshandbrake = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.handbrake#index"));
	self.lightsradio = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.radio#index"));
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	self.handbrakeSoundRunning = false;
    self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
    self.motorBrakeForce = self.motor.brakeForce;
	self.druckLevel = 6500;
	self.farlightsActive = false;
    self.frontlightsActive = false;
	self.worklightsActive = false;
    self.hornPlaying = false;
    self.zuendungKey = true;
	self.allowedZuendung = true; 
    self.compressorStart = false;
	self.brakeSoundRunning = true;
	self.revLimit = 100;
    self.delayWischer1 = 0;
	self.delayWischer2 = 0;
	self.compressor = false;

end;

function F930TMS:keyEvent(unicode, sym, modifier, isDown)

--[[Zwillingsbereifung start]]--	
	if isDown and sym == Input.KEY_k then
		self.dualwheels = not self.dualwheels;
		setVisibility(self.twinVL, self.dualwheels);
		setVisibility(self.twinVR, self.dualwheels);
		setVisibility(self.twinHL, self.dualwheels);
		setVisibility(self.twinHR, self.dualwheels);		
	end;
--[[Zwillingsbereifung ende]]--

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
	if isDown and sym == Input.KEY_space then
		self.handbrake = not self.handbrake;
	end;
    if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;
    if isDown and sym == Input.KEY_7 then
	    self.frontlightsActive = not self.frontlightsActive;
	    self.farlightsActive = false;
		self.worklightsActive = false;
	end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.worklightsActive = false;
	end;
    if isDown and sym == Input.KEY_x then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 
     if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	end; 
	 if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------

end;


function F930TMS:update(dt)
    if self.isEntered then
	
	    if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
    
	    if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		
	     if self.rotation11.node ~= nil and self.bottomArm2.node ~= nil then
	    rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
        setRotation(self.rotation11.node, rBBArmX*1.5-0.35, 0, 0);
        end;
	    if self.rotation12.node ~= nil and self.bottomArm2.node ~= nil then
        setRotation(self.rotation12.node, 0.278-rBBArmX*1.4, 0, 0);
        end;
	
	    if self.isEntered then
        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
	    
		if self.isEntered then
		  if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
		for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
		end;
	end;
	end;
	end;
	
		if self.isEntered then
        if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    if not self.farlightsActive then
		for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
		end;
	end;
 end;
 
        if self.isEntered then
          if self.frontlightsActive then
            setVisibility(self.frontlights.outs, false);
          else
            setVisibility(self.frontlights.outs, true);
          end;
        end;
		
          if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.hasEvent(InputBinding.RADIO) then
             if not self.radioSoundPlaying then 
               playSample(self. radioSound, 0, self. radioSoundVolume, 0); 
               self.radioSoundPlaying = true; 
			   setVisibility(self.lightsradio, true);
           else 
                stopSample(self. radioSound); 
                self.radioSoundPlaying = false; 
				setVisibility(self.lightsradio, false);
             end;  
          end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;
		  
		if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.HUPE) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
    

   if not self.isAITractorActivated then
       
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.ZUENDUNG) then
		        self.zuendungKey = not self.zuendungKey;
			    self.allowedZuendung = true;
	        end;
	    end;
		
	    
	    if not self.allowedZuendung and  not self.zuendungKey then
            self.isMotorStarted = true;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	   
	    if not self.zuendungKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    
	    if self.allowedZuendung then
	        if  not self.zuendungKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedZuendung = true;	
		        setVisibility(self.druckl_red, false);
		        setVisibility(self.druckl_green, false);	
				self.compressor = false ;
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.zuendungKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedZuendung = true;
		        setVisibility(self.druckl_red, true);
		        setVisibility(self.druckl_green, true);	
				self.compressor = true ;
       	    end;
	    end;
   
    elseif not self.zuendungKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;


end;
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	
	
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------
  if self.compressor or self.isHired then 
      if self.druckLevel >= -1 and self.druckLevel <= 6000 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSound, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorStopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSound, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorStopSoundRunning then
				playSample(self.compressorStopSound, 1, 1, 0);
				self.compressorStopSoundRunning = true;
			end;

		end;
		if self.compressor then
		if self.druckLevel <= 6100 then
			self.druckWarning = true;
	       setVisibility(self.druckl_red, true);
		else
			self.druckWarning = false;
			self.druckWarnlightsActive = false;
	       setVisibility(self.druckl_red, false);			
		end;
		if self.druckLevel >= 6000 then
			self.drucklightsActive = true;
	       setVisibility(self.druckl_green, true);			
		else
			self.drucklightsActive = false;
	       setVisibility(self.druckl_green, false);	
		end;
     end;
	 
	 
	 local maxDruck = 10000;
	if self.rotationPartDruck ~= nil then
		local x, y, z = getRotation(self.rotationPartDruck.node);
		y = ((self.rotationPartDruck.maxRot[2] - self.rotationPartDruck.minRot[2]) / maxDruck) * self.druckLevel + self.rotationPartDruck.minRot[2];
		setRotation(self.rotationPartDruck.node, x, y ,z);
	end;
	
	local maxDruckLight = 10000;
	if self.rotationPartDruckLight ~= nil then
		local x, y, z = getRotation(self.rotationPartDruckLight.node);
		y = ((self.rotationPartDruckLight.maxRot[2] - self.rotationPartDruckLight.minRot[2]) / maxDruckLight) * self.druckLevel + self.rotationPartDruckLight.minRot[2];
		setRotation(self.rotationPartDruckLight.node, x, y ,z);
	end;
	
       
		local fuelWarn = 75;
		if self.fuelFillLevel < fuelWarn then
	       setVisibility(self.lightsfuelwarn, true);
		else
	       setVisibility(self.lightsfuelwarn, false);
		end;
		
		if self.isEntered then
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then
			setVisibility(self.lightsbrake, true);
			if self.druckLevel >= 5500 then
				self.motor.brakeForce = self.motorBrakeForce;
				if not self.brakeSoundRunning then
					playSample(self.brakeSound, 1, 1, 0);
					self.brakeSoundRunning = true;
				end;
			end;
			if not self.braking then
				if self.druckLevel > 0 then

			self.druckLevel = self.druckLevel -350;
			
	

    				

					end;

				self.braking = true;
			end;
		else
			if not self.handbrake then
				self.motor.brakeForce = self.motor.brakeForce*0;
			end;
		        setVisibility(self.lightsbrake, false);
			self.braking = false;
			if self.druckLevel >= 5500 then
		
					self.brakeSoundRunning = false;
			end;
		end;


            if g_currentMission.attachableInMountRange ~= nil then
                self.motor.brakeForce = self.brakeForce;
            end;

	
		if self.handbrake then
			brakeTorque = 10000;
			self.motor.brakeForce = brakeTorque;
		    self.braking = true;
		setVisibility(self.lightshandbrake, self.handbrake);


			if not self.handbrakeSoundRunning then
				playSample(self.handbrakeSound, 1, 1, 0);
				self.handbrakeSoundRunning = true;
			end;
		else

		setVisibility(self.lightshandbrake, false);
			self.handbrakeSoundRunning = false;
		end;
	end;
 end;
 
 if self.isEntered then
	
		if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			self.rainWarning = false;
		else
			self.rainWarning = true;
		end;
		
		if self.rainWarning and self.isMotorStarted then
			if self.delayWischer1 >= 0 then
				self.delayWischer1 = self.delayWischer1 -dt;
			end;
			if self.delayWischer2 >= 0 then
				self.delayWischer2 = self.delayWischer2 -dt;
			end;
			if not self.rotationMaxWischer then
				if self.delayWischer1 < 0 then
					self.delayWischer2 = 1000;
					self.rotationMaxWischer = true;
					self.rotationMaxWischerblatt = true;
				end;
			end;
			if self.rotationMaxWischer then
				if self.delayWischer2 < 0 then
					self.delayWischer1 = 1000;
					self.rotationMaxWischer = false;
					self.rotationMaxWischerblatt = false;
				end;
			end;
		else
			self.rotationMaxWischer = false;
			self.rotationMaxWischerblatt = false;
		end;
	end;
	
	  if self.rotationPartWischer ~= nil then
		local x, y, z = getRotation(self.rotationPartWischer.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischer.maxRot, self.rotationPartWischer.minRot, 3, self.rotationPartWischer.rotTime, dt, not self.rotationMaxWischer);
		setRotation(self.rotationPartWischer.node, unpack(newRot));
	end;  
    if self.rotationPartWischerblatt ~= nil then
		local x, y, z = getRotation(self.rotationPartWischerblatt.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischerblatt.maxRot, self.rotationPartWischerblatt.minRot, 3, self.rotationPartWischerblatt.rotTime, dt, not self.rotationMaxWischerblatt);
		setRotation(self.rotationPartWischerblatt.node, unpack(newRot));
	end;
	

    if self.isMotorStarted then
		if self.motor.lastMotorRpm > 200 and self.motor.lastMotorRpm < 1200 then
			Utils.setEmittingState(self.exhaustParticleLow, true);
        	Utils.setEmittingState(self.exhaustParticleHigh, false);
		else
			Utils.setEmittingState(self.exhaustParticleLow, false);
        	Utils.setEmittingState(self.exhaustParticleHigh, true);			
		end;
		if self.motor.lastMotorRpm > 1300 then
			Utils.setEmittingState(self.exhaustParticleLow, false);
        	Utils.setEmittingState(self.exhaustParticleHigh, true); 		
		else
			Utils.setEmittingState(self.exhaustParticleLow, true);
        	Utils.setEmittingState(self.exhaustParticleHigh, false); 
		end;
    else 
        Utils.setEmittingState(self.exhaustParticleLow, false);
        Utils.setEmittingState(self.exhaustParticleHigh, false); 
    end;
	
	
end;

function F930TMS:draw()

    if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "Taste X: Info Einschalten");
		else
			renderText(0.8335, 0.17, 0.02, "Taste X: Info Abschalten");
		end;
		if self.helpPanel then
			renderText(0.72, 0.82, 0.025, "- www.ls-mod.ru -");
			renderText(0.72, 0.80, 0.02, 		"Taste KP1 - Blinker links");
			renderText(0.72, 0.78, 0.02, 		"Taste KP2 - Warnblinker");		
			renderText(0.72, 0.76, 0.02, 		"Taste KP3 - Blinker rechts");
			renderText(0.72, 0.74, 0.02, 		"Taste KP4: Tur links auf/zu");
			--renderText(0.72, 0.74, 0.02, 		"Taste KP5: Kabine auf/zu");			
			renderText(0.72, 0.72, 0.02,		"Taste KP6: Tur rechts auf/zu");
			--renderText(0.72, 0.70, 0.02, 		"Taste KP Enter: Motor an/aus");	
			renderText(0.72, 0.70, 0.02, 		"Taste 0: Hupen");
            --renderText(0.72, 0.66, 0.02, 		"Taste 6: Rundumleuchte ein/aus");
			--renderText(0.72, 0.64, 0.02, 		"Taste 7 - Arbeitlicht vorne an/aus");
			--renderText(0.72, 0.62, 0.02, 		"Taste 8 - Fernlicht an/aus");
			--renderText(0.72, 0.62, 0.02, 		"Taste R: Radio an/aus");
			--renderText(0.72, 0.60, 0.02, 		"Taste L: Arbeitslicht hinte an/aus");
			--renderText(0.72, 0.58, 0.02, 		"Taste K: Zwillingsreifen an/aus");
		end;
	end;
	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if (self.movingDirection*self.lastSpeed*(-inputAxisY))  then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "BITTE HANDBREMSE LOSEN!");
		end;
		renderText(0.875, 0.19, 0.015, "(!) Handbremse Aktiv");	
	end;
    if not self.isMotorStarted and not self.automaticStart then	
        --g_currentMission:addHelpButtonText(g_i18n:getText("Zendung"), InputBinding.ZUENDUNG);
	end;
	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Taste Insert/Delete:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Taste Insert/Delete:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

function F930TMS:onEnter()
    self.compressorStopSoundRunning = true;
	Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function F930TMS:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    self.worklightsActive = false;
	
	if self.radioSound ~= nil then
        stopSample(self.radioSound);
    end;
	
	if not self.deactivateOnLeave then
	    self.allowedZuendung = false;
	    self.zuendungKey = true; 
    else
	    self.allowedZuendung = true;
	    self.zuendungKey = true;
	end;
	 Utils.setEmittingState(self.exhaustParticleLow, false);
	 stopSample(self.compressorSound);
     self.compressorSoundRunning = false;
end;

function F930TMS:delete()
    Utils.deleteParticleSystem(self.exhaustParticleLow);
    Utils.deleteParticleSystem(self.exhaustParticleHigh);
    delete(self.hornSoundId);
    delete(self.radioSound);
    stopSample(self.compressorSound);
end;


function F930TMS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
