--
-- workLights
-- Specialization for workLights.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

workLights = {};

function workLights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function workLights:load(xmlFile)
--[[REAR worklights start]]--
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.worklights.worklight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsActive = false;
--[[REAR worklights end]]--

--[[FRONT worklights start]]--
	local numFrontLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontLights = {};
    for i=1, numFrontLights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight%d", i);
        self.frontLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontLights[i], false);
    end;
	self.frontLightsActive = false;
--[[FRONT worklights end]]--

--[[DRIVElights start]]--
	local numFarLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farLights = {};
    for i=1, numFarLights do
        local farlightnamei = string.format("vehicle.farlights.farlight%d", i);
        self.farLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farLights[i], false);
    end;
	self.farLightsActive = false;
--[[DRIVElights end]]--
end;

function workLights:delete()
--[[REAR worklights start]]--
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
--[[REAR worklights end]]--

--[[FRONT worklights start]]--
	for k, frontlight in pairs(self.frontLights) do
		setVisibility(frontlight, false);
	end;
	self.frontLightsActive = false;
--[[FRONT worklights end]]--

--[[DRIVElights start]]--
	for k, farlight in pairs(self.farLights) do
		setVisibility(farlight, false);
	end;
	self.farLightsActive = false;
--[[DRIVElights end]]--
end;

function workLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function workLights:keyEvent(unicode, sym, modifier, isDown)
end;

function workLights:update(dt)
--[[REAR worklights start]]--
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.workLightsActive = not self.workLightsActive;
		end;
	
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsActive);
		end;
	end;
--[[REAR worklights end]]--

--[[FRONT worklights start]]--
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.FRONTLIGHTS) then
			self.frontLightsActive = not self.frontLightsActive;
		end;
	
		for k, frontlight in pairs(self.frontLights) do
			setVisibility(frontlight, self.frontLightsActive);
		end;
	end;
--[[FRONT worklights end]]--

--[[DRIVElights start]]--
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.DRIVELIGHTS) then
			self.farLightsActive = not self.farLightsActive;
		end;
	
		for k, farlight in pairs(self.farLights) do
			setVisibility(farlight, self.farLightsActive);
		end;
	end;
--[[DRIVElights end]]--
end;

function workLights:onLeave()
--[[REAR worklights start]]--
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
--[[REAR worklights end]]--

--[[FRONT worklights start]]--
	for k, frontlight in pairs(self.frontLights) do
		setVisibility(frontlight, false);
	end;
	self.frontLightsActive = false;
--[[FRONT worklights end]]--

--[[DRIVElights start]]--
	for k, farlight in pairs(self.farLights) do
		setVisibility(farlight, false);
	end;
	self.farLightsActive = false;
--[[DRIVElights end]]--
end;

function workLights:draw()
end;

