-- Kirovets
-- Edit by Brain


kirovets = {};

function kirovets.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function kirovets:load(xmlFile)
	
    self.controlpath = Utils.getFilename("kirovetshelp.png", self.baseDirectory);
    self.hudPoxX = 0.0154;
    self.hudPoxY = 1-0.4715;
    self.hudWidth = 0.34;
    self.hudHeight = 0.3;
    self.hudOverlay = Overlay:new("hudKIROControl", self.controlpath, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);

    local kirovetsGetSaveAttributesAndNodes = kirovets.getSaveAttributesAndNodes;
    local kirovetsLoadFromAttributesAndNodes = kirovets.loadFromAttributesAndNodes;    
    self.backcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backcamera#index"));
	
	local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 1500);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 2500);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 3500);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	self.DEC = false;
	self.ACC = false;
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
    self.turn1SoundId = createSample("turn1Sound");
    loadSample(self.turn1SoundId, turn1SoundFile, false);

    turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
    self.turn2SoundId = createSample("turn2Sound");
    loadSample(self.turn2SoundId, turn2SoundFile, false);

    self.farLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.farLight#index"));
    self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLight#index"));
    self.brakeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakeLight#index"));
	
    self.turnLL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnLL#index"));
    self.turnLR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnLR#index"));
	
    self.farLightActive = false;
    self.brakeLightActive = false;
    self.workLightActive = false;
	
    self.lighton = false;
	
    self.indexbActive = false;
    self.indexjActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.wiper1Active = false;	
	self.wiper2Active = false;	
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayWischer1 = 0;
    self.delayWischer2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;
	
    self.help = false;
    if self.uzemora == nil then
		self.uzemora = 0;
    end;

    self.exhaust = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaust#index"));
    self.exhaustParticleSystemextra = {};
    local psName = "vehicle.exhaustParticleSystemextra";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystemextra, psName, self.exhaust, false, nil, self.baseDirectory)

    self.exhaustParticleSystem = {};
    local psName = "vehicle.exhaustParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystem, psName, self.exhaust, false, nil, self.baseDirectory)

    self.exhaustParticleSystemextra1 = {};
    local psName = "vehicle.exhaustParticleSystemextra1";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystemextra1, psName, self.exhaust, false, nil, self.baseDirectory)

	local armHydrNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armHydr#index"));
    if armHydrNode ~= nil then
        self.armHydr = {};
        self.armHydr.node = armHydrNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#minRot"));
        self.armHydr.minRot = {};
        self.armHydr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#maxRot"));
        self.armHydr.maxRot = {};
        self.armHydr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armHydr#nullRot"));
        self.armHydr.nullRot = {};
        self.armHydr.nullRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armHydr.nullRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armHydr.nullRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armHydr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armHydr#rotTime"), 2)*1000;
        self.armHydr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armHydr#touchRotLimit"), 10));
    end;
	
    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;

    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local cylinder1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder1#index"));
    if cylinder1Node ~= nil then
        self.cylinder1 = {};
        self.cylinder1.node = cylinder1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#minRot"));
        self.cylinder1.minRot = {};
        self.cylinder1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#maxRot"));
        self.cylinder1.maxRot = {};
        self.cylinder1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cylinder1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#rotTime"), 2)*1000;
        self.cylinder1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#touchRotLimit"), 10));
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;
	
	local rotBrace2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace2#index"));
    if rotBrace2Node ~= nil then
        self.rotBrace2 = {};
        self.rotBrace2.node = rotBrace2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#minRot"));
        self.rotBrace2.minRot = {};
        self.rotBrace2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#maxRot"));
        self.rotBrace2.maxRot = {};
        self.rotBrace2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#rotTime"), 2)*1000;
        self.rotBrace2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#touchRotLimit"), 10));
    end;

    local braceVertNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.braceVert#index"));
    if braceVertNode ~= nil then
        self.braceVert = {};
        self.braceVert.node = braceVertNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#minTrans"));
        self.braceVert.minTrans = {};
        self.braceVert.minTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.minTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#maxTrans"));
        self.braceVert.maxTrans = {};
        self.braceVert.maxTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.maxTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.maxTrans[3] = Utils.getNoNil(z, 0);
        self.braceVert.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#transTime"), 2)*1000;
        self.braceVert.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#touchTransLimit"), 10);
    end;

    local cylinder2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder2#index"));
    if cylinder2Node ~= nil then
        self.cylinder2 = {};
        self.cylinder2.node = cylinder2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#minTrans"));
        self.cylinder2.minTrans = {};
        self.cylinder2.minTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.minTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#maxTrans"));
        self.cylinder2.maxTrans = {};
        self.cylinder2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.cylinder2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#transTime"), 2)*1000;
        self.cylinder2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#touchTransLimit"), 10);
    end;

    local coverNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cover#index"));
    if coverNode ~= nil then
        self.cover = {};
        self.cover.node = coverNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cover#minRot"));
        self.cover.minRot = {};
        self.cover.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cover.minRot[2] = Utils.degToRad(Utils.getNoNil(y, -90));
        self.cover.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cover#maxRot"));
        self.cover.maxRot = {};
        self.cover.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cover.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, -90));
        self.cover.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cover.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cover#rotTime"), 2)*1000;
        self.cover.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.cover#touchRotLimit"), 10));
    end;

    local doorLNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.doorL#index"));
    if doorLNode ~= nil then
        self.doorL = {};
        self.doorL.node = doorLNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorL#minRot"));
        self.doorL.minRot = {};
        self.doorL.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.doorL.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.doorL.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorL#maxRot"));
        self.doorL.maxRot = {};
        self.doorL.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.doorL.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.doorL.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.doorL.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.doorL#rotTime"), 2)*1000;
        self.doorL.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.doorL#touchRotLimit"), 10));
    end;

    local doorRNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.doorR#index"));
    if doorRNode ~= nil then
        self.doorR = {};
        self.doorR.node = doorRNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorR#minRot"));
        self.doorR.minRot = {};
        self.doorR.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.doorR.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.doorR.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorR#maxRot"));
        self.doorR.maxRot = {};
        self.doorR.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.doorR.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.doorR.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.doorR.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.doorR#rotTime"), 2)*1000;
        self.doorR.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.doorR#touchRotLimit"), 10));
    end;

    local wiper1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wiper1#index"));
    if wiper1Node ~= nil then
        self.wiper1 = {};
        self.wiper1.node = wiper1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#minRot"));
        self.wiper1.minRot = {};
        self.wiper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#maxRot"));
        self.wiper1.maxRot = {};
        self.wiper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#rotTime"), 2)*1000;
        self.wiper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#touchRotLimit"), 10));
    end;
	
	local wiper2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wiper2#index"));
    if wiper2Node ~= nil then
        self.wiper2 = {};
        self.wiper2.node = wiper2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#minRot"));
        self.wiper2.minRot = {};
        self.wiper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#maxRot"));
        self.wiper2.maxRot = {};
        self.wiper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#rotTime"), 2)*1000;
        self.wiper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#touchRotLimit"), 10));
    end;
	self.crankshaftNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.crankshaft#index"));
end;

function kirovets:delete()
    Utils.deleteParticleSystem(self.exhaustParticleSystemextra1);
    Utils.deleteParticleSystem(self.exhaustParticleSystemextra);
    Utils.deleteParticleSystem(self.exhaustParticleSystem);
end;

function kirovets:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kirovets:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.kiroHelp then 
		self.help = not self.help;
    end;

	if isDown and sym == self.keys.kiroAddLight then
	   if self.lighton then
			self.farLightActive = not self.farLightActive;
	   end;
	end;
	if isDown and sym == self.keys.kiroWorkLight then
		self.workLightActive = not self.workLightActive;
	end;
	
	if isDown and sym == self.keys.kiroDoorL then
		self.doorLMax = not self.doorLMax;
	end;
	if isDown and sym == self.keys.kiroDoorR then
		self.doorRMax = not self.doorRMax;
	end;
	if isDown and sym == self.keys.kiroBrushWindows then
		self.wiper1Active = not self.wiper1Active;
		self.wiper2Active = not self.wiper2Active;
	end;

	if sym == self.keys.kirohydUp then
		self.armDownMax = isDown;
		self.armUpMax = isDown;
		self.cylinder1Max = isDown;
		self.rotBraceMax = isDown;
		self.rotBrace2Max = isDown;
		self.braceVertMax = isDown;
		self.cylinder2Max = isDown;
		self.armHydrMax = isDown;
	end;
	if sym == self.keys.kirohydDown then
		self.armDownMin = isDown;
		self.armUpMin = isDown;
		self.cylinder1Min = isDown;
		self.rotBraceMin = isDown;
		self.rotBrace2Min = isDown;
		self.braceVertMin = isDown;
		self.cylinder2Min = isDown;
		self.armHydrMin = isDown;
	end;
	
	if sym == self.keys.ACCELERATE then 
		self.ACC = isDown;
    end;
	if sym == self.keys.DECELERATE then 
		self.DEC = isDown;
    end;

	if isDown and sym == self.keys.kiroTurnLeft then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.indexjActive = false;
	end;
	if isDown and sym == self.keys.kiroTurnRight then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.indexbActive = false;
	end;
	if isDown and sym == self.keys.kiroTurnBoth then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.indexjActive = false;
		self.indexbActive = false;
	end;
end;

function kirovets:update(dt)
	if self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if self.ACC then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif self.DEC then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
		else
            if self.ACC then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif self.DEC then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;

    if self.motor.lastMotorRpm > 750 and self.isEntered then

		if self.cover ~= nil then
        	local x, y, z = getRotation(self.cover.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.cover.maxRot, self.cover.minRot, 3, self.cover.rotTime, dt, self.isEntered);
        	setRotation(self.cover.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra, true)
		if self.motor.lastMotorRpm > 1300 then
			Utils.setEmittingState(self.exhaustParticleSystemextra1, true)
		else
			Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
		end;						
    elseif self.isEntered then
		self.covermove = math.random(300,1300);
		if self.cover ~= nil then
        	local x, y, z = getRotation(self.cover.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {80,0,0}, {self.covermove*0.001,0,0}, 3, 60000, dt, self.isEntered);
        	setRotation(self.cover.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
        Utils.setEmittingState(self.exhaustParticleSystemextra, false)
        Utils.setEmittingState(self.exhaustParticleSystem, true)
    else
		if self.isAITractorActivated then
			if self.cover ~= nil then
        		local x, y, z = getRotation(self.cover.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.cover.maxRot, self.cover.minRot, 3, self.cover.rotTime, dt, true);
        		setRotation(self.cover.node, unpack(newRot));
    		end;
			Utils.setEmittingState(self.exhaustParticleSystemextra, true)
		else
			if self.cover ~= nil then
        		local x, y, z = getRotation(self.cover.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.cover.maxRot, self.cover.minRot, 3, self.cover.rotTime, dt, false);
        		setRotation(self.cover.node, unpack(newRot));
    		end;
		end;
    end;
	
    if self.isEntered then

		if self.wiper1Active then
			if self.delayWischer1 >= 0 then
				self.delayWischer1 = self.delayWischer1 -dt;
			end;
			if self.delayWischer2 >= 0 then
				self.delayWischer2 = self.delayWischer2 -dt;
			end;
			if not self.wiper1Max then
				if self.delayWischer1 < 0 then
					self.delayWischer2 = 1000;
					self.wiper1Max = true;
					self.wiper2Max = true;
				end;
			end;
			if self.wiper1Max then
				if self.delayWischer2 < 0 then
					self.delayWischer1 = 1000;
					self.wiper1Max = false;
					self.wiper2Max = false;
				end;
			end;
		else
			self.wiper1Max = false;
			self.wiper2Max = false;
		end;

		if self.crankshaftNode ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaftNode, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
		if self.doorL ~= nil then
        	local x, y, z = getRotation(self.doorL.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.doorL.maxRot, self.doorL.minRot, 3, self.doorL.rotTime, dt, not self.doorLMax);
        	setRotation(self.doorL.node, unpack(newRot));
    	end;
		if self.doorR ~= nil then
        	local x, y, z = getRotation(self.doorR.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.doorR.maxRot, self.doorR.minRot, 3, self.doorR.rotTime, dt, not self.doorRMax);
        	setRotation(self.doorR.node, unpack(newRot));
    	end;

		if self.wiper1 ~= nil then
        	local x, y, z = getRotation(self.wiper1.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wiper1.maxRot, self.wiper1.minRot, 3, self.wiper1.rotTime, dt, not self.wiper1Max);
        	setRotation(self.wiper1.node, unpack(newRot));
    	end;
		
		if self.wiper2 ~= nil then
        	local x, y, z = getRotation(self.wiper2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wiper2.maxRot, self.wiper2.minRot, 3, self.wiper2.rotTime, dt, not self.wiper2Max);
        	setRotation(self.wiper2.node, unpack(newRot));
    	end;

		local doRotate = self.armDownMax or self.armDownMin 
		if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
		end;

		if  self.armHydr ~= nil and not self.armHydrMax and not self.armHydrMin  then
			setRotation(self.armHydr.node, 0, 0, 0);
		end;
		
		local doRotate = self.armHydrMax or self.armHydrMin 
		if self.armHydr ~= nil and doRotate then
        	local x, y, z = getRotation(self.armHydr.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armHydr.maxRot, self.armHydr.minRot, 3, self.armHydr.rotTime, dt, not self.armHydrMax);
        	setRotation(self.armHydr.node, unpack(newRot));
		end;

		local doRotate = self.armUpMax or self.armUpMin 
		if self.armUp ~= nil and doRotate then
			local x, y, z = getRotation(self.armUp.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
			setRotation(self.armUp.node, unpack(newRot));
		end;

		local doRotate = self.cylinder1Max or self.cylinder1Min 
		if self.cylinder1 ~= nil and doRotate then
			local x, y, z = getRotation(self.cylinder1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.cylinder1.maxRot, self.cylinder1.minRot, 3, self.cylinder1.rotTime, dt, not self.cylinder1Max);
			setRotation(self.cylinder1.node, unpack(newRot));
		end;

		local doRotate = self.rotBraceMax or self.rotBraceMin 
		if self.rotBrace ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
			setRotation(self.rotBrace.node, unpack(newRot));
		end;

		local doRotate = self.rotBrace2Max or self.rotBrace2Min 
		if self.rotBrace2 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace2.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace2.maxRot, self.rotBrace2.minRot, 3, self.rotBrace2.rotTime, dt, not self.rotBrace2Max);
			setRotation(self.rotBrace2.node, unpack(newRot));
		end;
		
		local doTranslate = self.braceVertMax or self.braceVertMin 
		if self.braceVert ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.braceVert.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.braceVert.maxTrans, self.braceVert.minTrans, 3, self.braceVert.transTime, dt, not self.braceVertMax); 
			setTranslation(self.braceVert.node, unpack(newTrans)); 
		end;

		local doTranslate = self.cylinder2Max or self.cylinder2Min 
		if self.cylinder2 ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.cylinder2.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.cylinder2.maxTrans, self.cylinder2.minTrans, 3, self.cylinder2.transTime, dt, not self.cylinder2Max); 
			setTranslation(self.cylinder2.node, unpack(newTrans)); 
		end;

        if Input.isKeyPressed(self.keys.kiroShowBack) and self.camIndex == 2 then
                setCamera(self.backcamera);
       	end;

        self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
		if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;

		if self.input == 1 and self.movingDirection > 0 then
			self.brakeLightActive = true;
		elseif self.input == -1 and self.movingDirection < 0 then
				self.brakeLightActive = true;
		else
			self.brakeLightActive = false;
		end;

        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
			if not self.farLightActive and not self.lighton then
				self.lighton = true;
			elseif not self.farLightActive and self.lighton then
				self.lighton = false;
			elseif self.farLightActive and self.lighton then
				self.lighton = false;
				self.farLightActive = false;
			end;
		end;

        if self.farLight ~= nil then
            if self.farLightActive then
            	setVisibility(self.farLight, self.farLightActive);
			else
            	setVisibility(self.farLight, self.farLightActive);
			end;
        end;

        if self.brakeLight ~= nil then
            if self.brakeLightActive then
            	setVisibility(self.brakeLight, self.brakeLightActive);
			else
            	setVisibility(self.brakeLight, self.brakeLightActive);
			end;
        end;

        if self.workLight ~= nil then
            if self.workLightActive then
            	setVisibility(self.workLight, self.workLightActive);
			else
            	setVisibility(self.workLight, self.workLightActive);
			end;
        end;

        if self.turnLL ~= nil then
            if self.indexbActive then
            	setVisibility(self.turnLL, self.indexbActive);
			else
            	setVisibility(self.turnLL, self.indexbActive);
			end;
        end;

        if self.turnLR ~= nil then
            if self.indexjActive then
            	setVisibility(self.turnLR, self.indexjActive);
			else
            	setVisibility(self.turnLR, self.indexjActive);
			end;
        end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.indexbActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.indexbActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.indexbActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.indexbActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.indexjActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.indexjActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.indexjActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.indexjActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.indexjActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.indexjActive = true;
					self.indexbActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.indexjActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.indexbActive = false;
					self.indexjActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.indexjActive = false;
				self.indexbActive = false;
			end;
		end;
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.indexjActive = false;
			end;
		end;
		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.indexbActive = false;
			end;
		end;
	end;
end;


function kirovets:draw()
    if self.motor.speedLevel ~= 0 then
        g_currentMission:addExtraPrintText("Button NUM +/-:            "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	else
        g_currentMission:addExtraPrintText("Button NUM +/-:            "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	end;

    if self.isEntered then
		if not self.help then
			setTextColor(1,1,1,1);
			renderText(0.83, 0.15, 0.021, "Key 0: Help on");
		else
			setTextColor(1,1,1,1);
			renderText(0.83, 0.15, 0.021, "Key 0: Help off");
			if self.hudOverlay ~= nil then
				self.hudOverlay:render();
			end;			
		end;
		self.ora = g_currentMission.environment.dayTime/60;
    end;
end;

function kirovets:onEnter()
    self.isEntered = true;
end;

function kirovets:onLeave()

    self.isEntered = false;
    self.farLightActive = false;
    self.brakeLightActive = false;
    self.workLightActive = false;
    self.indexjActive = false;
    self.indexbActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.lighton = false;

    setVisibility(self.farLight, self.farLightActive);
    setVisibility(self.brakeLight, self.brakeLightActive);
    setVisibility(self.workLight, self.workLightActive);
    setVisibility(self.turnLR, self.indexjActive);
    setVisibility(self.turnLL, self.indexbActive);

    Utils.setEmittingState(self.exhaustParticleSystemextra, false)
    Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
    Utils.setEmittingState(self.exhaustParticleSystem, false)

end;

function kirovets:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function kirovets:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local attributes, nodes;
    if kirovetsLoadFromAttributesAndNodes ~= nil then
        local r = kirovetsLoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
        if r ~= BaseMission.VEHICLE_LOAD_OK then
            return r;
        end;
    end;

    if not resetVehicles then
        local uzemora = getXMLFloat(xmlFile, key.."#uzemora");
        if uzemora ~= nil then
            self.uzemora = uzemora;
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function kirovets:getSaveAttributesAndNodes(nodeIdent)
    local attributes, nodes;
    if kirovetsGetSaveAttributesAndNodes ~= nil then
        attributes, nodes = kirovetsGetSaveAttributesAndNodes(self, nodeIdent);
    end;
    local modStr = 'uzemora="'..self.uzemora..'"';
    if attributes == nil then
        attributes = modStr;
    else
        attributes = attributes .. " "..modStr;
    end;
    return attributes, nodes;
end;
