--
-- Specialization 
-- for Pivot Steering: author BoneCrusherXes  
-- and center hydraulics: author Brain 
---
-- formula used for rotation
-- x' = (x-u)*cos(beta) - (y-v)*sin(beta) + u
-- y' = (x-u)*sin(beta) + (y-v)*cos(beta) + v
-- 


KIROsteering = {}

function KIROsteering.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function KIROsteering:load(xmlFile)        
	
	steeringPivotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.steeringPivot#index"));
	st_pivotX,st_pivotY,st_pivotZ = getTranslation(steeringPivotNode);	
	local hydLNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydL#index"));
    if hydLNode ~= nil then
        self.hydL = {};
        self.hydL.node = hydLNode;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydL#nullTrans"));
		self.hydL.nullTrans = {};
		self.hydL.nullTrans[1] = Utils.getNoNil(x, 0);
        self.hydL.nullTrans[2] = Utils.getNoNil(y, 0);
        self.hydL.nullTrans[3] = Utils.getNoNil(z, 0);
		self.hydL.mn = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydL#mn"), 1);
		self.hydL.mn2 = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydL#mn2"), 1);
	end;
	local hydRNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydR#index"));
	if hydRNode ~= nil then
        self.hydR = {};
        self.hydR.node = hydRNode;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydR#nullTrans"));
		self.hydR.nullTrans = {};
		self.hydR.nullTrans[1] = Utils.getNoNil(x, 0);
        self.hydR.nullTrans[2] = Utils.getNoNil(y, 0);
        self.hydR.nullTrans[3] = Utils.getNoNil(z, 0);
		self.hydR.mn = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydR#mn"), 1);
		self.hydR.mn2 = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydR#mn2"), 1);
	end;
	local hydRotLNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydRotL#index"));
    if hydRotLNode ~= nil then
        self.hydRotL = {};
        self.hydRotL.node = hydRotLNode;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydRotL#nullRot"));
        self.hydRotL.nullRot = {};
        self.hydRotL.nullRot[1] = Utils.getNoNil(x, 0);
        self.hydRotL.nullRot[2] = Utils.getNoNil(y, 0);
        self.hydRotL.nullRot[3] = Utils.getNoNil(z, 0);
		self.hydRotL.mn = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydRotL#mn"), 1);
		self.hydRotL.mn2 = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydRotL#mn2"), 1);
    end;
	
	local hydRotRNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydRotR#index"));
    if hydRotRNode ~= nil then
        self.hydRotR = {};
        self.hydRotR.node = hydRotRNode;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hydRotR#nullRot"));
        self.hydRotR.nullRot = {};
        self.hydRotR.nullRot[1] = Utils.getNoNil(x, 0);
        self.hydRotR.nullRot[2] = Utils.getNoNil(y, 0);
        self.hydRotR.nullRot[3] = Utils.getNoNil(z, 0);
		self.hydRotR.mn = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydRotR#mn"), 1);
		self.hydRotR.mn2 = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hydRotR#mn2"), 1);
    end;
	
	local hydRotM2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.topArm#translationNode"));
	if hydRotM2Node ~= nil then
        self.hydRotM2 = {};
        self.hydRotM2.node = hydRotM2Node;
	end;
	local hydRotMNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydRotM#index"));
    if hydRotMNode ~= nil then
        self.hydRotM = {};
        self.hydRotM.node = hydRotMNode;
    end;
end;
      
function KIROsteering:delete()    
end;

function KIROsteering:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function KIROsteering:keyEvent(unicode, sym, modifier, isDown)
end;


function KIROsteering:update(dt)

	local rotx,roty,rotz = getRotation(self.hydRotM2.node);
	setRotation(self.hydRotM.node, rotx,roty,rotz);
  for i=1, table.getn(self.wheels) do
	twx,twy,twz = getTranslation(self.wheels[i].repr);
	wrx,wry,wrz = getRotation(self.wheels[i].repr);
	wNrx,wNry,wNrz = getRotation(self.wheels[i].driveNode);	

    if twz>0 and wry ~= nil then
	local twnewX = (twx-st_pivotX)*math.cos(-wry)-(twz-st_pivotZ)*math.sin(-wry)+st_pivotX-wry;
	local twnewY = st_pivotY;
	local twnewZ = (twx-st_pivotX)*math.sin(-wry)+(twz-st_pivotZ)*math.cos(-wry)+st_pivotZ;
	local twRotNodeY = twy-st_pivotY;
	setTranslation(self.wheels[i].repr, twnewX, twnewY, twnewZ);
	setTranslation(self.wheels[i].driveNode, 0, twRotNodeY, 0);
    end;

    if twz<0 and wry ~= nil then
	local twnewX2 = (twx-st_pivotX)*math.cos(wry)-(twz-st_pivotZ)*math.sin(-wry)+st_pivotX+wry;
	local twnewY2 = st_pivotY;
	local twnewZ2 = (twx-st_pivotX)*math.sin(-wry)+(twz-st_pivotZ)*math.cos(wry)+st_pivotZ;
	local twRotNodeY = twy-st_pivotY;
	setTranslation(self.wheels[i].repr, twnewX2, twnewY2, twnewZ2);
	setTranslation(self.wheels[i].driveNode, 0, twRotNodeY, 0);
    end;
  end;

	if self.hydL ~= nil then
		local xx,yy,zz = getRotation(self.wheels[1].repr);
		local x, y, z = getTranslation(self.hydL.node);
		if yy>0 then
			local zc = self.hydL.nullTrans[3]+yy*self.hydL.mn2;
			setTranslation(self.hydL.node, x, y, zc);
		elseif yy<=0 then
			local zc = self.hydL.nullTrans[3]+yy*self.hydL.mn;
			setTranslation(self.hydL.node, x, y, zc);
		end;
	end;
	
	if self.hydR ~= nil then
		local xx,yy,zz = getRotation(self.wheels[1].repr);
		local x, y, z = getTranslation(self.hydR.node);
		if yy>0 then
			local zc = self.hydR.nullTrans[3]-yy*self.hydR.mn;
			setTranslation(self.hydR.node, x, y, zc);
		elseif yy<=0 then
			local zc = self.hydR.nullTrans[3]-yy*self.hydR.mn2;
			setTranslation(self.hydR.node, x, y, zc);
		end;
	end;
	
	if self.hydRotL ~= nil then
		local xx,yy,zz = getRotation(self.wheels[1].repr);
		local x, y, z = getRotation(self.hydRotL.node);
		if yy<=0 then
			local yc = self.hydRotL.nullRot[2]-yy*self.hydRotL.mn2;
			setRotation(self.hydRotL.node, x, (math.pi/180)*yc, z);
		elseif yy>0 then
			local yc = self.hydRotL.nullRot[2]-yy*self.hydRotL.mn;
			setRotation(self.hydRotL.node, x, (math.pi/180)*yc, z);
		end;
	end;
	
	if self.hydRotR ~= nil then
		local xx,yy,zz = getRotation(self.wheels[1].repr);
		local x, y, z = getRotation(self.hydRotR.node);
		if yy>0 then
			local yc = self.hydRotR.nullRot[2]-yy*self.hydRotR.mn2;
			setRotation(self.hydRotR.node, x, (math.pi/180)*yc, z);
		elseif yy<=0 then
			local yc = self.hydRotR.nullRot[2]-yy*self.hydRotR.mn;
			setRotation(self.hydRotR.node, x, (math.pi/180)*yc, z);
		end;
	end;	
	
end;
	

function KIROsteering:draw()
end;