--
-- JD1590
-- Specialization for farmer car mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

JD1590 = {};

function JD1590.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function JD1590:load(xmlFile)
    self.speedlimit = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.speed#limit"), 13);
    self.findTrailerRaycastCallback = Combine.findTrailerRaycastCallback;
    self.trailerPosition = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
    self.grainUnloading = 100;

    self.setFillLevel = SpecializationUtil.callSpecializationsFunction("setFillLevel");
    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));

    self.speedViolationMaxTime = 2500;
    self.speedViolationTimer = self.speedViolationMaxTime;

    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[fruitType.index] = fruitType.index;
        end;
    end;

    self.isTurnedOn = false;

    self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;
    --self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;

    self.lastFillDelta = 0;
    self.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
    self.minThreshold = 0.05;
    self.fillTypes = {};

    local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fillTypes[desc.index] = true;
            end;
        end;
    end;

    self.grainPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);
            if self.defaultGrainPlane == nil then
                self.defaultGrainPlane = node;
            end;
            self.grainPlanes[t] = node;
        end;
        i = i +1;
    end;
    if self.defaultGrainPlane==nil then
        self.grainPlanes = nil;
    end;

    self.grainPlaneMinY, self.grainPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainPlane#minMaxY"));
    if self.grainPlaneMinY == nil or self.grainPlaneMaxY == nil then
        local grainAnimCurve = AnimCurve:new(linearInterpolator4);
        local keyI = 0;
        while true do
            local key = string.format("vehicle.grainPlane.key(%d)", keyI);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            grainAnimCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            keyI = keyI +1;
        end;
        if keyI > 0 then
            self.grainAnimCurve = grainAnimCurve;
        end;
        self.grainPlaneMinY = 0;
        self.grainPlaneMaxY = 0;
    end;

    self.aiaktiv = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));


    self.setActive = SpecializationUtil.callSpecializationsFunction("setActive");
		self.drumNodeLeft1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumLeft#index1"));
	self.drumNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumLeft#index2"));
	self.drumNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumLeft#index3"));
	self.drumNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumLeft#index4"));
	self.drumNodeRight1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumRight#index1"));
	self.drumNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumRight#index2"));
	self.drumNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumRight#index3"));
	self.drumNodeRight4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drumRight#index4"));
	self.tramline1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tramline#index1"));
	self.tramline2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tramline#index2"));
	self.backwheel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwheel#index"));
	self.drumRotationScale1 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drumLeft#rotationScale"), 0);
	self.drumRotationScale2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drumRight#rotationScale"), 0);
	self.backWheelRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.backwheel#rotationScale"), 0);

	self.threshingParticleSystems1 = {};
    local psName = "vehicle.threshingParticleSystem1";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems1, psName, self.rootNode, false);
	

	local airSeederPneumaticsound = getXMLString(xmlFile, "vehicle.airSeederPneumaticsound#file");
    if airSeederPneumaticsound ~= nil and airSeederPneumaticsound ~= "" then
	  airSeederPneumaticsound = Utils.getFilename(airSeederPneumaticsound, self.baseDirectory);
        self.airSeederPneumaticsound = createSample("airSeederPneumaticsound");
        loadSample(self.airSeederPneumaticsound, airSeederPneumaticsound, false);
		self.airSeederPneumaticsoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.airSeederPneumaticsound#pitchOffset"), 1);
    end;

	local solitairRubbersound = getXMLString(xmlFile, "vehicle.solitairRubbersound#file");
    if solitairRubbersound ~= nil and solitairRubbersound ~= "" then
	  solitairRubbersound = Utils.getFilename(solitairRubbersound, self.baseDirectory);
        self.solitairRubbersound = createSample("solitairRubbersound");
        loadSample(self.solitairRubbersound, solitairRubbersound, false);
		self.solitairRubbersoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.solitairRubbersound#pitchOffset"), 1);
    end;

local rotationPartNodeMiddle2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMiddle2#index"));
    if rotationPartNodeMiddle2 ~= nil then
        self.rotationPartMiddle2 = {};
        self.rotationPartMiddle2.node = rotationPartNodeMiddle2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMiddle2#minRot"));
        self.rotationPartMiddle2.minRot = {};
        self.rotationPartMiddle2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMiddle2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMiddle2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMiddle2#maxRot"));
        self.rotationPartMiddle2.maxRot = {};
        self.rotationPartMiddle2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMiddle2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMiddle2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMiddle2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMiddle2#rotTime"), 2)*1000;
        self.rotationPartMiddle2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMiddle2#touchRotLimit"), 10));
    end;

	local rotationPartNodeMiddle3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartMiddle3#index"));
    if rotationPartNodeMiddle3 ~= nil then
        self.rotationPartMiddle3 = {};
        self.rotationPartMiddle3.node = rotationPartNodeMiddle3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMiddle3#minRot"));
        self.rotationPartMiddle3.minRot = {};
        self.rotationPartMiddle3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMiddle3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMiddle3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartMiddle3#maxRot"));
        self.rotationPartMiddle3.maxRot = {};
        self.rotationPartMiddle3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartMiddle3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartMiddle3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartMiddle3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMiddle3#rotTime"), 2)*1000;
        self.rotationPartMiddle3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartMiddle3#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline1#index"));
    if rotationPartNodeTramline1 ~= nil then
        self.rotationPartTramline1 = {};
        self.rotationPartTramline1.node = rotationPartNodeTramline1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline1#minRot"));
        self.rotationPartTramline1.minRot = {};
        self.rotationPartTramline1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline1#maxRot"));
        self.rotationPartTramline1.maxRot = {};
        self.rotationPartTramline1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline1#rotTime"), 2)*1000;
        self.rotationPartTramline1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline2#index"));
    if rotationPartNodeTramline2 ~= nil then
        self.rotationPartTramline2 = {};
        self.rotationPartTramline2.node = rotationPartNodeTramline2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline2#minRot"));
        self.rotationPartTramline2.minRot = {};
        self.rotationPartTramline2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline2#maxRot"));
        self.rotationPartTramline2.maxRot = {};
        self.rotationPartTramline2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline2#rotTime"), 2)*1000;
        self.rotationPartTramline2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline12#index"));
    if rotationPartNodeTramline12 ~= nil then
        self.rotationPartTramline12 = {};
        self.rotationPartTramline12.node = rotationPartNodeTramline12;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline12#minRot"));
        self.rotationPartTramline12.minRot = {};
        self.rotationPartTramline12.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline12.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline12.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline12#maxRot"));
        self.rotationPartTramline12.maxRot = {};
        self.rotationPartTramline12.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline12.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline12.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline12.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline12#rotTime"), 2)*1000;
        self.rotationPartTramline12.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline12#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline22 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline22#index"));
    if rotationPartNodeTramline22 ~= nil then
        self.rotationPartTramline22 = {};
        self.rotationPartTramline22.node = rotationPartNodeTramline22;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline22#minRot"));
        self.rotationPartTramline22.minRot = {};
        self.rotationPartTramline22.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline22.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline22.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline22#maxRot"));
        self.rotationPartTramline22.maxRot = {};
        self.rotationPartTramline22.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline22.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline22.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline22.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline22#rotTime"), 2)*1000;
        self.rotationPartTramline22.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline22#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline123 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline123#index"));
    if rotationPartNodeTramline123 ~= nil then
        self.rotationPartTramline123 = {};
        self.rotationPartTramline123.node = rotationPartNodeTramline123;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline123#minRot"));
        self.rotationPartTramline123.minRot = {};
        self.rotationPartTramline123.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline123.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline123.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline123#maxRot"));
        self.rotationPartTramline123.maxRot = {};
        self.rotationPartTramline123.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline123.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline123.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline123.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline123#rotTime"), 2)*1000;
        self.rotationPartTramline123.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline123#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline124 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline124#index"));
    if rotationPartNodeTramline124 ~= nil then
        self.rotationPartTramline124 = {};
        self.rotationPartTramline124.node = rotationPartNodeTramline124;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline124#minRot"));
        self.rotationPartTramline124.minRot = {};
        self.rotationPartTramline124.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline124.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline124.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline124#maxRot"));
        self.rotationPartTramline124.maxRot = {};
        self.rotationPartTramline124.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline124.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline124.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline124.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline124#rotTime"), 2)*1000;
        self.rotationPartTramline124.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline124#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline223 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline223#index"));
    if rotationPartNodeTramline223 ~= nil then
        self.rotationPartTramline223 = {};
        self.rotationPartTramline223.node = rotationPartNodeTramline223;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline223#minRot"));
        self.rotationPartTramline223.minRot = {};
        self.rotationPartTramline223.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline223.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline223.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline223#maxRot"));
        self.rotationPartTramline223.maxRot = {};
        self.rotationPartTramline223.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline223.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline223.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline223.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline223#rotTime"), 2)*1000;
        self.rotationPartTramline223.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline223#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTramline224 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramline224#index"));
    if rotationPartNodeTramline224 ~= nil then
        self.rotationPartTramline224 = {};
        self.rotationPartTramline224.node = rotationPartNodeTramline224;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline224#minRot"));
        self.rotationPartTramline224.minRot = {};
        self.rotationPartTramline224.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline224.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline224.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramline224#maxRot"));
        self.rotationPartTramline224.maxRot = {};
        self.rotationPartTramline224.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramline224.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramline224.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramline224.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline224#rotTime"), 2)*1000;
        self.rotationPartTramline224.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramline224#touchRotLimit"), 10));
    end;

	local rotationPartNodeTramlineHyd1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd1#index"));
    if rotationPartNodeTramlineHyd1 ~= nil then
        self.rotationPartTramlineHyd1 = {};
        self.rotationPartTramlineHyd1.node = rotationPartNodeTramlineHyd1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd1#minRot"));
        self.rotationPartTramlineHyd1.minRot = {};
        self.rotationPartTramlineHyd1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramlineHyd1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramlineHyd1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd1#maxRot"));
        self.rotationPartTramlineHyd1.maxRot = {};
        self.rotationPartTramlineHyd1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramlineHyd1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramlineHyd1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramlineHyd1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd1#rotTime"), 2)*1000;
        self.rotationPartTramlineHyd1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd1#touchRotLimit"), 10));
    end;

	local rotationPartNodeTramlineHyd2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd2#index"));
    if rotationPartNodeTramlineHyd2 ~= nil then
        self.rotationPartTramlineHyd2 = {};
        self.rotationPartTramlineHyd2.node = rotationPartNodeTramlineHyd2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd2#minRot"));
        self.rotationPartTramlineHyd2.minRot = {};
        self.rotationPartTramlineHyd2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramlineHyd2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramlineHyd2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd2#maxRot"));
        self.rotationPartTramlineHyd2.maxRot = {};
        self.rotationPartTramlineHyd2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTramlineHyd2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTramlineHyd2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTramlineHyd2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd2#rotTime"), 2)*1000;
        self.rotationPartTramlineHyd2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTramlineHyd2#touchRotLimit"), 10));
    end;

	local rotationPartNodeSeedBoxLid = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSeedBoxLid#index"));
    if rotationPartNodeSeedBoxLid ~= nil then
        self.rotationPartSeedBoxLid = {};
        self.rotationPartSeedBoxLid.node = rotationPartNodeSeedBoxLid;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSeedBoxLid#minRot"));
        self.rotationPartSeedBoxLid.minRot = {};
        self.rotationPartSeedBoxLid.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSeedBoxLid.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSeedBoxLid.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSeedBoxLid#maxRot"));
        self.rotationPartSeedBoxLid.maxRot = {};
        self.rotationPartSeedBoxLid.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSeedBoxLid.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSeedBoxLid.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSeedBoxLid.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSeedBoxLid#rotTime"), 2)*1000;
        self.rotationPartSeedBoxLid.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSeedBoxLid#touchRotLimit"), 10));
    end;

	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;

	local translationPartHyd1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartHyd1#index"));
    if translationPartHyd1Node ~= nil then
        self.translationPartHyd1 = {};
        self.translationPartHyd1.node = translationPartHyd1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartHyd1#minTrans"));
        self.translationPartHyd1.minTrans = {};
        self.translationPartHyd1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartHyd1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartHyd1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartHyd1#maxTrans"));
        self.translationPartHyd1.maxTrans = {};
        self.translationPartHyd1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartHyd1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartHyd1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartHyd1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartHyd1#transTime"), 2)*1000;
        self.translationPartHyd1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartHyd1#touchTransLimit"), 10);
    end;

	local translationPartHyd2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartHyd2#index"));
    if translationPartHyd2Node ~= nil then
        self.translationPartHyd2 = {};
        self.translationPartHyd2.node = translationPartHyd2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartHyd2#minTrans"));
        self.translationPartHyd2.minTrans = {};
        self.translationPartHyd2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartHyd2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartHyd2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartHyd2#maxTrans"));
        self.translationPartHyd2.maxTrans = {};
        self.translationPartHyd2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartHyd2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartHyd2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartHyd2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartHyd2#transTime"), 2)*1000;
        self.translationPartHyd2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartHyd2#touchTransLimit"), 10);
    end;

	local rotationPartNodeTowBar = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTowBar#index"));
    if rotationPartNodeTowBar ~= nil then
        self.rotationPartTowBar = {};
        self.rotationPartTowBar.node = rotationPartNodeTowBar;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTowBar#minRot"));
        self.rotationPartTowBar.minRot = {};
        self.rotationPartTowBar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTowBar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTowBar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTowBar#maxRot"));
        self.rotationPartTowBar.maxRot = {};
        self.rotationPartTowBar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTowBar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTowBar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTowBar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTowBar#rotTime"), 2)*1000;
        self.rotationPartTowBar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTowBar#touchRotLimit"), 10));
    end;

	local rotationPartNodeTrailerHitch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTrailerHitch#index"));
    if rotationPartNodeTrailerHitch ~= nil then
        self.rotationPartTrailerHitch = {};
        self.rotationPartTrailerHitch.node = rotationPartNodeTrailerHitch;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTrailerHitch#minRot"));
        self.rotationPartTrailerHitch.minRot = {};
        self.rotationPartTrailerHitch.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTrailerHitch.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTrailerHitch.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTrailerHitch#maxRot"));
        self.rotationPartTrailerHitch.maxRot = {};
        self.rotationPartTrailerHitch.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTrailerHitch.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTrailerHitch.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTrailerHitch.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTrailerHitch#rotTime"), 2)*1000;
        self.rotationPartTrailerHitch.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTrailerHitch#touchRotLimit"), 10));
    end;


	local dollyNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dolly#index"));
    if dollyNode ~= nil then
        self.dollyPart = {};
        self.dollyPart.node = dollyNode;
        self.dollyPart.wheel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dolly#dollyWheelIndex"));
    end;

	self.towBarAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.towBarAttacher#index"));
	self.trailerHitchAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trailerHitchAttacher#index"));

	self.showmarkersright = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.showmarkers#right"), false);
	self.showmarkersleft = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.showmarkers#left"), false);
	
	self.downPosition = false;
      self.rotationMaxMiddle2 = true;
      
	self.rotationMaxTramline1 = false;
	self.rotationMaxTramline12 = false;
	self.rotationMaxTramline2 = false;
	self.rotationMaxTramline22 = false;
	self.rotationMaxTramline123 = false;
	self.rotationMaxTramline124 = false;
	self.rotationMaxTramline223 = false;
	self.rotationMaxTramline224 = false;
	self.rotationMaxTramlineHyd1 = false;
	self.rotationMaxTramlineHyd2 = false;

	self.translationHyd1Max = false;
	self.translationHyd2Max = false;

	self.rotationMaxSeedBoxLid = false;
	self.rotationMaxTowBar = false;
	self.rotationMaxTrailerHitch = false;
	self.seedboxLidClosed = false;
	self.towBarOpen = false;
	self.trailerHitchOpen = false;

	self.lastDollyRotation = 0;
	self.time = 0;
	self.fillLevel = 0;
	self.previousMovingDirection = 0;
	
	self.speedViolationMaxTime = 2500;
    	self.speedViolationTimer = self.speedViolationMaxTime;

	self.lastMovingDirection = 0; 
	self.rotationSpeed = 0;
	self.rotationSpeedDownRate = 0;

	self.isActive = false;
	self.sowingBit = 0;
end;

function JD1590:delete()
end;

function JD1590:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD1590:keyEvent(unicode, sym, modifier, isDown)
if isDown and sym == Input.KEY_j then
	self.rotationMaxTramline1 = false;
	self.rotationMaxTramline12 = false;
	self.rotationMaxTramline2 = true;
	self.rotationMaxTramline22 = true;
	self.rotationMaxTramline123 = false;
	self.rotationMaxTramline124 = false;
	self.rotationMaxTramline223 = true;
	self.rotationMaxTramline224 = true;
	self.rotationMaxTramlineHyd1 = false;
	self.rotationMaxTramlineHyd2 = true;
	end;

	if isDown and sym == Input.KEY_l then
	self.rotationMaxTramline1 = true;
	self.rotationMaxTramline12 = true;
	self.rotationMaxTramline2 = false;
	self.rotationMaxTramline22 = false;
	self.rotationMaxTramline123 = true;
	self.rotationMaxTramline124 = true;
	self.rotationMaxTramline223 = false;
	self.rotationMaxTramline224 = false;
	self.rotationMaxTramlineHyd1 = true;
	self.rotationMaxTramlineHyd2 = false;
	end;
	
	if isDown and sym == Input.KEY_k then
	self.rotationMaxTramline1 = false;
	self.rotationMaxTramline12 = false;
	self.rotationMaxTramline2 = false;
	self.rotationMaxTramline22 = false;
	self.rotationMaxTramline123 = false;
	self.rotationMaxTramline124 = false;
	self.rotationMaxTramline223 = false;
	self.rotationMaxTramline224 = false;
	self.rotationMaxTramlineHyd1 = false;
	self.rotationMaxTramlineHyd2 = false;
	end;

	if isDown and sym == Input.KEY_g then
		self.rotationMaxSeedBoxLid = not self.rotationMaxSeedBoxLid ;
	end;

	if isDown and sym == Input.KEY_k then
		self.rotationMaxTowBar = not self.rotationMaxTowBar ;
		self.rotationMaxTrailerHitch = not self.rotationMaxTrailerHitch ;
	end;


	
	if isDown and sym == Input.KEY_n then
		self.rotationMaxMiddle2 = not self.rotationMaxMiddle2;
		playSample(self.airSeederPneumaticsound, 1, 1, 0);
		--self.isActive = not self.isActive;
		self:setActive(not self.isActive);
	end;
	
	if isDown and sym == Input.KEY_o then
		self.applyingFertilizer = not self.applyingFertilizer;
	end;

	if isDown and sym ==  Input.KEY_0 then
		local currentFillLevel = self.fillLevel - self.grainUnloading;
		if currentFillLevel > 0 then
			self:setFillLevel(self.fillLevel - self.grainUnloading, self.currentFillType);
		else
			self:setFillLevel(0, self.currentFillType);
		end;
    	end;
		
      local trailer = g_currentMission.objectToTrailer[self.trailerFound];
	if trailer ~= nil and self.trailerFound ~= 0 and self.fillTypes[tcft] then
		if self.currentFillType == tcft or self.fillLevel == 0 then
			if isDown and sym == Input.KEY_m then
          			local deltaLevel = self.grainUnloading;
	    			deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
					if deltaLevel == 0 then
						deltaLevel = self.grainUnloading;
					end;

					self.currentFillType = tcft;

	    			self.fillLevel = self.fillLevel+deltaLevel;
	    			if self.fillLevel >= self.capacity then
	         			self.fillLevel = self.capacity;
	    			end;
	    			if trailer.fillLevel <= 0.0 then
	          			trailer.fillLevel = 0.0;
		    			trailer.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	    			end;
	    			trailer:setFillLevel(trailer.fillLevel-deltaLevel, trailer.currentFillType);
	    			self:setFillLevel(self.fillLevel, tcft);
			end;
		end;
    end;
end;

function JD1590:update(dt)
self.time = self.time + dt;

	if self.fillLevel == 0 then
		self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN;
	else
		self.currentFillType = self.currentFillType;
	end;
	
	if self.translationMax ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
	end;

	--if self.fruitTypeSelector == 0 then
		--self.currentFillType = FruitUtil.FRUITTYPE_WHEAT;
	--elseif self.fruitTypeSelector == 1 then
	--	self.currentFillType = FruitUtil.FRUITTYPE_RAPE;
	--elseif self.fruitTypeSelector == 2 then
	--	self.currentFillType = FruitUtil.FRUITTYPE_BARLEY;
	--end;
	
	
	if self.attacherVehicle then
	if self.attacherVehicle.isEntered or self.attacherVehicle.isAITractorActivated then
		self.trailerFound = 0;
		local x,y,z = getWorldTranslation(self.trailerPosition);
    		raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
	
		self.translationMax = true;

-- AI
	if self.attacherVehicle.isAITractorActivated then				
    		self.attacherVehicle.turnStage3Timeout = 0;
		self.rotationMaxTramline1 = false;
		self.rotationMaxTramline12 = false;
		self.rotationMaxTramline2 = false;
		self.rotationMaxTramline22 = false;
		self.rotationMaxTramline123 = false;
		self.rotationMaxTramline124 = false;
		self.rotationMaxTramline223 = false;
		self.rotationMaxTramline224 = false;
		self.rotationMaxTramlineHyd1 = false;
		self.rotationMaxTramlineHyd2 = false;				
		if self.fillLevel == 0 then
			AITractor.stopAITractor(self.attacherVehicle);
			self.stop = true;
			self.seedboxLidClosed = false;
		end;
		if self.attacherVehicle.turnStage == 0 then
			self.rotationMaxMiddle2 = false;
		else
			self.rotationMaxMiddle2 = true;
		end;	
	else
		if self.fillLevel == self.capacity and self.stop then
			AITractor.startAITractor(self.attacherVehicle);
			self.rotationMaxMiddle2 = true;
			self.seedboxLidClosed = true;
			self.stop = false;
		end;
		if self.attacherVehicle.isAITractorActivated ~= nil then
			self.attacherVehicle.turnStage3Timeout = 20000;
		end; 	
	end;
-- AU end

		
		if not self.rightMarker == true then
		    if self.cuttingAreas[2] ~= nil then
			local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);

			local rotX, rotY, rotZ = getRotation(self.rotationPartTramline1.node);
			if rotZ  >= self.rotationPartTramline1.maxRot[3]-0.2 then
				if self.showmarkersright == true then  		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2);
				end;
			end;
		     end;
		end;

		
		if not self.leftMarker == true then
		    if self.cuttingAreas[3] ~= nil then
			local x,y,z = getWorldTranslation(self.cuttingAreas[3].start);
			local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[3].width);
			local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[3].height);
			
			local rotX, rotY, rotZ = getRotation(self.rotationPartTramline2.node);
			if rotZ  >= self.rotationPartTramline2.maxRot[3]-0.2 then
				if self.showmarkersleft == true then		
					Utils.updatePloughArea(x, z, x1, z1, x2, z2);
				end;
			end;
		    end;
		end;

		if self.sowingBit == 1 then
			self.sowingBit = 0;
		else
			self.sowingBit = 1; 
		end;

		if self.downPosition and self.sowingBit == 1 then
			if self.attacherVehicle.lastSpeed*3600 > 20 then
				self.speedViolationTimer = self.speedViolationTimer - dt;
			else
				self.speedViolationTimer = self.speedViolationMaxTime;
			end;

			if self.speedViolationTimer > 0 then

        			local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
            		local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
            		local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
            		local area = 0;


				--area = Utils.updatePloughArea(x, z, x1, z1, x2, z2);
		
				if self.fillLevel > 0 then
					
					area = Utils.updateSowingArea(self.currentFillType, x, z, x1, z1, x2, z2);
				else
					area = 0;
				end;

				if self.currentFillType ~= nil and self.currentFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then 
            			local fruitDesc = FruitUtil.fruitIndexToDesc[self.currentFillType];

            			local pixelToSqm = 2048 / 8192 * 2048 / 8192;
            			local Sqm = area*pixelToSqm;
            			local ha = Sqm/10000;
					local speedFactor = self.attacherVehicle.lastSpeed*3600/12;
            			local usage = fruitDesc.seedUsagePerSqm*Sqm*speedFactor*5;

					if self.applyingFertilizer then
						Utils.updateSprayArea(x, z, x1, z1, x2, z2);
                  			local seedPrice = fruitDesc.seedPricePerLiter*usage;
                  			g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + seedPrice;
                 				g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + seedPrice;
					end;


					if self.attacherVehicle.lastSpeed*3600 > 0.1 then 
						self:setFillLevel(self.fillLevel-usage, self.currentFillType);
					end;

           				g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
            			g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

            			g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
            			g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

            			g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
            			g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);


				end;
			end;
		end;

		if self.downPosition and self.sowingBit == 0 and not self.attacherVehicle.isAITractorActivated then
			if self.attacherVehicle.lastSpeed*3600 > 20 then
				self.speedViolationTimer = self.speedViolationTimer - dt;
			else
				self.speedViolationTimer = self.speedViolationMaxTime;
			end;

			if self.speedViolationTimer > 0 then

        			local x,y,z = getWorldTranslation(self.cuttingAreas[4].start);
            		local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[4].width);
            		local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[4].height);
            		local area = 0;
		
				if self.fillLevel > 0 then
					
            			area = Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
				else
					area = 0;
				end;
			end;
		end;
		
		if not self.downPosition or self.attacherVehicle.lastSpeed*3600 < 2 or not self.attacherVehicle.isEntered then
			Utils.setEmittingState(self.threshingParticleSystems1, false);

			if self.solitairRubbersoundRunning then
			stopSample(self.solitairRubbersound);
			self.solitairRubbersoundRunning = false;
			end;
		end;
		
		if self.downPosition and self.attacherVehicle.isEntered then
			Utils.setEmittingState(self.threshingParticleSystems1, (self.attacherVehicle.lastSpeed*3600 > 2 ))
			
			if self.attacherVehicle.lastSpeed*3600 > 2 then
				if not self.solitairRubbersoundRunning then
               			 	playSample(self.solitairRubbersound, 0, 0.6, 0);
                		 	self.solitairRubbersoundRunning = true;
				end;
			end;
		end;
		
			
			self.downPosition = false;
	  if self.rotationPartMiddle2 ~= nil then
            local x, y, z = getRotation(self.rotationPartMiddle2.node);
            local minRot = self.rotationPartMiddle2.minRot;
            local eps = self.rotationPartMiddle2.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.downPosition = true;
            end;
        end;

	  		self.downPosition = false;
	  if self.rotationPartMiddle3 ~= nil then
            local x, y, z = getRotation(self.rotationPartMiddle3.node);
            local minRot = self.rotationPartMiddle3.minRot;
            local eps = self.rotationPartMiddle3.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.downPosition = true;
            end;
        end;
	
		self.rightMarker = false;
		if self.rotationPartTramline1 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline1.node);
			local minRot = self.rotationPartTramline1.minRot;
			local eps = self.rotationPartTramline1.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.rightMarker = true;
            end;
		end;

		self.rightMarker = false;
		if self.rotationPartTramline12 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline12.node);
			local minRot = self.rotationPartTramline12.minRot;
			local eps = self.rotationPartTramline12.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.rightMarker = true;
            end;
		end;

		self.rightMarker = false;
		if self.rotationPartTramline123 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline123.node);
			local minRot = self.rotationPartTramline123.minRot;
			local eps = self.rotationPartTramline123.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.rightMarker = true;
            end;
		end;

		self.rightMarker = false;
		if self.rotationPartTramlineHyd1 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramlineHyd1.node);
			local minRot = self.rotationPartTramlineHyd1.minRot;
			local eps = self.rotationPartTramlineHyd1.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.rightMarker = true;
            end;
		end;


		self.leftMarker = false;
		if self.rotationPartTramline2 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline2.node);
			local minRot = self.rotationPartTramline2.minRot;
			local eps = self.rotationPartTramline2.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.leftMarker = true;
            end;
		end;

		self.leftMarker = false;
		if self.rotationPartTramline22 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline22.node);
			local minRot = self.rotationPartTramline22.minRot;
			local eps = self.rotationPartTramline22.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.leftMarker = true;
            end;
		end;

		self.leftMarker = false;
		if self.rotationPartTramline223 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramline223.node);
			local minRot = self.rotationPartTramline223.minRot;
			local eps = self.rotationPartTramline223.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.leftMarker = true;
            end;
		end;

		self.leftMarker = false;
		if self.rotationPartTramlineHyd2 ~= nil then
			local x, y, z = getRotation(self.rotationPartTramlineHyd2.node);
			local minRot = self.rotationPartTramlineHyd2.minRot;
			local eps = self.rotationPartTramlineHyd2.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.leftMarker = true;
            end;
		end;

		self.seedboxLidClosed = false;
		if self.rotationPartSeedBoxLid ~= nil then
			local x, y, z = getRotation(self.rotationPartSeedBoxLid.node);
			local minRot = self.rotationPartSeedBoxLid.minRot;
			local eps = self.rotationPartSeedBoxLid.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.seedboxLidClosed = true;
            end;
		end;

		self.TowBarOpen = false;
		if self.rotationPartTowBar ~= nil then
			local x, y, z = getRotation(self.rotationPartTowBar.node);
			local minRot = self.rotationPartTowBar.minRot;
			local eps = self.rotationPartTowBar.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                		self.TowBarOpen = true;
            end;
		end;

		self.TrailerHitchOpen = false;
		if self.rotationPartTrailerHitch ~= nil then
			local x, y, z = getRotation(self.rotationPartTrailerHitch.node);
			local minRot = self.rotationPartTrailerHitch.minRot;
			local eps = self.rotationPartTrailerHitch.touchRotLimit;
			
			if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
	                self.TrailerHitchOpen = true;
            end;
		end;



		
		if self.isActive then
			--print("active");
			if self.playAirSeederSound and self.airSeederSound ~= nil and self.playAirSeederSoundTime <= self.time then
			playSample(self.airSeederSound, 0, 5, 0);
			self.playAirSeederSound = false;
			end;
		end;
		
			if self.rotationPartTramline1 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline1.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline1.maxRot, self.rotationPartTramline1.minRot, 3, self.rotationPartTramline1.rotTime, dt, not self.rotationMaxTramline1);
				setRotation(self.rotationPartTramline1.node, unpack(newRot));
			end;

			if self.translationPartHyd1 ~= nil then
			local x, y, z = getTranslation(self.translationPartHyd1.node);
        		local trans = {x,y,z};
        		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartHyd1.maxTrans, self.translationPartHyd1.minTrans, 3, self.translationPartHyd1.transTime, dt, self.rotationMaxTramline1);
        		setTranslation(self.translationPartHyd1.node, unpack(newTrans));
			end;

			if self.translationPartHyd2 ~= nil then
			local x, y, z = getTranslation(self.translationPartHyd2.node);
        		local trans = {x,y,z};
        		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartHyd2.maxTrans, self.translationPartHyd2.minTrans, 3, self.translationPartHyd2.transTime, dt, self.rotationMaxTramline2);
        		setTranslation(self.translationPartHyd2.node, unpack(newTrans));
			end;

			if self.rotationPartTramline12 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline12.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline12.maxRot, self.rotationPartTramline12.minRot, 3, self.rotationPartTramline12.rotTime, dt, not self.rotationMaxTramline12);
				setRotation(self.rotationPartTramline12.node, unpack(newRot));
			end;
			
			if self.rotationPartTramline2 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline2.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline2.maxRot, self.rotationPartTramline2.minRot, 3, self.rotationPartTramline2.rotTime, dt, not self.rotationMaxTramline2);
				setRotation(self.rotationPartTramline2.node, unpack(newRot));
			end;
			
			if self.rotationPartTramline22 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline22.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline22.maxRot, self.rotationPartTramline22.minRot, 3, self.rotationPartTramline22.rotTime, dt, not self.rotationMaxTramline22);
				setRotation(self.rotationPartTramline22.node, unpack(newRot));
			end;
			
			if self.rotationPartTramline123 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline123.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline123.maxRot, self.rotationPartTramline123.minRot, 3, self.rotationPartTramline123.rotTime, dt, not self.rotationMaxTramline123);
				setRotation(self.rotationPartTramline123.node, unpack(newRot));
			end;

			if self.rotationPartTramlineHyd1 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramlineHyd1.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramlineHyd1.maxRot, self.rotationPartTramlineHyd1.minRot, 3, self.rotationPartTramlineHyd1.rotTime, dt, not self.rotationMaxTramlineHyd1);
				setRotation(self.rotationPartTramlineHyd1.node, unpack(newRot));
			end;
			
			if self.leftMarker == true and self.rightMarker == false then
				if self.rotationPartTramline124 ~= nil then
					local wheelRotationAvg = getRotation(self.wheels[2].repr);
					setRotation(self.rotationPartTramline124.node, -1*wheelRotationAvg*1.5, 0, 0);
				end;
			end;
			
			if self.rotationPartTramline223 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramline223.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramline223.maxRot, self.rotationPartTramline223.minRot, 3, self.rotationPartTramline223.rotTime, dt, not self.rotationMaxTramline223);
				setRotation(self.rotationPartTramline223.node, unpack(newRot));
			end;

			if self.rotationPartTramlineHyd2 ~= nil then
				local x, y, z = getRotation(self.rotationPartTramlineHyd2.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTramlineHyd2.maxRot, self.rotationPartTramlineHyd2.minRot, 3, self.rotationPartTramlineHyd2.rotTime, dt, not self.rotationMaxTramlineHyd2);
				setRotation(self.rotationPartTramlineHyd2.node, unpack(newRot));
			end;

			if self.rotationPartSeedBoxLid ~= nil then
				local x, y, z = getRotation(self.rotationPartSeedBoxLid.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSeedBoxLid.maxRot, self.rotationPartSeedBoxLid.minRot, 3, self.rotationPartSeedBoxLid.rotTime, dt, not self.rotationMaxSeedBoxLid);
				setRotation(self.rotationPartSeedBoxLid.node, unpack(newRot));
			end;


			if self.rotationPartTowBar ~= nil then
				local x, y, z = getRotation(self.rotationPartTowBar.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTowBar.maxRot, self.rotationPartTowBar.minRot, 3, self.rotationPartTowBar.rotTime, dt, not self.rotationMaxTowBar);
				setRotation(self.rotationPartTowBar.node, unpack(newRot));
				local rotation = Utils.degToRad(90) - y;
				if self.towBarAttacher ~= nil then 
					setRotation(self.towBarAttacher, 0 , rotation , 0);
					--renderText(0.70, 0.2, 0.02, string.format("%f", rotation));
				end;
			end;

			if self.rotationPartTrailerHitch ~= nil then
				local x, y, z = getRotation(self.rotationPartTrailerHitch.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTrailerHitch.maxRot, self.rotationPartTrailerHitch.minRot, 3, self.rotationPartTrailerHitch.rotTime, dt, not self.rotationMaxTrailerHitch);
				setRotation(self.rotationPartTrailerHitch.node, unpack(newRot));
				local rotation = Utils.degToRad(90) - y;
				if self.trailerHitchAttacher ~= nil then
					setRotation(self.trailerHitchAttacher, Utils.degToRad(180), rotation , 0);
					--renderText(0.88, 0.2, 0.02, string.format("%f", rotation));
				end;
			end;




			if self.leftMarker == false and self.rightMarker == true then
				if self.rotationPartTramline224 ~= nil then
					local wheelRotationAvg = getRotation(self.wheels[1].repr);
					setRotation(self.rotationPartTramline224.node, wheelRotationAvg*1.5, 0, 0);
				end;
			end;
			
			if self.rotationPartMiddle2 ~= nil then
				local x, y, z = getRotation(self.rotationPartMiddle2.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMiddle2.maxRot, self.rotationPartMiddle2.minRot, 3, self.rotationPartMiddle2.rotTime, dt, not self.rotationMaxMiddle2);
				setRotation(self.rotationPartMiddle2.node, unpack(newRot));
			end;

			if self.rotationPartMiddle3  ~= nil then
				local x, y, z = getRotation(self.rotationPartMiddle3.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartMiddle3.maxRot, self.rotationPartMiddle3.minRot, 3, self.rotationPartMiddle3.rotTime, dt, not self.rotationMaxMiddle2);
				setRotation(self.rotationPartMiddle3.node, unpack(newRot));
			end;

--Dollywheel animation start
			if self.dollyPart.node ~= nil then
				local axleSpeed1 = self.attacherVehicle.lastSpeed*3600;
				local axleSpeed2 = getWheelShapeAxleSpeed(self.wheels[1].node, self.wheels[1].wheelShape)*3.14/180; -- rad/sec


 				local frontAngle = 0;
				local backAngle = 0;
				local x1,y1,z1 = localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, 1);
				local x2,y2,z2 = localDirectionToWorld(self.rootNode, 0, 0, 1);
				--2. skalar produkt, wobei y wert ignorieren
				local dot = x1*x2 + z1*z2;
				--3. durch laengen teilen
				dot = dot / (Utils.vector2Length(x1,z1) * Utils.vector2Length(x2,z2));
				--4. arccosine nehmen
				angle = math.acos(dot);		
				-- y component of cross product
				local cy = z1 * x2 - x1 * z2;		
				if cy < 0 then
					angle = -angle;
				end;		
				frontAngle = (35 * (angle / 50)) * -1;
				backAngle  = 120 * (angle / 50);				
					

				local adjustedRotation = 0;

				if axleSpeed2 < 0 then
					frontAngle = frontAngle - 3.14;
				end;

				adjustedRotation = frontAngle;
				if self.lastDollyRotation > frontAngle+0.1 or self.lastDollyRotation < frontAngle-0.1  then    
					if self.lastDollyRotation < frontAngle then
						adjustedRotation = self.lastDollyRotation - 0.3 * -1 * axleSpeed1/30;  
					elseif self.lastDollyRotation > frontAngle then
						adjustedRotation = self.lastDollyRotation + 0.3 * -1 * axleSpeed1/30;
					end;
				end;

				setRotation(self.dollyPart.node, 0, adjustedRotation, 0);
				
				if self.dollyPart.wheel ~= nil then
					local wheelRotationAvg = (getRotation(self.wheels[1].repr) + getRotation(self.wheels[2].repr))/2;
					if axleSpeed2 < 0 then
					   if adjustedRotation < -2.52  and adjustedRotation > -3.75 then
						wheelRotationAvg = -wheelRotationAvg;
					   end;
					end;
					setRotation(self.dollyPart.wheel, wheelRotationAvg, 0, 0);
				end;

				self.lastDollyRotation = adjustedRotation;
			end;
--Dollywheel animation done

			if self.downPosition then
				self.rotationSpeed = self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection * 85;
				self.rotationSpeedDownRate = math.abs(self.rotationSpeed * 0.01);
				self.lastMovingDirection = self.attacherVehicle.movingDirection;
			else	
				if self.lastMovingDirection == 1 then
					self.rotationSpeed = self.rotationSpeed - self.rotationSpeedDownRate;
					if self.rotationSpeed <= 0 then
						self.rotationSpeed = 0;
					end;
				elseif self.lastMovingDirection == -1 then
					self.rotationSpeed = self.rotationSpeed + self.rotationSpeedDownRate;
					if self.rotationSpeed >= 0 then
						self.rotationSpeed = 0;
					end;
				end;
			end;
			
				if self.drumNodeLeft1 ~= nil then
					rotate(self.drumNodeLeft1, self.drumRotationScale1 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeLeft2 ~= nil then
					rotate(self.drumNodeLeft2, self.drumRotationScale1 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeLeft3 ~= nil then
					rotate(self.drumNodeLeft3, self.drumRotationScale1 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeLeft4 ~= nil then
					rotate(self.drumNodeLeft4, self.drumRotationScale1 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeRight1 ~= nil then
					rotate(self.drumNodeRight1, self.drumRotationScale2 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeRight2 ~= nil then
					rotate(self.drumNodeRight2, self.drumRotationScale2 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeRight3 ~= nil then
					rotate(self.drumNodeRight3, self.drumRotationScale2 * self.rotationSpeed, 0, 0);
				end;
			
				if self.drumNodeRight4 ~= nil then
					rotate(self.drumNodeRight4, self.drumRotationScale2 * self.rotationSpeed, 0, 0);
				end;
			
				if self.backwheel ~= nil then
					rotate(self.backwheel, self.backWheelRotationScale * self.rotationSpeed, 0, 0);
				end;
		end;			
    end;

end;

function JD1590:draw()
        if self.currentFillType ~= nil and self.currentFillType ~= FruitUtil.FRUITTYPE_UNKNOWN then
	 	g_currentMission.fruitOverlays[self.currentFillType]:render();
	end;

	-- if not self.leftExtended and not self.rightExtended then
		-- g_currentMission:addExtraPrintText("Key B: Extend to work position");
	-- else
		-- g_currentMission:addExtraPrintText("Key B: Retract to transport");
	-- end;

	if self.applyingFertilizer then
		g_currentMission:addExtraPrintText("Key O: Stop Applying liquid fertilizer");
	else
		g_currentMission:addExtraPrintText("Key O: Apply liquid fertilizer");
	end;

	if self.leftExtended and self.rightExtended then
		if not self.leftMarker and self.rightMarker then
			g_currentMission:addExtraPrintText("K: Transport, L: Marker right");
		elseif not self.rightMarker and self.leftMarker then
			g_currentMission:addExtraPrintText("J: Marker Left, K: Transport");
		else
			g_currentMission:addExtraPrintText("J: Marker Left, L: Marker right");
		end;
	end;

	if self.fillLevel > 0 then	
		g_currentMission:addExtraPrintText("Key 0: Drain seed boxes on ground");
	end;
	
	tcft = FruitUtil.FRUITTYPE_UNKNOWN;
	local trailer = g_currentMission.objectToTrailer[self.trailerFound];
	if trailer ~= nil then
		tcft = FruitUtil.fillTypeToFruitType[trailer.currentFillType];
	end;
	if self.trailerFound ~= 0 and self.fillTypes[tcft] == true then
		if self.currentFillType == tcft or self.fillLevel == 0 then
			if self.fillLevel < self.capacity then
				g_currentMission:addExtraPrintText("Key M: Fill planter");
			else
				g_currentMission:addExtraPrintText("Planter full");
			end;
		end;
	else
		g_currentMission:addExtraPrintText("Move planter close to trailer to fill");
	end;
    
	if self.seedboxLidClosed then
		g_currentMission:addExtraPrintText("Key G: Seedbox lid open");
	else
		g_currentMission:addExtraPrintText("Key G: Seedbox lid close");
	end;
	
	if self.downPosition then
		g_currentMission:addExtraPrintText("Key N: raise planter");
	else
		g_currentMission:addExtraPrintText("Key N: lower planter")
	end;
    	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        	g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
    	end;
end;

function JD1590:setFillLevel(fillLevel, fillType)

    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
    end;
    if self.currentGrainPlane ~= nil then
        setVisibility(self.currentGrainPlane, false);
    end;
    if self.grainPlanes ~= nil and self.defaultGrainPlane ~= nil then
        local fillTypeName = FruitUtil.fruitIndexToDesc[self.currentFillType].name;
        local grainPlane = self.grainPlanes[fillTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainPlane;
        end;
        local yTranslation;
        if self.grainAnimCurve then
            local scaleX, scaleY, scaleZ , yTrans = self.grainAnimCurve:get(self.fillLevel/self.capacity);
            yTranslation = yTrans;
            setScale(grainPlane, scaleX, scaleY, scaleZ);
        else
            local m = (self.grainPlaneMaxY - self.grainPlaneMinY) / self.capacity;
            yTranslation = m*self.fillLevel + self.grainPlaneMinY;
        end;
        local xPos, yPos, zPos = getTranslation(grainPlane);
        setTranslation(grainPlane, xPos, yTranslation, zPos);
        setVisibility(grainPlane, self.fillLevel > 0);
        self.currentGrainPlane = grainPlane;
    end;
end;

function JD1590:setActive(active)
	self.isActive = active;
	if self.isActive then
		local airSeederSoundOffset = 0;
		if self.airSeederStartsound ~= nil then
			setSamplePitch(self.airSeederStartsound, self.airSeederStartsoundPitchOffset);
			playSample(self.airSeederStartsound, 1, 1.5, 0);
			--motorSoundOffset = 800;
			airSeederSoundOffset = getSampleDuration(self.airSeederStartsound);
		end;

		self.playAirSeederSound = true;
		self.playAirSeederSoundTime = self.time+airSeederSoundOffset;
	else
		print("stopSound1mal");
		stopSample(self.airSeederSound);
		if self.airSeederStopsound ~= nil then
			playSample(self.airSeederStopsound, 1, 1.5, 0);
		end;
	end;
end;

