

--Author: jrbrown  Hiropemonkey@aol.com

ThreePointHitch = {}

function ThreePointHitch.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function ThreePointHitch:load(xmlFile)
    
    local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
	
	local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
    if rotationNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;
	
	local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	
	local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
    end;
	
	local rotationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
    if rotationNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
    end;
	
	local rotationNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart7#index"));
    if rotationNode7 ~= nil then
        self.rotationPart7 = {};
        self.rotationPart7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#minRot"));
        self.rotationPart7.minRot = {};
        self.rotationPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#maxRot"));
        self.rotationPart7.maxRot = {};
        self.rotationPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#rotTime"), 2)*1000;
        self.rotationPart7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#touchRotLimit"), 10));
    end;
	
	local rotationNode8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;
	
	local munkahengerNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger#index"));
    if munkahengerNode ~= nil then
        self.munkahenger = {};
        self.munkahenger.node = munkahengerNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#minTrans"));
        self.munkahenger.minTrans = {};
        self.munkahenger.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#maxTrans"));
        self.munkahenger.maxTrans = {};
        self.munkahenger.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahenger.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#transTime"), 2)*1000;
        self.munkahenger.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#touchTransLimit"), 10);
    end;
	local munkahenger2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger2#index"));
    if munkahenger2Node ~= nil then
        self.munkahenger2 = {};
        self.munkahenger2.node = munkahenger2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger2#minTrans"));
        self.munkahenger2.minTrans = {};
        self.munkahenger2.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger2.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger2#maxTrans"));
        self.munkahenger2.maxTrans = {};
        self.munkahenger2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahenger2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger2#transTime"), 2)*1000;
        self.munkahenger2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger2#touchTransLimit"), 10);
    end;
	local munkahenger3Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger3#index"));
    if munkahenger3Node ~= nil then
        self.munkahenger3 = {};
        self.munkahenger3.node = munkahenger3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger3#minTrans"));
        self.munkahenger3.minTrans = {};
        self.munkahenger3.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger3.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger3#maxTrans"));
        self.munkahenger3.maxTrans = {};
        self.munkahenger3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahenger3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger3#transTime"), 2)*1000;
        self.munkahenger3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger3#touchTransLimit"), 10);
    end;
 	
end;
      
function ThreePointHitch:delete()

end;

function ThreePointHitch:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function ThreePointHitch:keyEvent(unicode, sym, modifier, isDown)
	if sym == Input.KEY_insert then
		self.rotationPart1Min = isDown;
		self.rotationPart2Min = isDown;
		self.rotationPart3Min = isDown;
		self.rotationPart4Min = isDown;
		self.rotationPart5Min = isDown;
		self.rotationPart6Min = isDown;
		self.munkahengerMin = isDown;
		self.munkahenger2Min = isDown;
	end;
	if sym == Input.KEY_delete then
		self.rotationPart1Max = isDown;
		self.rotationPart2Max = isDown;
		self.rotationPart3Max = isDown;
		self.rotationPart4Max = isDown;
		self.rotationPart5Max = isDown;
		self.rotationPart6Max = isDown;
		self.munkahengerMax = isDown;
		self.munkahenger2Max = isDown;
	end;
	if sym == Input.KEY_rightbracket then
		self.rotationPart7Min = isDown;
		self.rotationPart8Min = isDown;
		self.munkahenger3Min = isDown;
	end;
	if sym == Input.KEY_leftbracket then
		self.rotationPart7Max = isDown;
		self.rotationPart8Max = isDown;
		self.munkahenger3Max = isDown;
	end;
end;


function ThreePointHitch:update(dt)

	local doTranslate = self.munkahengerMax or self.munkahengerMin 
	if self.munkahenger ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahenger.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger.maxTrans, self.munkahenger.minTrans, 3, self.munkahenger.transTime, dt, not self.munkahengerMax); 
		setTranslation(self.munkahenger.node, unpack(newTrans)); 
	end; 
	
	local doTranslate = self.munkahenger2Max or self.munkahenger2Min 
	if self.munkahenger2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahenger2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger2.maxTrans, self.munkahenger2.minTrans, 3, self.munkahenger2.transTime, dt, not self.munkahenger2Max); 
		setTranslation(self.munkahenger2.node, unpack(newTrans)); 
	end; 
	
	local doTranslate = self.munkahenger3Max or self.munkahenger3Min 
	if self.munkahenger3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahenger3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger3.maxTrans, self.munkahenger3.minTrans, 3, self.munkahenger3.transTime, dt, not self.munkahenger3Max); 
		setTranslation(self.munkahenger3.node, unpack(newTrans)); 
	end; 
	
	local doRotate = self.rotationPart1Max or self.rotationPart1Min 
	if self.rotationPart1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationPart1Max);
        setRotation(self.rotationPart1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart2Max or self.rotationPart2Min 
	if self.rotationPart2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationPart2Max);
        setRotation(self.rotationPart2.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart3Max or self.rotationPart3Min 
	if self.rotationPart3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationPart3Max);
        setRotation(self.rotationPart3.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart4Max or self.rotationPart4Min 
	if self.rotationPart4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationPart4Max);
        setRotation(self.rotationPart4.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart5Max or self.rotationPart5Min 
	if self.rotationPart5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationPart5Max);
        setRotation(self.rotationPart5.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart6Max or self.rotationPart6Min 
	if self.rotationPart6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationPart6Max);
        setRotation(self.rotationPart6.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart7Max or self.rotationPart7Min 
	if self.rotationPart7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart7.maxRot, self.rotationPart7.minRot, 3, self.rotationPart7.rotTime, dt, not self.rotationPart7Max);
        setRotation(self.rotationPart7.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationPart8Max or self.rotationPart8Min 
	if self.rotationPart8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationPart8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationPart8Max);
        setRotation(self.rotationPart8.node, unpack(newRot));
    end;
end;

function ThreePointHitch:onLeave()
end;

function ThreePointHitch:draw()

end;

function ThreePointHitch:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
