--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


NoseWorklights = {};

function NoseWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) ;
end;

function NoseWorklights:load(xmlFile)
   
	self.setnoseAdditionalLights = SpecializationUtil.callSpecializationsFunction("setnoseAdditionalLights");
	
	self.numNoseWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.noseWorkLights#count"), 0);
    self.noseWorkLights = {};
    for i=1, self.numNoseWorkLights do
        local noseWorkLightsNamei = string.format("vehicle.noseWorkLights.noseWorkLight" .. "%d", i);
        self.noseWorkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, noseWorkLightsNamei .. "#index"));
        setVisibility(self.noseWorkLights[i], false);
    end;
	
	self.numBNWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.BNworkLights#count"), 0);
    self.BNworkLights = {};
    for i=1, self.numBNWorkLights do
        local BNworkLightsNamei = string.format("vehicle.BNworkLights.BNworkLight" .. "%d", i);
        self.BNworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, BNworkLightsNamei .. "#index"));
        setVisibility(self.BNworkLights[i], false);
    end;
	
	self.numTNWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TNworkLights#count"), 0);
    self.TNworkLights = {};
    for i=1, self.numTNWorkLights do
        local TNworkLightsNamei = string.format("vehicle.TNworkLights.TNworkLight" .. "%d", i);
        self.TNworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, TNworkLightsNamei .. "#index"));
        setVisibility(self.TNworkLights[i], false);
    end;
		
	self.noseLightMode = 0;
	self.BNworkLightActive = false;
	self.noseWorkLightActive = false;
	self.TNworkLightActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function NoseWorklights:delete()
	
end;

function NoseWorklights:readStream(streamId, connection)
	self:setnoseAdditionalLights(streamReadInt8(streamId), true);
end;

function NoseWorklights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.noseLightMode);	
end;

function NoseWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NoseWorklights:keyEvent(unicode, sym, modifier, isDown)
	
end;

function NoseWorklights:update(dt)

    if self:getIsActiveForInput() and self.isClient then	
		if InputBinding.hasEvent(InputBinding.JDNOSEWORKSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
				if self.noseLightMode >= 4 then
				self.noseLightMode = 0;
				end;
			self:setnoseAdditionalLights(math.abs(self.noseLightMode + 1));
		end;
		
	end;
end;

function NoseWorklights:updateTick(dt)

end

function NoseWorklights:attachImplement(implement)
	
	
end;

function NoseWorklights:draw()
	if self.isEntered then
		if self.helpPanel then	
			if self.noseLightMode == 0 then
				renderText(0.42, 0.98, 0.021, "Press 5: Turn Low Beam on");
			elseif self.noseLightMode == 1 then
				renderText(0.42, 0.98, 0.021, "Press 5: Turn High Beam on");
			elseif self.noseLightMode == 2 then
				renderText(0.42, 0.98, 0.021, "Press 5: Turn Nose Work Lights on");
			elseif self.noseLightMode == 3 then
				renderText(0.42, 0.98, 0.021, "Press 5: Turn Nose Lights off");
			elseif self.noseLightMode == 4 then
				renderText(0.42, 0.98, 0.021, "Press 5: Turn Low Beam on");
			end;
		end;
	end;
end;

function NoseWorklights:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function NoseWorklights:onLeave()
		self.BNworkLightActive = false;
		self.noseWorkLightActive = false;
		self.TNworkLightActive = false;
		self.noseLightMode = 0;
	end;

function NoseWorklights:setnoseAdditionalLights(noseAdditionalLights, noEventSend)
	noseAdditionalLightsEvent.sendEvent(self, noseAdditionalLights, noEventSend);

	self.noseLightMode = noseAdditionalLights;
	
	if self.noseLightMode == 0  then
		self.BNworkLightActive = false;
		self.TNworkLightActive = false;
		self.noseWorkLightActive = false;
	end;
	if self.noseLightMode == 1 then
		self.BNworkLightActive = true;
		self.TNworkLightActive = false;
		self.noseWorkLightActive = false;
	end;
	if self.noseLightMode == 2 then
		self.BNworkLightActive = false;
		self.TNworkLightActive = true;
		self.noseWorkLightActive = false;
	end;
	if self.noseLightMode == 3 then
		self.BNworkLightActive = false;
		self.TNworkLightActive = false;
		self.noseWorkLightActive = true;
	end;
	if self.noseLightMode == 4 then
		self.BNworkLightActive = false;
		self.TNworkLightActive = false;
		self.noseWorkLightActive = false;
	end;

	for i=1, self.numNoseWorkLights do
		setVisibility(self.noseWorkLights[i], self.noseWorkLightActive);
	end;
	
	for i=1, self.numBNWorkLights do
		setVisibility(self.BNworkLights[i], self.BNworkLightActive);
	end;
	for i=1, self.numTNWorkLights do
		setVisibility(self.TNworkLights[i], self.TNworkLightActive);
	end;
end;

noseAdditionalLightsEvent = {};
noseAdditionalLightsEvent_mt = Class(noseAdditionalLightsEvent, Event);

InitEventClass(noseAdditionalLightsEvent, "noseAdditionalLightsEvent");

function noseAdditionalLightsEvent:emptyNew()
    local self = Event:new(noseAdditionalLightsEvent_mt);
    self.className="noseAdditionalLightsEvent";
    return self;
end;

function noseAdditionalLightsEvent:new(vehicle, noseAdditionalLights)
    local self = noseAdditionalLightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.noseAdditionalLights = noseAdditionalLights;
    return self;
end;

function noseAdditionalLightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.noseAdditionalLights = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function noseAdditionalLightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.noseAdditionalLights);	
end;

function noseAdditionalLightsEvent:run(connection)
	self.vehicle:setnoseAdditionalLights(self.noseAdditionalLights, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(noseAdditionalLightsEvent:new(self.vehicle, self.noseAdditionalLights), nil, connection, self.object);
	end;
end;

function noseAdditionalLightsEvent.sendEvent(vehicle, noseAdditionalLights, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(noseAdditionalLightsEvent:new(vehicle, noseAdditionalLights), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(noseAdditionalLightsEvent:new(vehicle, noseAdditionalLights));
		end;
	end;
end;