--
-- JD_8530
-- Specialization class for John Deere 8530
--
-- @author  Mario
-- @date  24/08/2010
--
-- Copyright (C) Mario, All Rights Reserved.

JD_8530 = {};

function JD_8530.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD_8530:load(xmlFile)
	
	self.warn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.warn#index"));
	self.Parklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index"));
	self.Parklight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index2"));
	self.Parklight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Parklight#index3"));
	
	self.frontdualsupportActive = true;
	self.reardualsupportActive = true;
	self.saddletanksActive = false;
	self.wyc = 650;
	self.tankwarn = 100;
	self.ParklightActive = false;
	self.loaderframeActive = false;
	self.fendersActive = true;

	self.frontdualsupport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontdualsupport#index"));
	self.frontdualsupport2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontdualsupport#index2"));
	self.reardualsupport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reardualsupport#index"));
	self.reardualsupport2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reardualsupport#index2"));
	
	self.saddletanks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.saddletanks#index"));
	
	self.fenders = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fenders#index2"));
	
	self.loaderframe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.loaderframe#index"));
	
   
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	local rotationPartNodePedal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPedal#index"));
    if rotationPartNodePedal ~= nil then
        self.rotationPartPedal = {};
        self.rotationPartPedal.node = rotationPartNodePedal;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#minRot"));
        self.rotationPartPedal.minRot = {};
        self.rotationPartPedal.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#maxRot"));
        self.rotationPartPedal.maxRot = {};
        self.rotationPartPedal.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPedal.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#rotTime"), 2)*1000;
        self.rotationPartPedal.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#touchRotLimit"), 10));
    end;
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNodeAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartAttacher#index"));
    if translationPartNodeAttacher ~= nil then
        self.translationPartAttacher = {};
        self.translationPartAttacher.node = translationPartNodeAttacher;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#minTrans"));
        self.translationPartAttacher.minTrans = {};
        self.translationPartAttacher.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartAttacher.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartAttacher.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#maxTrans"));
        self.translationPartAttacher.maxTrans = {};
        self.translationPartAttacher.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartAttacher.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartAttacher.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartAttacher.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#transTime"), 2)*1000;
        self.translationPartAttacher.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#touchTransLimit"), 10);
    end;
	
	local rotationPartNodeAttacherPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#index"));
    if rotationPartNodeAttacherPart ~= nil then
        self.rotationPartAttacherPart = {};
        self.rotationPartAttacherPart.node = rotationPartNodeAttacherPart;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#minRot"));
        self.rotationPartAttacherPart.minRot = {};
        self.rotationPartAttacherPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacherPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacherPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#maxRot"));
        self.rotationPartAttacherPart.maxRot = {};
        self.rotationPartAttacherPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAttacherPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAttacherPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAttacherPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#rotTime"), 2)*1000;
        self.rotationPartAttacherPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#touchRotLimit"), 10));
    end;
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
	klaksonFile = Utils.getFilename("sounds/horn.wav", self.baseDirectory);
    self.klaksonId = createSample("klakson");
    loadSample(self.klaksonId, klaksonFile, false);
    self.klaksonPlaying = false;
	
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
	fuelwarningSoundFile = Utils.getFilename("sounds/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
	
	 ---------flashlights
	self.FlashLightLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index"));
	self.FlashLightLeft2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index2"));
	self.FlashLightLeft3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexl#index3"));
    self.FlashLightRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index"));	
	self.FlashLightRight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index2"));	
	self.FlashLightRight3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexr#index3"));		
	
    self.flashLightLeftActive = false;
    self.flashLightRightActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
   
    turnSoundFile = Utils.getFilename("turn.wav", self.baseDirectory);
    self.turnSoundId = createSample("turnSound");
    loadSample(self.turnSoundId, turnSoundFile, false);
	
end;

function JD_8530:delete()

end;

function JD_8530:mouseEvent(posX, posY, isDown, isUp, button)

end;

function JD_8530:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym == Input.KEY_f then
		self.ParklightActive = not self.ParklightActive;
	end;
	
	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
	
	if isDown and sym == Input.KEY_f3 then
		self.reardualsupportActive = not self.reardualsupportActive;
	end;
	
	if isDown and sym == Input.KEY_f2 then
		self.frontdualsupportActive = not self.frontdualsupportActive;
	end;
	
	if isDown and sym == Input.KEY_f4 then
		self.saddletanksActive = not self.saddletanksActive;
	end;
	
	if isDown and sym == Input.KEY_f5 then
		self.loaderframeActive = not self.loaderframeActive;
		self.fendersActive = not self.fendersActive;
	end;
	
	if isDown then
		if sym == Input.KEY_z then
			self.klaksonAllow = true;
		end;
	else
		self.klaksonAllow = false;
	end;
	
	if sym == Input.KEY_9 then
		self.translationMaxAttacher = isDown;
	end;
	if sym == Input.KEY_0 then
		self.translationMinAttacher = isDown;
	end;
	
	if isDown and sym == Input.KEY_g then
		self.chuj = not self.chuj;
	end;
	
	if isDown and sym == Input.KEY_v then
		if self.chuj then
			self.rotationMaxWajcha = true;
		else
			self.rotationMaxWajcha2 = true
		end;
	else
		self.rotationMaxWajcha = false;
		self.rotationMaxWajcha2 = false;
	end;
	
	if isDown and sym == Input.KEY_8 then
		self.LeftWorklightActive = not self.LeftWorklightActive;
	end;
	
	if isDown and sym == Input.KEY_9 then
		self.RightWorklightActive = not self.RightWorklightActive;
	end;
	
	---flashlights
	
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashLightRightActive = false;
	end;

	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashLightLeftActive = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashLightRightActive = false;
		self.flashLightLeftActive = false;
	end;

end;

function JD_8530:update(dt)
	if self.isEntered and Input.isKeyPressed(Input.KEY_w) then
		Utils.setEmittingState(self.dustParticleSystems, true);
	else
		Utils.setEmittingState(self.dustParticleSystems, false);
	end;

	if self.handbrake then
		self.rotationMaxReczny = true;
	else
		self.rotationMaxReczny = false;
	end;
	
	if Input.isKeyPressed(Input.KEY_0) then
		self.rotationMaxWajchaZaczep = true;
		self.rotationMaxWajchaZaczep2 = false;
	else
		self.rotationMaxWajchaZaczep = false;
	end;
	if Input.isKeyPressed(Input.KEY_9) then
		self.rotationMaxWajchaZaczep2 = true;
		self.rotationMaxWajchaZaczep = false;
	else
		self.rotationMaxWajchaZaczep2 = false;
	end;
	
	if self.isEntered then
		if self.attachedTrailer then
			self.rotationMaxAttacherPart = true;
			self.translationMax = true;
		else
			self.rotationMaxAttacherPart = false;
			self.translationMax = false;
		end;
	end;
	
	local doTranslate = self.translationMaxAttacher or self.translationMinAttacher
	if self.translationPartAttacher ~= nil and doTranslate then
		local x, y, z = getTranslation(self.translationPartAttacher.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartAttacher.maxTrans, self.translationPartAttacher.minTrans, 3, self.translationPartAttacher.transTime, dt, not self.translationMaxAttacher);
		setTranslation(self.translationPartAttacher.node, unpack(newTrans));
	end;
	
	if self.translationPart ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
	end;

	if self.rotationPartAttacherPart ~= nil then
		local x, y, z = getRotation(self.rotationPartAttacherPart.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartAttacherPart.maxRot, self.rotationPartAttacherPart.minRot, 3, self.rotationPartAttacherPart.rotTime, dt, not self.rotationMaxAttacherPart);
		setRotation(self.rotationPartAttacherPart.node, unpack(newRot));
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) then
			self.rotationMaxPedal = true;
		else
			self.rotationMaxPedal = false;
		end;
		if Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxBrake = true;
		else
			self.rotationMaxBrake = false;
		end;
		if self.gang0 then
			self.rotationMaxClutch = true;
		else
			self.rotationMaxClutch = false;
		end;
	end;
	
	if self.rotationPartPedal ~= nil then
		local x, y, z = getRotation(self.rotationPartPedal.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPedal.maxRot, self.rotationPartPedal.minRot, 3, self.rotationPartPedal.rotTime, dt, not self.rotationMaxPedal);
		setRotation(self.rotationPartPedal.node, unpack(newRot));
	end;

	setVisibility(self.warn, self.warnLightActive);
	setVisibility(self.frontdualsupport, self.frontdualsupportActive);
	setVisibility(self.frontdualsupport2, self.frontdualsupportActive);
	setVisibility(self.reardualsupport, self.reardualsupportActive);
	setVisibility(self.reardualsupport2, self.reardualsupportActive);
	setVisibility(self.saddletanks, self.saddletanksActive);
	setVisibility(self.Parklight, self.ParklightActive);
	setVisibility(self.Parklight2, self.ParklightActive);
	setVisibility(self.Parklight3, self.ParklightActive);
	setVisibility(self.loaderframe, self.loaderframeActive);
	setVisibility(self.fenders, self.fendersActive);
	setVisibility(self.fenders2, self.fendersActive);
	
	
	
	if self.klaksonAllow and not self.klaksonPlaying then
		playSample(self.klaksonId,0,1,0);
		self.klaksonPlaying = true;
	elseif not self.klaksonAllow and self.klaksonPlaying then
		stopSample(self.klaksonId);
		self.klaksonPlaying = false;
	end;
	
	if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
		end;
		
	--- flashLights

		if self.FlashLightLeft ~= nil then
				if self.flashLightLeftActive then
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft2, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft3, self.flashLightLeftActive);
					
			else
					setVisibility(self.FlashLightLeft, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft2, self.flashLightLeftActive);
					setVisibility(self.FlashLightLeft3, self.flashLightLeftActive);
			end;
			end;

		if self.FlashLightRight ~= nil then
				if self.FlashLightRightActive then
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
					setVisibility(self.FlashLightRight2, self.flashLightRightActive);
					setVisibility(self.FlashLightRight3, self.flashLightRightActive);
			else
					setVisibility(self.FlashLightRight, self.flashLightRightActive);
					setVisibility(self.FlashLightRight2, self.flashLightRightActive);
					setVisibility(self.FlashLightRight3, self.flashLightRightActive);
			end;
			end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashLightLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashLightLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashLightLeftActive = false;
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashLightRightActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashLightRightActive = false;
				end;
			end;
		end;

		if self.flash then
		
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashLightRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					
					self.flashLightRightActive = true;
					self.flashLightLeftActive = true;
					playSample(self.turnSoundId, 1, 0.7, 0);
					
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashLightRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
				
					self.flashLightLeftActive = false;
					self.flashLightRightActive = false;
				end;
			end;
			else
			
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashLightRightActive = false;
				self.flashLightLeftActive = false;
			end;
		end;
			
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashLightRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashLightLeftActive = false;
			end;
		end;
end;

function JD_8530:draw()
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.82, 0.22, 0.021, "Press 0: Info on");
		else
			renderText(0.82, 0.22, 0.021, "Press 0: Info off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.64, 0.023, "- John Deere 8R Info -");
			
			if self.flashLeft then
				renderText(0.02, 0.46, 0.021, "Press Num Pad 1: Left Turn Signal off");
			else
				renderText(0.02, 0.46, 0.021, "Press Num Pad 1: Left Turn Signal on");
			end;
			if self.flashRight then
				renderText(0.02, 0.50, 0.021, "Press Num Pad 3: Right Turn Signal off");
			else
				renderText(0.02, 0.50, 0.021, "Press Num Pad 3: Right Turn Signal on");
			end;
			if self.flash then
				renderText(0.02, 0.48, 0.021, "Press Num Pad 2: Hazards off");
			else
				renderText(0.02, 0.48, 0.021, "Press Num Pad 2: Hazards on");
			end;
			if self.rundumleuchtenAn then
				renderText(0.02, 0.52, 0.021, "Press Home: Warning Light off ");
			else
				renderText(0.02, 0.52, 0.021, "Press Home: Warning Light on");
			end;
			if self.ParklightActive then
				renderText(0.02, 0.54, 0.021, "Press F: Parking Lights off");
			else
				renderText(0.02, 0.54, 0.021, "Press F: Parking Lights on");
			end;
			if self.reardualsupportActive then
				renderText(0.02, 0.56, 0.021, "Press F3: Rear Wheel Support off");
			else
				renderText(0.02, 0.56, 0.021, "Press F3: Rear Wheel Support on");
			end;
			if self.frontdualsupportActive then
				renderText(0.02, 0.58, 0.021, "Press F2: Front Wheel Support off");
			else
				renderText(0.02, 0.58, 0.021, "Press F2: Front Wheel Support on");
			end;			
			if self.saddletanksActive then
				renderText(0.02, 0.60, 0.021, "Press F4: Saddle Tanks off");
			else
				renderText(0.02, 0.60, 0.021, "Press F4: Saddle Tanks on");
			end;
			if self.loaderframeActive then
				renderText(0.02, 0.62, 0.021, "Press F5: Loader attachment frame off");
			else
				renderText(0.02, 0.62, 0.021, "Press F5: Loader attachment frame on");
			end;
			renderText(0.02, 0.44, 0.021, "Press Z: horn");
			renderText(0.02, 0.40, 0.021, "Press insert/delete: Raise/lower 3 point Hitch");
			renderText(0.02, 0.38, 0.021, "Press [/]: angle up/angle down 3 point Hitch");
			renderText(0.02, 0.36, 0.021, "Press NUM Enter: start/stop motor");
		end;
	end;
end;

function JD_8530:onEnter()
	
end;

function JD_8530:onLeave()

end;
