
JDInnerWheelWeights = {};

function JDInnerWheelWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JDInnerWheelWeights:load(xmlFile)
	self.extrainnerwheelWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extrainnerwheelWeights#count"), 0);
    self.innerweights = {};
    for i=1, self.extrainnerwheelWeights do
        local innerweightnamei = string.format("vehicle.extrainnerwheelWeights.weight%d", i);
        self.innerweights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, innerweightnamei .. "#index"));
        setVisibility(self.innerweights[i], false);
    end;
	
	self.currentinnerWeight = 0;
	self.controlinnerWeight = 0;
	self.singleinnerWeight = 0;
	self.maxinnerWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxinnerWeight#weight"), 245);	
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function JDInnerWheelWeights:delete()
end;

function JDInnerWheelWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDInnerWheelWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function JDInnerWheelWeights:update(dt)
	if self.isEntered then
			self.singleinnerWeight = (self.maxinnerWeight / self.extrainnerwheelWeights);
	
			if InputBinding.hasEvent(InputBinding.WEIGHT_ADD_inner) then
				if self.currentinnerWeight >= self.maxinnerWeight then
					self.currentinnerWeight = 0;
				else
					self.currentinnerWeight = self.currentinnerWeight + self.singleinnerWeight;
				end;
			end;
		
			if self.innerweights ~= nil then
				if self.currentinnerWeight ~= self.controlinnerWeight then
					self.controlinnerWeight = self.currentinnerWeight;
			
					if self.currentinnerWeight > 0 then
						for i = 1, self.extrainnerwheelWeights do
							if i * self.singleinnerWeight <= self.currentinnerWeight then
								setVisibility(self.innerweights[i], true);
							end;
						end;
					else
						for i = 1, self.extrainnerwheelWeights do
							setVisibility(self.innerweights[i], false);
						end;
					end;
				end;
			end;
		if self.emptyinnerwheelMass == nil then
			self.emptyinnerwheelMass = getMass(self.components[2].node);
			self.currentinnerwheelMass = self.emptyinnerwheelMass;
		end;
		local newinnerwheelMass = self.emptyinnerwheelMass + (self.currentinnerWeight/2000);
		if newinnerwheelMass ~= self.currentinnerwheelMass then
			setMass(self.components[2].node, newMass);
			self.currentinnerwheelMass = newinnerwheelMass;
			for k,v in pairs(self.components) do
				if v.node == self.components[2].node then
					if v.centerOfMass ~= nil then
						setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
					end;
					break;
				end;
			end;
		end;
	end;
end;

function JDInnerWheelWeights:onLeave()
	
end;

function JDInnerWheelWeights:draw()
	if self.isEntered then
		if self.helpPanel then	
			renderText(0.42, 0.86, 0.021, "Add Inner Wheel Weights: " ..string.format("%d lbs", self.currentinnerWeight), InputBinding.WEIGHT_ADD_inner);			
		end;
	end;
end;

