--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


RightWorklights = {};

function RightWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) ;
end;

function RightWorklights:load(xmlFile)
   
	self.setrightAdditionalLights = SpecializationUtil.callSpecializationsFunction("setrightAdditionalLights");
	
	self.numRightWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rightWorkLights#count"), 0);
    self.rightWorkLights = {};
    for i=1, self.numRightWorkLights do
        local rightWorkLightsNamei = string.format("vehicle.rightWorkLights.rightWorkLight" .. "%d", i);
        self.rightWorkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, rightWorkLightsNamei .. "#index"));
        setVisibility(self.rightWorkLights[i], false);
    end;
	
	self.numRFWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RFworkLights#count"), 0);
    self.RFworkLights = {};
    for i=1, self.numRFWorkLights do
        local RFworkLightsNamei = string.format("vehicle.RFworkLights.RFworkLight" .. "%d", i);
        self.RFworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, RFworkLightsNamei .. "#index"));
        setVisibility(self.RFworkLights[i], false);
    end;
	
	self.numRRWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RRworkLights#count"), 0);
    self.RRworkLights = {};
    for i=1, self.numRRWorkLights do
        local RRworkLightsNamei = string.format("vehicle.RRworkLights.RRworkLight" .. "%d", i);
        self.RRworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, RRworkLightsNamei .. "#index"));
        setVisibility(self.RRworkLights[i], false);
    end;
		
	self.rightLightMode = 0;
	self.RFworkLightActive = false;
	self.rightWorkLightActive = false;
	self.RRworkLightActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function RightWorklights:delete()
	
end;

function RightWorklights:readStream(streamId, connection)
	self:setrightAdditionalLights(streamReadInt8(streamId), true);
end;

function RightWorklights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.rightLightMode);	
end;

function RightWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RightWorklights:keyEvent(unicode, sym, modifier, isDown)
	
end;

function RightWorklights:update(dt)

    if self:getIsActiveForInput() and self.isClient then	
		if InputBinding.hasEvent(InputBinding.JDRIGHTWORKSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
				if self.rightLightMode >= 4 then
				self.rightLightMode = 0;
				end;
			self:setrightAdditionalLights(math.abs(self.rightLightMode + 1));
		end;
		
	end;
end;

function RightWorklights:updateTick(dt)

end

function RightWorklights:attachImplement(implement)
	
	
end;

function RightWorklights:draw()
	if self.isEntered then
		if self.helpPanel then	
			if self.rightLightMode == 0 then
				renderText(0.42, 0.90, 0.021, "Press 9: Turn Right Front Cab Work Light on");
			elseif self.rightLightMode == 1 then
				renderText(0.42, 0.90, 0.021, "Press 9: Turn Right Rear Cab Work Light on");
			elseif self.rightLightMode == 2 then
				renderText(0.42, 0.90, 0.021, "Press 9: Turn Right Cab Work Lights on");
			elseif self.rightLightMode == 3 then
				renderText(0.42, 0.90, 0.021, "Press 9: Turn Right Cab Work Lights off");
			elseif self.rightLightMode == 4 then
				renderText(0.42, 0.90, 0.021, "Press 9: Turn Right Front Cab Work Light on");
			end;
		end;
	end;
end;

function RightWorklights:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function RightWorklights:onLeave()
		self.RFworkLightActive = false;
		self.rightWorkLightActive = false;
		self.RRworkLightActive = false;
		self.rightLightMode = 0;
	end;

function RightWorklights:setrightAdditionalLights(rightAdditionalLights, noEventSend)
	rightAdditionalLightsEvent.sendEvent(self, rightAdditionalLights, noEventSend);

	self.rightLightMode = rightAdditionalLights;
	
	if self.rightLightMode == 0  then
		self.RFworkLightActive = false;
		self.RRworkLightActive = false;
		self.rightWorkLightActive = false;
	end;
	if self.rightLightMode == 1 then
		self.RFworkLightActive = true;
		self.RRworkLightActive = false;
		self.rightWorkLightActive = false;
	end;
	if self.rightLightMode == 2 then
		self.RFworkLightActive = false;
		self.RRworkLightActive = true;
		self.rightWorkLightActive = false;
	end;
	if self.rightLightMode == 3 then
		self.RFworkLightActive = false;
		self.RRworkLightActive = false;
		self.rightWorkLightActive = true;
	end;
	if self.rightLightMode == 4 then
		self.RFworkLightActive = false;
		self.RRworkLightActive = false;
		self.rightWorkLightActive = false;
	end;

	for i=1, self.numRightWorkLights do
		setVisibility(self.rightWorkLights[i], self.rightWorkLightActive);
	end;
	
	for i=1, self.numRFWorkLights do
		setVisibility(self.RFworkLights[i], self.RFworkLightActive);
	end;
	for i=1, self.numRRWorkLights do
		setVisibility(self.RRworkLights[i], self.RRworkLightActive);
	end;
end;

rightAdditionalLightsEvent = {};
rightAdditionalLightsEvent_mt = Class(rightAdditionalLightsEvent, Event);

InitEventClass(rightAdditionalLightsEvent, "rightAdditionalLightsEvent");

function rightAdditionalLightsEvent:emptyNew()
    local self = Event:new(rightAdditionalLightsEvent_mt);
    self.className="rightAdditionalLightsEvent";
    return self;
end;

function rightAdditionalLightsEvent:new(vehicle, rightAdditionalLights)
    local self = rightAdditionalLightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.rightAdditionalLights = rightAdditionalLights;
    return self;
end;

function rightAdditionalLightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rightAdditionalLights = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function rightAdditionalLightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.rightAdditionalLights);	
end;

function rightAdditionalLightsEvent:run(connection)
	self.vehicle:setrightAdditionalLights(self.rightAdditionalLights, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(rightAdditionalLightsEvent:new(self.vehicle, self.rightAdditionalLights), nil, connection, self.object);
	end;
end;

function rightAdditionalLightsEvent.sendEvent(vehicle, rightAdditionalLights, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(rightAdditionalLightsEvent:new(vehicle, rightAdditionalLights), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(rightAdditionalLightsEvent:new(vehicle, rightAdditionalLights));
		end;
	end;
end;