--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


RearWorklights = {};

function RearWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) ;
end;

function RearWorklights:load(xmlFile)
   
	self.setrearAdditionalLights = SpecializationUtil.callSpecializationsFunction("setrearAdditionalLights");
	
	self.numRearWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rearWorkLights#count"), 0);
    self.rearWorkLights = {};
    for i=1, self.numRearWorkLights do
        local rearWorkLightsNamei = string.format("vehicle.rearWorkLights.rearWorkLight" .. "%d", i);
        self.rearWorkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, rearWorkLightsNamei .. "#index"));
        setVisibility(self.rearWorkLights[i], false);
    end;
	
	self.numBRWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.BRworkLights#count"), 0);
    self.BRworkLights = {};
    for i=1, self.numBRWorkLights do
        local BRworkLightsNamei = string.format("vehicle.BRworkLights.BRworkLight" .. "%d", i);
        self.BRworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, BRworkLightsNamei .. "#index"));
        setVisibility(self.BRworkLights[i], false);
    end;
	
	self.numTRWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TRworkLights#count"), 0);
    self.TRworkLights = {};
    for i=1, self.numTRWorkLights do
        local TRworkLightsNamei = string.format("vehicle.TRworkLights.TRworkLight" .. "%d", i);
        self.TRworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, TRworkLightsNamei .. "#index"));
        setVisibility(self.TRworkLights[i], false);
    end;
		
	self.rearLightMode = 0;
	self.BRworkLightActive = false;
	self.rearWorkLightActive = false;
	self.TRworkLightActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function RearWorklights:delete()
	
end;

function RearWorklights:readStream(streamId, connection)
	self:setrearAdditionalLights(streamReadInt8(streamId), true);
end;

function RearWorklights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.rearLightMode);	
end;

function RearWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RearWorklights:keyEvent(unicode, sym, modifier, isDown)
	
end;

function RearWorklights:update(dt)

    if self:getIsActiveForInput() and self.isClient then	
		if InputBinding.hasEvent(InputBinding.JDREARWORKSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
				if self.rearLightMode >= 4 then
				self.rearLightMode = 0;
				end;
			self:setrearAdditionalLights(math.abs(self.rearLightMode + 1));
		end;
		
	end;
end;

function RearWorklights:updateTick(dt)

end

function RearWorklights:attachImplement(implement)
	
	
end;

function RearWorklights:draw()
	if self.isEntered then
		if self.helpPanel then	
			if self.rearLightMode == 0 then
				renderText(0.42, 0.94, 0.021, "Press 7: Turn Rear Fender Lights on");
			elseif self.rearLightMode == 1 then
				renderText(0.42, 0.94, 0.021, "Press 7: Turn Rear Cab Lights on");
			elseif self.rearLightMode == 2 then
				renderText(0.42, 0.94, 0.021, "Press 7: Turn Rear Fender and Cab Lights on");
			elseif self.rearLightMode == 3 then
				renderText(0.42, 0.94, 0.021, "Press 7: Turn Rear Work Lights off");
			elseif self.rearLightMode == 4 then
				renderText(0.42, 0.94, 0.021, "Press 7: Turn Rear Fender Lights on");
			end;
		end;
	end;
end;

function RearWorklights:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function RearWorklights:onLeave()
		self.BRworkLightActive = false;
		self.rearWorkLightActive = false;
		self.TRworkLightActive = false;
		self.rearLightMode = 0;
	end;

function RearWorklights:setrearAdditionalLights(rearAdditionalLights, noEventSend)
	rearAdditionalLightsEvent.sendEvent(self, rearAdditionalLights, noEventSend);

	self.rearLightMode = rearAdditionalLights;
	
	if self.rearLightMode == 0  then
		self.BRworkLightActive = false;
		self.TRworkLightActive = false;
		self.rearWorkLightActive = false;
	end;
	if self.rearLightMode == 1 then
		self.BRworkLightActive = true;
		self.TRworkLightActive = false;
		self.rearWorkLightActive = false;
	end;
	if self.rearLightMode == 2 then
		self.BRworkLightActive = false;
		self.TRworkLightActive = true;
		self.rearWorkLightActive = false;
	end;
	if self.rearLightMode == 3 then
		self.BRworkLightActive = false;
		self.TRworkLightActive = false;
		self.rearWorkLightActive = true;
	end;
	if self.rearLightMode == 4 then
		self.BRworkLightActive = false;
		self.TRworkLightActive = false;
		self.rearWorkLightActive = false;
	end;

	for i=1, self.numRearWorkLights do
		setVisibility(self.rearWorkLights[i], self.rearWorkLightActive);
	end;
	
	for i=1, self.numBRWorkLights do
		setVisibility(self.BRworkLights[i], self.BRworkLightActive);
	end;
	for i=1, self.numTRWorkLights do
		setVisibility(self.TRworkLights[i], self.TRworkLightActive);
	end;
end;

rearAdditionalLightsEvent = {};
rearAdditionalLightsEvent_mt = Class(rearAdditionalLightsEvent, Event);

InitEventClass(rearAdditionalLightsEvent, "rearAdditionalLightsEvent");

function rearAdditionalLightsEvent:emptyNew()
    local self = Event:new(rearAdditionalLightsEvent_mt);
    self.className="rearAdditionalLightsEvent";
    return self;
end;

function rearAdditionalLightsEvent:new(vehicle, rearAdditionalLights)
    local self = rearAdditionalLightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.rearAdditionalLights = rearAdditionalLights;
    return self;
end;

function rearAdditionalLightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rearAdditionalLights = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function rearAdditionalLightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.rearAdditionalLights);	
end;

function rearAdditionalLightsEvent:run(connection)
	self.vehicle:setrearAdditionalLights(self.rearAdditionalLights, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(rearAdditionalLightsEvent:new(self.vehicle, self.rearAdditionalLights), nil, connection, self.object);
	end;
end;

function rearAdditionalLightsEvent.sendEvent(vehicle, rearAdditionalLights, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(rearAdditionalLightsEvent:new(vehicle, rearAdditionalLights), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(rearAdditionalLightsEvent:new(vehicle, rearAdditionalLights));
		end;
	end;
end;