--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


LeftWorklights = {};

function LeftWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) ;
end;

function LeftWorklights:load(xmlFile)
   
	self.setleftAdditionalLights = SpecializationUtil.callSpecializationsFunction("setleftAdditionalLights");
	
	self.numLeftWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.leftWorkLights#count"), 0);
    self.leftWorkLights = {};
    for i=1, self.numLeftWorkLights do
        local leftWorkLightsNamei = string.format("vehicle.leftWorkLights.leftWorkLight" .. "%d", i);
        self.leftWorkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, leftWorkLightsNamei .. "#index"));
        setVisibility(self.leftWorkLights[i], false);
    end;
	
	self.numLFWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.LFworkLights#count"), 0);
    self.LFworkLights = {};
    for i=1, self.numLFWorkLights do
        local LFworkLightsNamei = string.format("vehicle.LFworkLights.LFworkLight" .. "%d", i);
        self.LFworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, LFworkLightsNamei .. "#index"));
        setVisibility(self.LFworkLights[i], false);
    end;
	
	self.numLRWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.LRworkLights#count"), 0);
    self.LRworkLights = {};
    for i=1, self.numLRWorkLights do
        local LRworkLightsNamei = string.format("vehicle.LRworkLights.LRworkLight" .. "%d", i);
        self.LRworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, LRworkLightsNamei .. "#index"));
        setVisibility(self.LRworkLights[i], false);
    end;
		
	self.leftLightMode = 0;
	self.LFworkLightActive = false;
	self.leftWorkLightActive = false;
	self.LRworkLightActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function LeftWorklights:delete()
	
end;

function LeftWorklights:readStream(streamId, connection)
	self:setleftAdditionalLights(streamReadInt8(streamId), true);
end;

function LeftWorklights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.leftLightMode);	
end;

function LeftWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LeftWorklights:keyEvent(unicode, sym, modifier, isDown)
	
end;

function LeftWorklights:update(dt)

    if self:getIsActiveForInput() and self.isClient then	
		if InputBinding.hasEvent(InputBinding.JDLEFTWORKSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
				if self.leftLightMode >= 4 then
				self.leftLightMode = 0;
				end;
			self:setleftAdditionalLights(math.abs(self.leftLightMode + 1));
		end;
		
	end;
end;

function LeftWorklights:updateTick(dt)

end

function LeftWorklights:attachImplement(implement)
	
	
end;

function LeftWorklights:draw()
	if self.isEntered then
		if self.helpPanel then	
			if self.leftLightMode == 0 then
				renderText(0.42, 0.92, 0.021, "Press 8: Turn Left Front Cab Work Light on");
			elseif self.leftLightMode == 1 then
				renderText(0.42, 0.92, 0.021, "Press 8: Turn Left Rear Cab Work Light on");
			elseif self.leftLightMode == 2 then
				renderText(0.42, 0.92, 0.021, "Press 8: Turn Left Cab Work Lights on");
			elseif self.leftLightMode == 3 then
				renderText(0.42, 0.92, 0.021, "Press 8: Turn Left Cab Work Lights off");
			elseif self.leftLightMode == 4 then
				renderText(0.42, 0.92, 0.021, "Press 8: Turn Left Front Cab Work Light on");
			end;
		end;
	end;
end;

function LeftWorklights:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function LeftWorklights:onLeave()
		self.LFworkLightActive = false;
		self.leftWorkLightActive = false;
		self.LRworkLightActive = false;
		self.leftLightMode = 0;
	end;

function LeftWorklights:setleftAdditionalLights(leftAdditionalLights, noEventSend)
	leftAdditionalLightsEvent.sendEvent(self, leftAdditionalLights, noEventSend);

	self.leftLightMode = leftAdditionalLights;
	
	if self.leftLightMode == 0  then
		self.LFworkLightActive = false;
		self.LRworkLightActive = false;
		self.leftWorkLightActive = false;
	end;
	if self.leftLightMode == 1 then
		self.LFworkLightActive = true;
		self.LRworkLightActive = false;
		self.leftWorkLightActive = false;
	end;
	if self.leftLightMode == 2 then
		self.LFworkLightActive = false;
		self.LRworkLightActive = true;
		self.leftWorkLightActive = false;
	end;
	if self.leftLightMode == 3 then
		self.LFworkLightActive = false;
		self.LRworkLightActive = false;
		self.leftWorkLightActive = true;
	end;
	if self.leftLightMode == 4 then
		self.LFworkLightActive = false;
		self.LRworkLightActive = false;
		self.leftWorkLightActive = false;
	end;

	for i=1, self.numLeftWorkLights do
		setVisibility(self.leftWorkLights[i], self.leftWorkLightActive);
	end;
	
	for i=1, self.numLFWorkLights do
		setVisibility(self.LFworkLights[i], self.LFworkLightActive);
	end;
	for i=1, self.numLRWorkLights do
		setVisibility(self.LRworkLights[i], self.LRworkLightActive);
	end;
end;

leftAdditionalLightsEvent = {};
leftAdditionalLightsEvent_mt = Class(leftAdditionalLightsEvent, Event);

InitEventClass(leftAdditionalLightsEvent, "leftAdditionalLightsEvent");

function leftAdditionalLightsEvent:emptyNew()
    local self = Event:new(leftAdditionalLightsEvent_mt);
    self.className="leftAdditionalLightsEvent";
    return self;
end;

function leftAdditionalLightsEvent:new(vehicle, leftAdditionalLights)
    local self = leftAdditionalLightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.leftAdditionalLights = leftAdditionalLights;
    return self;
end;

function leftAdditionalLightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.leftAdditionalLights = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function leftAdditionalLightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.leftAdditionalLights);	
end;

function leftAdditionalLightsEvent:run(connection)
	self.vehicle:setleftAdditionalLights(self.leftAdditionalLights, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(leftAdditionalLightsEvent:new(self.vehicle, self.leftAdditionalLights), nil, connection, self.object);
	end;
end;

function leftAdditionalLightsEvent.sendEvent(vehicle, leftAdditionalLights, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(leftAdditionalLightsEvent:new(vehicle, leftAdditionalLights), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(leftAdditionalLightsEvent:new(vehicle, leftAdditionalLights));
		end;
	end;
end;