
JDWheelWeights = {};

function JDWheelWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JDWheelWeights:load(xmlFile)
	self.extrawheelWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extrawheelWeights#count"), 0);
    self.weights = {};
    for i=1, self.extrawheelWeights do
        local weightnamei = string.format("vehicle.extrawheelWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 245);
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function JDWheelWeights:delete()
end;

function JDWheelWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDWheelWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function JDWheelWeights:update(dt)
	if self.isEntered then
			self.singleWeight = (self.maxWeight / self.extrawheelWeights);
	
			if InputBinding.hasEvent(InputBinding.WEIGHT_ADD_outer) then
				if self.currentWeight >= self.maxWeight then
					self.currentWeight = 0;
				else
					self.currentWeight = self.currentWeight + self.singleWeight;
				end;
			end;
		
			if self.weights ~= nil then
				if self.currentWeight ~= self.controlWeight then
					self.controlWeight = self.currentWeight;
			
					if self.currentWeight > 0 then
						for i = 1, self.extrawheelWeights do
							if i * self.singleWeight <= self.currentWeight then
								setVisibility(self.weights[i], true);
							end;
						end;
					else
						for i = 1, self.extrawheelWeights do
							setVisibility(self.weights[i], false);
						end;
					end;
				end;
			end;
		if self.emptywheelMass == nil then
			self.emptywheelMass = getMass(self.components[2].node);
			self.currentwheelMass = self.emptywheelMass;
		end;
		local newwheelMass = self.emptywheelMass + (self.currentWeight/2000);
		if newwheelMass ~= self.currentwheelMass then
			setMass(self.components[2].node, newMass);
			self.currentwheelMass = newwheelMass;
			for k,v in pairs(self.components) do
				if v.node == self.components[2].node then
					if v.centerOfMass ~= nil then
						setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
					end;
					break;
				end;
			end;
		end;
	end;
end;

function JDWheelWeights:onLeave()
	
end;

function JDWheelWeights:draw()
if self.isEntered then
		if self.helpPanel then	
			renderText(0.42, 0.84, 0.021, "Add Outer Wheel Weights: " ..string.format("%d lbs", self.currentWeight), InputBinding.WEIGHT_ADD_outer);			
		end;
	end;
end;

