--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info


FrontWorklights = {};

function FrontWorklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations) ;
end;

function FrontWorklights:load(xmlFile)
   
	self.setAdditionalLights = SpecializationUtil.callSpecializationsFunction("setAdditionalLights");
	
	self.numFrontWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontWorkLights#count"), 0);
    self.frontWorkLights = {};
    for i=1, self.numFrontWorkLights do
        local frontWorkLightsNamei = string.format("vehicle.frontWorkLights.frontWorkLight" .. "%d", i);
        self.frontWorkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontWorkLightsNamei .. "#index"));
        setVisibility(self.frontWorkLights[i], false);
    end;
	
	self.numBFWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.BFworkLights#count"), 0);
    self.BFworkLights = {};
    for i=1, self.numBFWorkLights do
        local BFworkLightsNamei = string.format("vehicle.BFworkLights.BFworkLight" .. "%d", i);
        self.BFworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, BFworkLightsNamei .. "#index"));
        setVisibility(self.BFworkLights[i], false);
    end;
	
	self.numTFWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TFworkLights#count"), 0);
    self.TFworkLights = {};
    for i=1, self.numTFWorkLights do
        local TFworkLightsNamei = string.format("vehicle.TFworkLights.TFworkLight" .. "%d", i);
        self.TFworkLights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, TFworkLightsNamei .. "#index"));
        setVisibility(self.TFworkLights[i], false);
    end;
		
	self.frontLightMode = 0;
	self.BFworkLightActive = false;
	self.frontWorkLightActive = false;
	self.TFworkLightActive = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function FrontWorklights:delete()
	
end;

function FrontWorklights:readStream(streamId, connection)
	self:setAdditionalLights(streamReadInt8(streamId), true);
end;

function FrontWorklights:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.frontLightMode);	
end;

function FrontWorklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FrontWorklights:keyEvent(unicode, sym, modifier, isDown)
	
end;

function FrontWorklights:update(dt)

    if self:getIsActiveForInput() and self.isClient then	
		if InputBinding.hasEvent(InputBinding.JDFRONTWORKSPOTS) then
              if (not self.toggleLightsSound) then
                  self.toggleLightsSound = createSample("toggleLightsSound");
                  loadSample(self.toggleLightsSound, "dataS2/sounds/switchFlashlight.wav", false);
                  setSamplePitch(self.toggleLightsSound, 0.5);
              end;
              playSample(self.toggleLightsSound, 1, 1.0, 0);
				if self.frontLightMode >= 4 then
				self.frontLightMode = 0;
				end;
			self:setAdditionalLights(math.abs(self.frontLightMode + 1));
		end;
		
	end;
end;

function FrontWorklights:updateTick(dt)

end

function FrontWorklights:attachImplement(implement)
	
	
end;

function FrontWorklights:draw()
	if self.isEntered then
		if self.helpPanel then	
			if self.frontLightMode == 0 then
				renderText(0.42, 0.96, 0.021, "Press 6: Turn Front Waist Lights on");
			elseif self.frontLightMode == 1 then
				renderText(0.42, 0.96, 0.021, "Press 6: Turn Front Cab Lights on");
			elseif self.frontLightMode == 2 then
				renderText(0.42, 0.96, 0.021, "Press 6: Turn Front Cab and Waist Lights on");
			elseif self.frontLightMode == 3 then
				renderText(0.42, 0.96, 0.021, "Press 6: Turn Front Work Lights off");
			elseif self.frontLightMode == 4 then
				renderText(0.42, 0.96, 0.021, "Press 6: Turn Front Waist Lights on");
			end;
		end;
	end;
end;

function FrontWorklights:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function FrontWorklights:onLeave()
		self.BFworkLightActive = false;
		self.frontWorkLightActive = false;
		self.TFworkLightActive = false;
		self.frontLightMode = 0;
	end;

function FrontWorklights:setAdditionalLights(additionallights, noEventSend)
	AdditionalLightsEvent.sendEvent(self, additionallights, noEventSend);

	self.frontLightMode = additionallights;
	
	if self.frontLightMode == 0  then
		self.BFworkLightActive = false;
		self.TFworkLightActive = false;
		self.frontWorkLightActive = false;
	end;
	if self.frontLightMode == 1 then
		self.BFworkLightActive = true;
		self.TFworkLightActive = false;
		self.frontWorkLightActive = false;
	end;
	if self.frontLightMode == 2 then
		self.BFworkLightActive = false;
		self.TFworkLightActive = true;
		self.frontWorkLightActive = false;
	end;
	if self.frontLightMode == 3 then
		self.BFworkLightActive = false;
		self.TFworkLightActive = false;
		self.frontWorkLightActive = true;
	end;
	if self.frontLightMode == 4 then
		self.BFworkLightActive = false;
		self.TFworkLightActive = false;
		self.frontWorkLightActive = false;
	end;

	for i=1, self.numFrontWorkLights do
		setVisibility(self.frontWorkLights[i], self.frontWorkLightActive);
	end;
	
	for i=1, self.numBFWorkLights do
		setVisibility(self.BFworkLights[i], self.BFworkLightActive);
	end;
	for i=1, self.numTFWorkLights do
		setVisibility(self.TFworkLights[i], self.TFworkLightActive);
	end;
end;

AdditionalLightsEvent = {};
AdditionalLightsEvent_mt = Class(AdditionalLightsEvent, Event);

InitEventClass(AdditionalLightsEvent, "AdditionalLightsEvent");

function AdditionalLightsEvent:emptyNew()
    local self = Event:new(AdditionalLightsEvent_mt);
    self.className="AdditionalLightsEvent";
    return self;
end;

function AdditionalLightsEvent:new(vehicle, additionallights)
    local self = AdditionalLightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.additionallights = additionallights;
    return self;
end;

function AdditionalLightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.additionallights = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function AdditionalLightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.additionallights);	
end;

function AdditionalLightsEvent:run(connection)
	self.vehicle:setAdditionalLights(self.additionallights, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(AdditionalLightsEvent:new(self.vehicle, self.additionallights), nil, connection, self.object);
	end;
end;

function AdditionalLightsEvent.sendEvent(vehicle, additionallights, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AdditionalLightsEvent:new(vehicle, additionallights), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AdditionalLightsEvent:new(vehicle, additionallights));
		end;
	end;
end;