

--Author: jrbrown  Hiropemonkey@aol.com

FrontThreePointHitch = {}

function FrontThreePointHitch.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function FrontThreePointHitch:load(xmlFile)
    
    local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart1#index"));
    if rotationNode1 ~= nil then
        self.rotationFrontPart1 = {};
        self.rotationFrontPart1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart1#minRot"));
        self.rotationFrontPart1.minRot = {};
        self.rotationFrontPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart1#maxRot"));
        self.rotationFrontPart1.maxRot = {};
        self.rotationFrontPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart1#rotTime"), 2)*1000;
        self.rotationFrontPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart2#index"));
    if rotationNode2 ~= nil then
        self.rotationFrontPart2 = {};
        self.rotationFrontPart2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart2#minRot"));
        self.rotationFrontPart2.minRot = {};
        self.rotationFrontPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart2#maxRot"));
        self.rotationFrontPart2.maxRot = {};
        self.rotationFrontPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart2#rotTime"), 2)*1000;
        self.rotationFrontPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart2#touchRotLimit"), 10));
    end;
	
	local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart3#index"));
    if rotationNode3 ~= nil then
        self.rotationFrontPart3 = {};
        self.rotationFrontPart3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart3#minRot"));
        self.rotationFrontPart3.minRot = {};
        self.rotationFrontPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart3#maxRot"));
        self.rotationFrontPart3.maxRot = {};
        self.rotationFrontPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart3#rotTime"), 2)*1000;
        self.rotationFrontPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart3#touchRotLimit"), 10));
    end;
	
	local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart4#index"));
    if rotationNode4 ~= nil then
        self.rotationFrontPart4 = {};
        self.rotationFrontPart4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart4#minRot"));
        self.rotationFrontPart4.minRot = {};
        self.rotationFrontPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart4#maxRot"));
        self.rotationFrontPart4.maxRot = {};
        self.rotationFrontPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart4#rotTime"), 2)*1000;
        self.rotationFrontPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart4#touchRotLimit"), 10));
    end;
	
	local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart5#index"));
    if rotationNode5 ~= nil then
        self.rotationFrontPart5 = {};
        self.rotationFrontPart5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart5#minRot"));
        self.rotationFrontPart5.minRot = {};
        self.rotationFrontPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart5#maxRot"));
        self.rotationFrontPart5.maxRot = {};
        self.rotationFrontPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart5#rotTime"), 2)*1000;
        self.rotationFrontPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart5#touchRotLimit"), 10));
    end;
	
	local rotationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart6#index"));
    if rotationNode6 ~= nil then
        self.rotationFrontPart6 = {};
        self.rotationFrontPart6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart6#minRot"));
        self.rotationFrontPart6.minRot = {};
        self.rotationFrontPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart6#maxRot"));
        self.rotationFrontPart6.maxRot = {};
        self.rotationFrontPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart6#rotTime"), 2)*1000;
        self.rotationFrontPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart6#touchRotLimit"), 10));
    end;
	
	local rotationNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart7#index"));
    if rotationNode7 ~= nil then
        self.rotationFrontPart7 = {};
        self.rotationFrontPart7.node = rotationNode7;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart7#minRot"));
        self.rotationFrontPart7.minRot = {};
        self.rotationFrontPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart7#maxRot"));
        self.rotationFrontPart7.maxRot = {};
        self.rotationFrontPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart7#rotTime"), 2)*1000;
        self.rotationFrontPart7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart7#touchRotLimit"), 10));
    end;
	
	local rotationNode8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationFrontPart8#index"));
    if rotationNode8 ~= nil then
        self.rotationFrontPart8 = {};
        self.rotationFrontPart8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart8#minRot"));
        self.rotationFrontPart8.minRot = {};
        self.rotationFrontPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationFrontPart8#maxRot"));
        self.rotationFrontPart8.maxRot = {};
        self.rotationFrontPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFrontPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFrontPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationFrontPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart8#rotTime"), 2)*1000;
        self.rotationFrontPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationFrontPart8#touchRotLimit"), 10));
    end;
	
	local munkahengerFrontNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahengerFront#index"));
    if munkahengerFrontNode ~= nil then
        self.munkahengerFront = {};
        self.munkahengerFront.node = munkahengerFrontNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront#minTrans"));
        self.munkahengerFront.minTrans = {};
        self.munkahengerFront.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront#maxTrans"));
        self.munkahengerFront.maxTrans = {};
        self.munkahengerFront.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahengerFront.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront#transTime"), 2)*1000;
        self.munkahengerFront.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront#touchTransLimit"), 10);
    end;
	local munkahengerFront2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahengerFront2#index"));
    if munkahengerFront2Node ~= nil then
        self.munkahengerFront2 = {};
        self.munkahengerFront2.node = munkahengerFront2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront2#minTrans"));
        self.munkahengerFront2.minTrans = {};
        self.munkahengerFront2.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront2.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront2#maxTrans"));
        self.munkahengerFront2.maxTrans = {};
        self.munkahengerFront2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahengerFront2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront2#transTime"), 2)*1000;
        self.munkahengerFront2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront2#touchTransLimit"), 10);
    end;
	local munkahengerFront3Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahengerFront3#index"));
    if munkahengerFront3Node ~= nil then
        self.munkahengerFront3 = {};
        self.munkahengerFront3.node = munkahengerFront3Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront3#minTrans"));
        self.munkahengerFront3.minTrans = {};
        self.munkahengerFront3.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront3.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahengerFront3#maxTrans"));
        self.munkahengerFront3.maxTrans = {};
        self.munkahengerFront3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahengerFront3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahengerFront3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.munkahengerFront3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront3#transTime"), 2)*1000;
        self.munkahengerFront3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahengerFront3#touchTransLimit"), 10);
    end;
 	
end;
      
function FrontThreePointHitch:delete()

end;

function FrontThreePointHitch:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function FrontThreePointHitch:keyEvent(unicode, sym, modifier, isDown)
	if sym == Input.KEY_n then
		self.rotationFrontPart1Min = isDown;
		self.rotationFrontPart2Min = isDown;
		self.rotationFrontPart3Min = isDown;
		self.rotationFrontPart4Min = isDown;
		self.rotationFrontPart5Min = isDown;
		self.rotationFrontPart6Min = isDown;
		self.munkahengerFrontMin = isDown;
		self.munkahengerFront2Min = isDown;
	end;
	if sym == Input.KEY_j then
		self.rotationFrontPart1Max = isDown;
		self.rotationFrontPart2Max = isDown;
		self.rotationFrontPart3Max = isDown;
		self.rotationFrontPart4Max = isDown;
		self.rotationFrontPart5Max = isDown;
		self.rotationFrontPart6Max = isDown;
		self.munkahengerFrontMax = isDown;
		self.munkahengerFront2Max = isDown;
	end;
	if sym == Input.KEY_k then
		self.rotationFrontPart7Min = isDown;
		self.rotationFrontPart8Min = isDown;
		self.munkahengerFront3Min = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotationFrontPart7Max = isDown;
		self.rotationFrontPart8Max = isDown;
		self.munkahengerFront3Max = isDown;
	end;
end;


function FrontThreePointHitch:update(dt)

	local doTranslate = self.munkahengerFrontMax or self.munkahengerFrontMin 
	if self.munkahengerFront ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahengerFront.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahengerFront.maxTrans, self.munkahengerFront.minTrans, 3, self.munkahengerFront.transTime, dt, not self.munkahengerFrontMax); 
		setTranslation(self.munkahengerFront.node, unpack(newTrans)); 
	end; 
	
	local doTranslate = self.munkahengerFront2Max or self.munkahengerFront2Min 
	if self.munkahengerFront2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahengerFront2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahengerFront2.maxTrans, self.munkahengerFront2.minTrans, 3, self.munkahengerFront2.transTime, dt, not self.munkahengerFront2Max); 
		setTranslation(self.munkahengerFront2.node, unpack(newTrans)); 
	end; 
	
	local doTranslate = self.munkahengerFront3Max or self.munkahengerFront3Min 
	if self.munkahengerFront3 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.munkahengerFront3.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.munkahengerFront3.maxTrans, self.munkahengerFront3.minTrans, 3, self.munkahengerFront3.transTime, dt, not self.munkahengerFront3Max); 
		setTranslation(self.munkahengerFront3.node, unpack(newTrans)); 
	end; 
	
	local doRotate = self.rotationFrontPart1Max or self.rotationFrontPart1Min 
	if self.rotationFrontPart1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart1.maxRot, self.rotationFrontPart1.minRot, 3, self.rotationFrontPart1.rotTime, dt, not self.rotationFrontPart1Max);
        setRotation(self.rotationFrontPart1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart2Max or self.rotationFrontPart2Min 
	if self.rotationFrontPart2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart2.maxRot, self.rotationFrontPart2.minRot, 3, self.rotationFrontPart2.rotTime, dt, not self.rotationFrontPart2Max);
        setRotation(self.rotationFrontPart2.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart3Max or self.rotationFrontPart3Min 
	if self.rotationFrontPart3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart3.maxRot, self.rotationFrontPart3.minRot, 3, self.rotationFrontPart3.rotTime, dt, not self.rotationFrontPart3Max);
        setRotation(self.rotationFrontPart3.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart4Max or self.rotationFrontPart4Min 
	if self.rotationFrontPart4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart4.maxRot, self.rotationFrontPart4.minRot, 3, self.rotationFrontPart4.rotTime, dt, not self.rotationFrontPart4Max);
        setRotation(self.rotationFrontPart4.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart5Max or self.rotationFrontPart5Min 
	if self.rotationFrontPart5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart5.maxRot, self.rotationFrontPart5.minRot, 3, self.rotationFrontPart5.rotTime, dt, not self.rotationFrontPart5Max);
        setRotation(self.rotationFrontPart5.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart6Max or self.rotationFrontPart6Min 
	if self.rotationFrontPart6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart6.maxRot, self.rotationFrontPart6.minRot, 3, self.rotationFrontPart6.rotTime, dt, not self.rotationFrontPart6Max);
        setRotation(self.rotationFrontPart6.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart7Max or self.rotationFrontPart7Min 
	if self.rotationFrontPart7 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart7.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart7.maxRot, self.rotationFrontPart7.minRot, 3, self.rotationFrontPart7.rotTime, dt, not self.rotationFrontPart7Max);
        setRotation(self.rotationFrontPart7.node, unpack(newRot));
    end;
	
	local doRotate = self.rotationFrontPart8Max or self.rotationFrontPart8Min 
	if self.rotationFrontPart8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationFrontPart8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationFrontPart8.maxRot, self.rotationFrontPart8.minRot, 3, self.rotationFrontPart8.rotTime, dt, not self.rotationFrontPart8Max);
        setRotation(self.rotationFrontPart8.node, unpack(newRot));
    end;
end;

function FrontThreePointHitch:onLeave()
end;

function FrontThreePointHitch:draw()

end;

function FrontThreePointHitch:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
