SetControlledWheelSpacingEvent = {};
SetControlledWheelSpacingEvent_mt = Class(SetControlledWheelSpacingEvent, Event);

InitEventClass(SetControlledWheelSpacingEvent, "SetControlledWheelSpacingEvent");

function SetControlledWheelSpacingEvent:emptyNew()
    local self = Event:new(SetControlledWheelSpacingEvent_mt);
    self.className="SetControlledWheelSpacingEvent";
    return self;
end;

function SetControlledWheelSpacingEvent:new(vehicle, isControlledWheelSpacingState)
    local self = SetControlledWheelSpacingEvent:emptyNew()
    self.vehicle = vehicle;
	self.isControlledWheelSpacingState = isControlledWheelSpacingState;
    return self;
end;

function SetControlledWheelSpacingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isControlledWheelSpacingState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetControlledWheelSpacingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isControlledWheelSpacingState);
end;

function SetControlledWheelSpacingEvent:run(connection)   
	self.vehicle:setControlledWheelSpacing(self.isControlledWheelSpacingState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetControlledWheelSpacingEvent:new(self.vehicle, self.isControlledWheelSpacingState), nil, connection, self.vehicle);
    end;
end;

function SetControlledWheelSpacingEvent.sendEvent(vehicle, isControlledWheelSpacingState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetControlledWheelSpacingEvent:new(vehicle, isControlledWheelSpacingState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetControlledWheelSpacingEvent:new(vehicle, isControlledWheelSpacingState));
		end;
	end;
end;