SetfWeightsEvent = {};
SetfWeightsEvent_mt = Class(SetfWeightsEvent, Event);

InitEventClass(SetfWeightsEvent, "SetfWeightsEvent");

function SetfWeightsEvent:emptyNew()
    local self = Event:new(SetfWeightsEvent_mt);
    self.className="SetfWeightsEvent";
    return self;
end;

function SetfWeightsEvent:new(vehicle, isfWeightsState)
    local self = SetfWeightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.isfWeightsState = isfWeightsState;
    return self;
end;

function SetfWeightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isfWeightsState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetfWeightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isfWeightsState);
end;

function SetfWeightsEvent:run(connection)   
	self.vehicle:setfWeights(self.isfWeightsState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetfWeightsEvent:new(self.vehicle, self.isfWeightsState), nil, connection, self.vehicle);
    end;
end;

function SetfWeightsEvent.sendEvent(vehicle, isfWeightsState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetfWeightsEvent:new(vehicle, isfWeightsState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetfWeightsEvent:new(vehicle, isfWeightsState));
		end;
	end;
end;