SetRWFenderEvent = {};
SetRWFenderEvent_mt = Class(SetRWFenderEvent, Event);

InitEventClass(SetRWFenderEvent, "SetRWFenderEvent");

function SetRWFenderEvent:emptyNew()
    local self = Event:new(SetRWFenderEvent_mt);
    self.className="SetRWFenderEvent";
    return self;
end;

function SetRWFenderEvent:new(vehicle, isRWFenderState)
    local self = SetRWFenderEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRWFenderState = isRWFenderState;
    return self;
end;

function SetRWFenderEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRWFenderState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRWFenderEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRWFenderState);
end;

function SetRWFenderEvent:run(connection)   
	self.vehicle:setRWFender(self.isRWFenderState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRWFenderEvent:new(self.vehicle, self.isRWFenderState), nil, connection, self.vehicle);
    end;
end;

function SetRWFenderEvent.sendEvent(vehicle, isRWFenderState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRWFenderEvent:new(vehicle, isRWFenderState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRWFenderEvent:new(vehicle, isRWFenderState));
		end;
	end;
end;