SetLFrameEvent = {};
SetLFrameEvent_mt = Class(SetLFrameEvent, Event);

InitEventClass(SetLFrameEvent, "SetLFrameEvent");

function SetLFrameEvent:emptyNew()
    local self = Event:new(SetLFrameEvent_mt);
    self.className="SetLFrameEvent";
    return self;
end;

function SetLFrameEvent:new(vehicle, isLFrameState)
    local self = SetLFrameEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLFrameState = isLFrameState;
    return self;
end;

function SetLFrameEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLFrameState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLFrameEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLFrameState);
end;

function SetLFrameEvent:run(connection)   
	self.vehicle:setLFrame(self.isLFrameState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLFrameEvent:new(self.vehicle, self.isLFrameState), nil, connection, self.vehicle);
    end;
end;

function SetLFrameEvent.sendEvent(vehicle, isLFrameState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLFrameEvent:new(vehicle, isLFrameState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLFrameEvent:new(vehicle, isLFrameState));
		end;
	end;
end;