SetFHitchEvent = {};
SetFHitchEvent_mt = Class(SetFHitchEvent, Event);

InitEventClass(SetFHitchEvent, "SetFHitchEvent");

function SetFHitchEvent:emptyNew()
    local self = Event:new(SetFHitchEvent_mt);
    self.className="SetFHitchEvent";
    return self;
end;

function SetFHitchEvent:new(vehicle, isFHitchState)
    local self = SetFHitchEvent:emptyNew()
    self.vehicle = vehicle;
	self.isFHitchState = isFHitchState;
    return self;
end;

function SetFHitchEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isFHitchState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetFHitchEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isFHitchState);
end;

function SetFHitchEvent:run(connection)   
	self.vehicle:setFHitch(self.isFHitchState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFHitchEvent:new(self.vehicle, self.isFHitchState), nil, connection, self.vehicle);
    end;
end;

function SetFHitchEvent.sendEvent(vehicle, isFHitchState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFHitchEvent:new(vehicle, isFHitchState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFHitchEvent:new(vehicle, isFHitchState));
		end;
	end;
end;