SetDualRAxleEvent = {};
SetDualRAxleEvent_mt = Class(SetDualRAxleEvent, Event);

InitEventClass(SetDualRAxleEvent, "SetDualRAxleEvent");

function SetDualRAxleEvent:emptyNew()
    local self = Event:new(SetDualRAxleEvent_mt);
    self.className="SetDualRAxleEvent";
    return self;
end;

function SetDualRAxleEvent:new(vehicle, isDualRAxleState)
    local self = SetDualRAxleEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDualRAxleState = isDualRAxleState;
    return self;
end;

function SetDualRAxleEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDualRAxleState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDualRAxleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDualRAxleState);
end;

function SetDualRAxleEvent:run(connection)   
	self.vehicle:setDualRAxle(self.isDualRAxleState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDualRAxleEvent:new(self.vehicle, self.isDualRAxleState), nil, connection, self.vehicle);
    end;
end;

function SetDualRAxleEvent.sendEvent(vehicle, isDualRAxleState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDualRAxleEvent:new(vehicle, isDualRAxleState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDualRAxleEvent:new(vehicle, isDualRAxleState));
		end;
	end;
end;